/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.reporting.Discrepancy;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;

public class NonGreedyNumberOfInvocationsInOrderChecker {
    private final InvocationsFinder finder;
    private final Reporter reporter;
    private final InvocationMarker marker;

    public NonGreedyNumberOfInvocationsInOrderChecker() {
        this(new InvocationsFinder(), new Reporter(), new InvocationMarker());
    }

    NonGreedyNumberOfInvocationsInOrderChecker(InvocationsFinder invocationsFinder, Reporter reporter, InvocationMarker invocationMarker) {
        this.finder = invocationsFinder;
        this.reporter = reporter;
        this.marker = invocationMarker;
    }

    public void check(List<Invocation> list, InvocationMatcher invocationMatcher, int n, InOrderContext inOrderContext) {
        Location location = null;
        for (int i = 0; i < n; ++i) {
            Invocation invocation = this.finder.findFirstMatchingUnverifiedInvocation(list, invocationMatcher, inOrderContext);
            if (invocation == null) {
                this.reporter.tooLittleActualInvocationsInOrder(new Discrepancy(n, i), invocationMatcher, location);
            }
            this.marker.markVerified(invocation, (CapturesArgumensFromInvocation)invocationMatcher);
            inOrderContext.markVerified(invocation);
            location = invocation.getLocation();
        }
    }
}

