/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import java.lang.reflect.Modifier;
import org.mockito.Mockito;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.creation.settings.CreationSettings;
import org.mockito.internal.handler.MockHandlerFactory;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.mockito.plugins.MockMaker;

public class MockUtil {
    private static final MockMaker mockMaker = Plugins.getMockMaker();

    public boolean isTypeMockable(Class<?> clazz) {
        return !clazz.isPrimitive() && !Modifier.isFinal(clazz.getModifiers());
    }

    public <T> T createMock(MockCreationSettings<T> mockCreationSettings) {
        InternalMockHandler internalMockHandler = new MockHandlerFactory().create(mockCreationSettings);
        T t = mockMaker.createMock(mockCreationSettings, internalMockHandler);
        Object object = mockCreationSettings.getSpiedInstance();
        if (object != null) {
            new LenientCopyTool().copyToMock(object, t);
        }
        return t;
    }

    public <T> void resetMock(T t) {
        InternalMockHandler<T> internalMockHandler = this.getMockHandler(t);
        MockCreationSettings mockCreationSettings = internalMockHandler.getMockSettings();
        InternalMockHandler internalMockHandler2 = new MockHandlerFactory().create(mockCreationSettings);
        mockMaker.resetMock(t, internalMockHandler2, mockCreationSettings);
    }

    public <T> InternalMockHandler<T> getMockHandler(T t) {
        if (t == null) {
            throw new NotAMockException("Argument should be a mock, but is null!");
        }
        if (this.isMockitoMock(t)) {
            MockHandler mockHandler = mockMaker.getHandler(t);
            return (InternalMockHandler)mockHandler;
        }
        throw new NotAMockException("Argument should be a mock, but is: " + t.getClass());
    }

    public boolean isMock(Object object) {
        return this.isMockitoMock(object);
    }

    public boolean isSpy(Object object) {
        return this.isMockitoMock(object) && this.getMockSettings(object).getDefaultAnswer() == Mockito.CALLS_REAL_METHODS;
    }

    private <T> boolean isMockitoMock(T t) {
        return mockMaker.getHandler(t) != null;
    }

    public MockName getMockName(Object object) {
        return this.getMockHandler(object).getMockSettings().getMockName();
    }

    public void maybeRedefineMockName(Object object, String string) {
        MockName mockName = this.getMockName(object);
        if (mockName.isDefault() && this.getMockHandler(object).getMockSettings() instanceof CreationSettings) {
            ((CreationSettings)this.getMockHandler(object).getMockSettings()).setMockName(new MockNameImpl(string));
        }
    }

    public MockCreationSettings getMockSettings(Object object) {
        return this.getMockHandler(object).getMockSettings();
    }
}

