/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.IOException;
import java.io.Serializable;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.MockitoCore;
import org.mockito.internal.creation.settings.CreationSettings;
import org.mockito.internal.stubbing.InvocationContainerImpl;
import org.mockito.internal.stubbing.StubbedInvocationMatcher;
import org.mockito.internal.stubbing.defaultanswers.ReturnsEmptyValues;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.reflection.GenericMetadataSupport;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;

public class ReturnsDeepStubs
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = -7105341425736035847L;

    @Override
    public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
        GenericMetadataSupport genericMetadataSupport = this.actualParameterizedType(invocationOnMock.getMock()).resolveGenericReturnType(invocationOnMock.getMethod());
        Class<?> clazz = genericMetadataSupport.rawType();
        if (!ReturnsDeepStubs.mockitoCore().isTypeMockable(clazz)) {
            return ReturnsDeepStubs.delegate().returnValueFor(clazz);
        }
        return this.deepStub(invocationOnMock, genericMetadataSupport);
    }

    private Object deepStub(InvocationOnMock invocationOnMock, GenericMetadataSupport genericMetadataSupport) throws Throwable {
        InternalMockHandler<Object> internalMockHandler = new MockUtil().getMockHandler(invocationOnMock.getMock());
        InvocationContainerImpl invocationContainerImpl = (InvocationContainerImpl)internalMockHandler.getInvocationContainer();
        for (StubbedInvocationMatcher stubbedInvocationMatcher : invocationContainerImpl.getStubbedInvocations()) {
            if (!invocationContainerImpl.getInvocationForStubbing().matches(stubbedInvocationMatcher.getInvocation())) continue;
            return stubbedInvocationMatcher.answer(invocationOnMock);
        }
        return this.recordDeepStubAnswer(this.newDeepStubMock(genericMetadataSupport, invocationOnMock.getMock()), invocationContainerImpl);
    }

    private Object newDeepStubMock(GenericMetadataSupport genericMetadataSupport, Object object) {
        MockCreationSettings mockCreationSettings = new MockUtil().getMockSettings(object);
        return ReturnsDeepStubs.mockitoCore().mock(genericMetadataSupport.rawType(), this.withSettingsUsing(genericMetadataSupport, mockCreationSettings));
    }

    private MockSettings withSettingsUsing(GenericMetadataSupport genericMetadataSupport, MockCreationSettings mockCreationSettings) {
        MockSettings mockSettings = genericMetadataSupport.hasRawExtraInterfaces() ? Mockito.withSettings().extraInterfaces(genericMetadataSupport.rawExtraInterfaces()) : Mockito.withSettings();
        return this.propagateSerializationSettings(mockSettings, mockCreationSettings).defaultAnswer(this.returnsDeepStubsAnswerUsing(genericMetadataSupport));
    }

    private MockSettings propagateSerializationSettings(MockSettings mockSettings, MockCreationSettings mockCreationSettings) {
        return mockSettings.serializable(mockCreationSettings.getSerializableMode());
    }

    private ReturnsDeepStubs returnsDeepStubsAnswerUsing(GenericMetadataSupport genericMetadataSupport) {
        return new ReturnsDeepStubsSerializationFallback(genericMetadataSupport);
    }

    private Object recordDeepStubAnswer(Object object, InvocationContainerImpl invocationContainerImpl) throws Throwable {
        invocationContainerImpl.addAnswer(new DeeplyStubbedAnswer(object), false);
        return object;
    }

    protected GenericMetadataSupport actualParameterizedType(Object object) {
        CreationSettings creationSettings = (CreationSettings)new MockUtil().getMockHandler(object).getMockSettings();
        return GenericMetadataSupport.inferFrom(creationSettings.getTypeToMock());
    }

    private static MockitoCore mockitoCore() {
        return LazyHolder.MOCKITO_CORE;
    }

    private static ReturnsEmptyValues delegate() {
        return LazyHolder.DELEGATE;
    }

    private static class LazyHolder {
        private static final MockitoCore MOCKITO_CORE = new MockitoCore();
        private static final ReturnsEmptyValues DELEGATE = new ReturnsEmptyValues();

        private LazyHolder() {
        }
    }

    private static class DeeplyStubbedAnswer
    implements Answer<Object>,
    Serializable {
        private final Object mock;

        DeeplyStubbedAnswer(Object object) {
            this.mock = object;
        }

        @Override
        public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
            return this.mock;
        }
    }

    private static class ReturnsDeepStubsSerializationFallback
    extends ReturnsDeepStubs
    implements Serializable {
        private final GenericMetadataSupport returnTypeGenericMetadata;

        public ReturnsDeepStubsSerializationFallback(GenericMetadataSupport genericMetadataSupport) {
            this.returnTypeGenericMetadata = genericMetadataSupport;
        }

        @Override
        protected GenericMetadataSupport actualParameterizedType(Object object) {
            return this.returnTypeGenericMetadata;
        }

        private Object writeReplace() throws IOException {
            return Mockito.RETURNS_DEEP_STUBS;
        }
    }
}

