/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.HandlerFactory;
import com.puppycrawl.tools.checkstyle.checks.indentation.PrimordialHandler;

public class IndentationCheck
extends Check {
    private static final int DEFAULT_INDENTATION = 4;
    private int mBasicOffset = 4;
    private int mCaseIndentationAmount = 4;
    private int mBraceAdjustment;
    private int mThrowsIndentationAmount = 4;
    private int mArrayInitIndentationAmount = 4;
    private int mLineWrappingIndentation = 4;
    private final FastStack<ExpressionHandler> mHandlers = FastStack.newInstance();
    private final HandlerFactory mHandlerFactory = new HandlerFactory();

    public void setBasicOffset(int aBasicOffset) {
        this.mBasicOffset = aBasicOffset;
    }

    public int getBasicOffset() {
        return this.mBasicOffset;
    }

    public void setBraceAdjustment(int aAdjustmentAmount) {
        this.mBraceAdjustment = aAdjustmentAmount;
    }

    public int getBraceAdjustement() {
        return this.mBraceAdjustment;
    }

    public void setCaseIndent(int aAmount) {
        this.mCaseIndentationAmount = aAmount;
    }

    public int getCaseIndent() {
        return this.mCaseIndentationAmount;
    }

    public void setThrowsIndent(int aThrowsIndent) {
        this.mThrowsIndentationAmount = aThrowsIndent;
    }

    public int getThrowsIndent() {
        return this.mThrowsIndentationAmount;
    }

    public void setArrayInitIndent(int aArrayInitIndent) {
        this.mArrayInitIndentationAmount = aArrayInitIndent;
    }

    public int getArrayInitIndent() {
        return this.mArrayInitIndentationAmount;
    }

    public int getLineWrappingIndentation() {
        return this.mLineWrappingIndentation;
    }

    public void setLineWrappingIndentation(int aLineWrappingIndentation) {
        this.mLineWrappingIndentation = aLineWrappingIndentation;
    }

    public void indentationLog(int aLine, String aKey, Object ... aArgs) {
        super.log(aLine, aKey, aArgs);
    }

    public int getIndentationTabWidth() {
        return this.getTabWidth();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.mHandlerFactory.getHandledTypes();
    }

    @Override
    public void beginTree(DetailAST aAst) {
        this.mHandlerFactory.clearCreatedHandlers();
        this.mHandlers.clear();
        this.mHandlers.push(new PrimordialHandler(this));
    }

    @Override
    public void visitToken(DetailAST aAST) {
        ExpressionHandler handler = this.mHandlerFactory.getHandler(this, aAST, this.mHandlers.peek());
        this.mHandlers.push(handler);
        try {
            handler.checkIndentation();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    @Override
    public void leaveToken(DetailAST aAST) {
        this.mHandlers.pop();
    }

    final HandlerFactory getHandlerFactory() {
        return this.mHandlerFactory;
    }
}

