/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.ClassListBuilder;
import org.codehaus.mojo.animal_sniffer.SignatureChecker;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.maven.BuildSignaturesMojo;
import org.codehaus.mojo.animal_sniffer.maven.MavenLogger;
import org.codehaus.mojo.animal_sniffer.maven.Signature;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="check", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CheckSignatureMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    protected File outputDirectory;
    @Parameter(required=true)
    protected Signature signature;
    @Parameter
    protected String[] ignores;
    @Parameter
    protected String[] annotations;
    @Parameter(defaultValue="true")
    protected boolean ignoreDependencies;
    @Parameter
    private String[] includeDependencies = null;
    @Parameter
    private String[] excludeDependencies = null;
    @Parameter(defaultValue="false", property="animal.sniffer.skip")
    protected boolean skip;
    @Component
    protected ArtifactResolver resolver;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;
    @Component
    protected ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Signature checking is skipped.");
            return;
        }
        try {
            if (StringUtils.isBlank((String)this.signature.getVersion())) {
                this.getLog().debug((CharSequence)("Resolving signature " + this.signature.getGroupId() + ":" + this.signature.getArtifactId() + " version from dependencies"));
                String source = "dependencies";
                Dependency match = CheckSignatureMojo.findMatchingDependency(this.signature, this.project.getDependencies());
                if (match == null) {
                    this.getLog().debug((CharSequence)("Resolving signature " + this.signature.getGroupId() + ":" + this.signature.getArtifactId() + " version from dependencyManagement"));
                    source = "dependencyManagement";
                    match = CheckSignatureMojo.findMatchingDependency(this.signature, this.project.getDependencyManagement().getDependencies());
                }
                if (match != null) {
                    this.getLog().info((CharSequence)("Resolved signature " + this.signature.getGroupId() + ":" + this.signature.getArtifactId() + " version as " + match.getVersion() + " from " + source));
                    this.signature.setVersion(match.getVersion());
                }
            }
            this.getLog().info((CharSequence)("Checking unresolved references to " + this.signature));
            Artifact a = this.signature.createArtifact(this.artifactFactory);
            this.resolver.resolve(a, this.project.getRemoteArtifactRepositories(), this.localRepository);
            Set ignoredPackages = this.buildPackageList();
            if (this.ignores != null) {
                for (int i = 0; i < this.ignores.length; ++i) {
                    String ignore = this.ignores[i];
                    if (ignore == null) continue;
                    ignoredPackages.add(ignore.replace('.', '/'));
                }
            }
            SignatureChecker signatureChecker = new SignatureChecker((InputStream)new FileInputStream(a.getFile()), ignoredPackages, (Logger)new MavenLogger(this.getLog()));
            signatureChecker.setCheckJars(false);
            ArrayList<File> sourcePaths = new ArrayList<File>();
            for (String path : this.project.getCompileSourceRoots()) {
                sourcePaths.add(new File(path));
            }
            signatureChecker.setSourcePath(sourcePaths);
            if (this.annotations != null) {
                signatureChecker.setAnnotationTypes(Arrays.asList(this.annotations));
            }
            signatureChecker.process(this.outputDirectory);
            if (signatureChecker.isSignatureBroken()) {
                throw new MojoFailureException("Signature errors found. Verify them and ignore them with the proper annotation if needed.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to check signatures", (Exception)e);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to obtain signature: " + this.signature, (Exception)((Object)e));
        }
    }

    private static Dependency findMatchingDependency(Signature signature, List dependencies) {
        Dependency match = null;
        for (Dependency d : dependencies) {
            if (StringUtils.isBlank((String)d.getVersion()) || !StringUtils.equals((String)d.getGroupId(), (String)signature.getGroupId()) || !StringUtils.equals((String)d.getArtifactId(), (String)signature.getArtifactId())) continue;
            if ("signature".equals(d.getType())) {
                match = d;
                break;
            }
            if ("pom".equals(d.getType()) && (match == null || "jar".equals(match.getType()))) {
                match = d;
            }
            if (!"jar".equals(d.getType()) || match != null) continue;
            match = d;
        }
        return match;
    }

    private Set buildPackageList() throws IOException {
        ClassListBuilder plb = new ClassListBuilder((Logger)new MavenLogger(this.getLog()));
        this.apply((ClassFileVisitor)plb);
        return plb.getPackages();
    }

    private void apply(ClassFileVisitor v) throws IOException {
        v.process(this.outputDirectory);
        if (this.ignoreDependencies) {
            PatternIncludesArtifactFilter includesFilter = this.includeDependencies == null ? null : new PatternIncludesArtifactFilter(Arrays.asList(this.includeDependencies));
            PatternExcludesArtifactFilter excludesFilter = this.excludeDependencies == null ? null : new PatternExcludesArtifactFilter(Arrays.asList(this.excludeDependencies));
            this.getLog().debug((CharSequence)"Building list of classes from dependencies");
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!artifact.getArtifactHandler().isAddedToClasspath()) {
                    this.getLog().debug((CharSequence)("Skipping artifact " + BuildSignaturesMojo.artifactId(artifact) + " as it is not added to the classpath."));
                    continue;
                }
                if (!("compile".equals(artifact.getScope()) || "provided".equals(artifact.getScope()) || "system".equals(artifact.getScope()))) {
                    this.getLog().debug((CharSequence)("Skipping artifact " + BuildSignaturesMojo.artifactId(artifact) + " as it is not on the compile classpath."));
                    continue;
                }
                if (includesFilter != null && !includesFilter.include(artifact)) {
                    this.getLog().debug((CharSequence)("Skipping classes in artifact " + BuildSignaturesMojo.artifactId(artifact) + " as it does not match include rules."));
                    continue;
                }
                if (excludesFilter != null && !excludesFilter.include(artifact)) {
                    this.getLog().debug((CharSequence)("Skipping classes in artifact " + BuildSignaturesMojo.artifactId(artifact) + " as it does matches exclude rules."));
                    continue;
                }
                this.getLog().debug((CharSequence)("Adding classes in artifact " + BuildSignaturesMojo.artifactId(artifact) + " to the ignores"));
                v.process(artifact.getFile());
            }
        }
    }
}

