/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.license;

import java.util.Locale;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.analysis.license.BaseLicense;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;

public class FullTextMatchingLicense
extends BaseLicense
implements IHeaderMatcher {
    private static final int DEFAULT_INITIAL_LINE_LENGTH = 20;
    private String fullText;
    private String firstLine;
    private boolean seenFirstLine = false;
    private final StringBuilder buffer = new StringBuilder();

    public FullTextMatchingLicense() {
    }

    protected FullTextMatchingLicense(MetaData.Datum licenseFamilyCategory, MetaData.Datum licenseFamilyName, String notes, String fullText) {
        super(licenseFamilyCategory, licenseFamilyName, notes);
        this.setFullText(fullText);
    }

    public final void setFullText(String text) {
        int offset = text.indexOf(10);
        if (offset == -1) {
            offset = Math.min(20, text.length());
        }
        this.firstLine = FullTextMatchingLicense.prune(text.substring(0, offset)).toLowerCase(Locale.ENGLISH);
        this.fullText = FullTextMatchingLicense.prune(text).toLowerCase(Locale.ENGLISH);
        this.init();
    }

    public final boolean hasFullText() {
        return this.fullText != null;
    }

    public boolean match(Document subject, String line) throws RatHeaderAnalysisException {
        int offset;
        String inputToMatch = FullTextMatchingLicense.prune(line).toLowerCase(Locale.ENGLISH);
        if (this.seenFirstLine) {
            this.buffer.append(inputToMatch);
        } else {
            offset = inputToMatch.indexOf(this.firstLine);
            if (offset >= 0) {
                this.buffer.append(inputToMatch.substring(offset));
                this.seenFirstLine = true;
            } else {
                return false;
            }
        }
        if (this.buffer.length() >= this.fullText.length()) {
            if (this.buffer.toString().contains(this.fullText)) {
                this.reportOnLicense(subject);
                return true;
            }
            offset = this.buffer.substring(1).toString().indexOf(this.firstLine);
            if (offset >= 0) {
                this.buffer.delete(0, offset);
            } else {
                this.init();
            }
        }
        return false;
    }

    public void reset() {
        this.init();
    }

    private void init() {
        this.buffer.setLength(0);
        this.seenFirstLine = false;
    }
}

