/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="resources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class ResourcesMojo
extends AbstractMojo
implements Contextualizable {
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.resources}", required=true, readonly=true)
    private List<Resource> resources;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.filters}", readonly=true)
    protected List<String> buildFilters;
    @Parameter
    protected List<String> filters;
    @Parameter(defaultValue="true")
    protected boolean useBuildFilters;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="maven.resources.escapeString")
    protected String escapeString;
    @Parameter(property="maven.resources.overwrite", defaultValue="false")
    private boolean overwrite;
    @Parameter(property="maven.resources.includeEmptyDirs", defaultValue="false")
    protected boolean includeEmptyDirs;
    @Parameter
    protected List<String> nonFilteredFileExtensions;
    @Parameter(property="maven.resources.escapeWindowsPaths", defaultValue="true")
    protected boolean escapeWindowsPaths;
    @Parameter
    protected List<String> delimiters;
    @Parameter(defaultValue="true")
    protected boolean useDefaultDelimiters;
    @Parameter
    private List<String> mavenFilteringHints;
    private PlexusContainer plexusContainer;
    private List<MavenResourcesFiltering> mavenFilteringComponents = new ArrayList<MavenResourcesFiltering>();
    @Parameter(property="maven.resources.supportMultiLineFiltering", defaultValue="false")
    private boolean supportMultiLineFiltering;

    public void contextualize(Context context) throws ContextException {
        this.plexusContainer = (PlexusContainer)context.get((Object)"plexus");
    }

    public void execute() throws MojoExecutionException {
        try {
            if (StringUtils.isEmpty((String)this.encoding) && this.isFilteringEnabled(this.getResources())) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            List<String> filters = this.getCombinedFiltersList();
            MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(this.getResources(), this.getOutputDirectory(), this.project, this.encoding, filters, Collections.emptyList(), this.session);
            mavenResourcesExecution.setEscapeWindowsPaths(this.escapeWindowsPaths);
            mavenResourcesExecution.setInjectProjectBuildFilters(false);
            mavenResourcesExecution.setEscapeString(this.escapeString);
            mavenResourcesExecution.setOverwrite(this.overwrite);
            mavenResourcesExecution.setIncludeEmptyDirs(this.includeEmptyDirs);
            mavenResourcesExecution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
            if (this.delimiters != null && !this.delimiters.isEmpty()) {
                LinkedHashSet<String> delims = new LinkedHashSet<String>();
                if (this.useDefaultDelimiters) {
                    delims.addAll(mavenResourcesExecution.getDelimiters());
                }
                for (String delim : this.delimiters) {
                    if (delim == null) {
                        delims.add("${*}");
                        continue;
                    }
                    delims.add(delim);
                }
                mavenResourcesExecution.setDelimiters(delims);
            }
            if (this.nonFilteredFileExtensions != null) {
                mavenResourcesExecution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
            }
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
            this.executeUserFilterComponents(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void executeUserFilterComponents(MavenResourcesExecution mavenResourcesExecution) throws MojoExecutionException, MavenFilteringException {
        if (this.mavenFilteringHints != null) {
            for (String hint : this.mavenFilteringHints) {
                try {
                    this.mavenFilteringComponents.add((MavenResourcesFiltering)this.plexusContainer.lookup(MavenResourcesFiltering.class.getName(), hint));
                }
                catch (ComponentLookupException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            }
        } else {
            this.getLog().debug((CharSequence)"no use filter components");
        }
        if (this.mavenFilteringComponents != null && !this.mavenFilteringComponents.isEmpty()) {
            this.getLog().debug((CharSequence)"execute user filters");
            for (MavenResourcesFiltering filter : this.mavenFilteringComponents) {
                filter.filterResources(mavenResourcesExecution);
            }
        }
    }

    protected List<String> getCombinedFiltersList() {
        if (this.filters == null || this.filters.isEmpty()) {
            return this.useBuildFilters ? this.buildFilters : null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.useBuildFilters && this.buildFilters != null && !this.buildFilters.isEmpty()) {
            result.addAll(this.buildFilters);
        }
        result.addAll(this.filters);
        return result;
    }

    private boolean isFilteringEnabled(Collection<Resource> resources) {
        if (resources != null) {
            for (Resource resource : resources) {
                if (!resource.isFiltering()) continue;
                return true;
            }
        }
        return false;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public List<String> getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(List<String> delimiters) {
        this.delimiters = delimiters;
    }

    public boolean isUseDefaultDelimiters() {
        return this.useDefaultDelimiters;
    }

    public void setUseDefaultDelimiters(boolean useDefaultDelimiters) {
        this.useDefaultDelimiters = useDefaultDelimiters;
    }
}

