/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractRequireFiles;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequireFilesSize
extends AbstractRequireFiles {
    long maxsize = 10000L;
    long minsize = 0L;
    private String errorMsg;
    private Log log;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        this.log = helper.getLog();
        if (this.files.length == 0) {
            try {
                MavenProject project = (MavenProject)helper.evaluate("${project}");
                this.files = new File[1];
                this.files[0] = project.getArtifact().getFile();
                super.execute(helper);
            }
            catch (ExpressionEvaluationException e) {
                throw new EnforcerRuleException("Unable to retrieve the project.", (Exception)((Object)e));
            }
        } else {
            super.execute(helper);
        }
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule cachedRule) {
        return false;
    }

    boolean checkFile(File file) {
        if (file == null) {
            return true;
        }
        if (file.exists()) {
            long length = file.length();
            if (length < this.minsize) {
                this.errorMsg = file + " size (" + length + ") too small. Min. is " + this.minsize;
                return false;
            }
            if (length > this.maxsize) {
                this.errorMsg = file + " size (" + length + ") too large. Max. is " + this.maxsize;
                return false;
            }
            this.log.debug((CharSequence)(file + " size (" + length + ") is OK (" + (this.minsize == this.maxsize || this.minsize == 0L ? "max. " + this.maxsize : "between " + this.minsize + " and " + this.maxsize) + " byte)."));
            return true;
        }
        this.errorMsg = file + " does not exist!";
        return false;
    }

    String getErrorMsg() {
        return this.errorMsg;
    }
}

