/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.util.xml;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;

public class XsdUtils {
    public static final String NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String PREFIX = "xsd";
    private static DateFormat _FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final QName ANY_TYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "anyType", "xsd");
    public static final QName ANY_URI_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "anyURI", "xsd");
    public static final QName ATTRIBUTE_GROUP_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "attributeGroup", "xsd");
    public static final QName ATTRIBUTE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "attribute", "xsd");
    public static final QName BOOLEAN_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xsd");
    public static final QName COMPLEX_TYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "complexType", "xsd");
    public static final QName COMPLEX_CONTENT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "complexContent", "xsd");
    public static final QName EXTENSION_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "extension", "xsd");
    public static final QName DATE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "date", "xsd");
    public static final QName DATE_TIME_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xsd");
    public static final QName DOUBLE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "double", "xsd");
    public static final QName DURATION_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "duration", "xsd");
    public static final QName ELEMENT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "element", "xsd");
    public static final QName FLOAT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "float", "xsd");
    public static final QName IMPORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "import", "xsd");
    public static final QName INCLUDE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "include", "xsd");
    public static final QName INT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd");
    public static final QName INTEGER_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "integer", "xsd");
    public static final QName LONG_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "long", "xsd");
    public static final String MAX_OCCURS = "maxOccurs";
    public static final String MIN_OCCURS = "minOccurs";
    public static final long MS_IN_A_DAY = 86400000L;
    public static final long MS_IN_A_HOUR = 3600000L;
    public static final long MS_IN_A_MINUTE = 60000L;
    public static final long MS_IN_A_MONTH = -1665223296L;
    public static final long MS_IN_A_YEAR = 1492154928L;
    public static final String NAME = "name";
    public static final String NAMESPACE = "namespace";
    public static final QName NC_NAME_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "NCName", "xsd");
    public static final QName NIL_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "nil", "xsd");
    public static final String NILLABLE = "nillable";
    public static final QName QNAME_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "QName", "xsd");
    public static final String REF = "ref";
    public static final String BASE = "base";
    public static final String SCHEMA_LOCATION = "schemaLocation";
    public static final QName SCHEMA_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "schema", "xsd");
    public static final QName SEQUENCE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "sequence", "xsd");
    public static final QName SHORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "short", "xsd");
    public static final QName SIMPLE_TYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "simpleType", "xsd");
    public static final QName STRING_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd");
    public static final String TYPE = "type";
    public static final String UNBOUNDED = "unbounded";

    public static String getDuration(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        long totalTime = afterTime - beforeTime;
        return XsdUtils.getDuration(totalTime);
    }

    public static String getDuration(long totalTime) {
        long days;
        long months;
        StringBuffer duration = new StringBuffer();
        if (totalTime < 0L) {
            duration.append('-');
        }
        duration.append('P');
        long years = totalTime / 1492154928L;
        if (years > 0L) {
            duration.append(years);
            duration.append('Y');
            totalTime -= years * 1492154928L;
        }
        if ((months = totalTime / -1665223296L) > 0L) {
            duration.append(months);
            duration.append('M');
            totalTime -= months * -1665223296L;
        }
        if ((days = totalTime / 86400000L) > 0L) {
            duration.append(days);
            duration.append('D');
            totalTime -= days * 86400000L;
        }
        if (totalTime >= 1000L) {
            double seconds;
            long minutes;
            duration.append('T');
            long hours = totalTime / 3600000L;
            if (hours > 0L) {
                duration.append(hours);
                duration.append('H');
                totalTime -= hours * 3600000L;
            }
            if ((minutes = totalTime / 60000L) > 0L) {
                duration.append(minutes);
                duration.append('M');
                totalTime -= minutes * 60000L;
            }
            if ((seconds = (double)totalTime / 1000.0) > 1.0) {
                duration.append(seconds);
                duration.append('S');
            }
        }
        return duration.toString();
    }

    public static long getDuration(String durationString) {
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        double seconds = 0.0;
        boolean isNegative = false;
        int start = 0;
        if (durationString.startsWith("-")) {
            isNegative = true;
            ++start;
        }
        if (durationString.indexOf(80) != start) {
            throw new IllegalArgumentException(durationString);
        }
        ++start;
        int end = durationString.indexOf(89);
        if (end >= 0) {
            String yearsString = durationString.substring(start, end);
            years = Integer.parseInt(yearsString);
            start = end + 1;
        }
        end = durationString.indexOf(77);
        int time = durationString.indexOf(84);
        if (end >= 0 && (time == -1 || time > end)) {
            String monthsString = durationString.substring(start, end);
            months = Integer.parseInt(monthsString);
            start = end + 1;
        }
        if ((end = durationString.indexOf(68)) >= 0) {
            String daysString = durationString.substring(start, end);
            days = Integer.parseInt(daysString);
            start = end + 1;
        }
        if (start != durationString.length()) {
            if (durationString.charAt(start) != 'T') {
                throw new IllegalArgumentException(durationString);
            }
            if (++start == durationString.length()) {
                throw new IllegalArgumentException(durationString);
            }
            end = durationString.indexOf(72);
            if (end >= 0) {
                String hoursString = durationString.substring(start, end);
                hours = Integer.parseInt(hoursString);
                start = end + 1;
            }
            if ((end = durationString.indexOf(77)) >= 0) {
                String minString = durationString.substring(start, end);
                minutes = Integer.parseInt(minString);
                start = end + 1;
            }
            if ((end = durationString.indexOf(83)) >= 0) {
                String secString = durationString.substring(start, end);
                seconds = Double.parseDouble(secString);
            }
        }
        double totalMilliseconds = (double)((long)years * 1492154928L + (long)months * -1665223296L + (long)days * 86400000L + (long)hours * 3600000L + (long)minutes * 60000L) + seconds * 1000.0;
        if (isNegative) {
            totalMilliseconds *= -1.0;
        }
        return (long)totalMilliseconds;
    }

    public static Date getLocalTime(String dateTimeString) throws ParseException {
        return _FORMATTER.parse(dateTimeString);
    }

    public static String getLocalTimeString() {
        return XsdUtils.getLocalTimeString(new Date());
    }

    public static String getLocalTimeString(Date date) {
        String dateWithoutTimeZone = _FORMATTER.format(date);
        TimeZone timeZone = _FORMATTER.getTimeZone();
        long offset = timeZone.getOffset(date.getTime());
        char sign = offset < 0L ? (char)'-' : '+';
        offset = Math.abs(offset);
        long hours = offset / 3600000L;
        long minutes = offset % 3600000L / 60000L;
        int length = dateWithoutTimeZone.length() + 6;
        StringBuffer buffer = new StringBuffer(length);
        DecimalFormat twoDigits = new DecimalFormat("00");
        buffer.append(dateWithoutTimeZone);
        buffer.append(sign);
        buffer.append(twoDigits.format(hours));
        buffer.append(':');
        buffer.append(twoDigits.format(minutes));
        return buffer.toString();
    }
}

