/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.EventListener;
import javax.swing.JList;
import javax.swing.JToolTip;
import javax.swing.ListModel;
import lcmc.utilities.ComponentWithTest;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;

public final class MyList<E>
extends JList<E>
implements ComponentWithTest {
    private static final long serialVersionUID = 1L;
    private JToolTip toolTip = this.createToolTip();
    private final Robot robot;
    private static final GraphicsDevice SCREEN_DEVICE = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private Color toolTipBackground = null;

    public MyList(ListModel<E> dataModel, Color bg) {
        super(dataModel);
        Robot r = null;
        try {
            r = new Robot(SCREEN_DEVICE);
        }
        catch (AWTException e) {
            Tools.appWarning("Robot error");
        }
        this.robot = r;
        this.setBackground(bg);
    }

    @Override
    public JToolTip createToolTip() {
        if (this.toolTip != null) {
            this.toolTip.setComponent(null);
        }
        this.toolTip = super.createToolTip();
        if (this.toolTipBackground != null) {
            this.toolTip.setBackground(this.toolTipBackground);
        }
        return this.toolTip;
    }

    @Override
    public void setToolTipBackground(Color toolTipBackground) {
        this.toolTipBackground = toolTipBackground;
    }

    @Override
    public void setToolTipText(String toolTipText) {
        if (toolTipText == null) {
            return;
        }
        super.setToolTipText(toolTipText);
        this.toolTip.setTipText(toolTipText);
        if (this.toolTip != null && this.toolTip.isShowing() && this.robot != null) {
            int x2;
            int x1;
            GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int xOffset = 0;
            if (devices.length >= 2 && (x1 = devices[0].getDefaultConfiguration().getBounds().x) > (x2 = devices[1].getDefaultConfiguration().getBounds().x)) {
                xOffset = -x1;
            }
            Point p = MouseInfo.getPointerInfo().getLocation();
            this.robot.mouseMove((int)((Point2D)p).getX() + xOffset - 1, (int)((Point2D)p).getY());
            this.robot.mouseMove((int)((Point2D)p).getX() + xOffset + 1, (int)((Point2D)p).getY());
            this.robot.mouseMove((int)((Point2D)p).getX() + xOffset, (int)((Point2D)p).getY());
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        Point screenLocation = this.getLocationOnScreen();
        Rectangle sBounds = Tools.getScreenBounds(this);
        Dimension size = this.toolTip.getPreferredSize();
        if (screenLocation.x + size.width + event.getX() + 5 > sBounds.width) {
            return new Point(event.getX() - size.width - 5, event.getY() + 20);
        }
        return new Point(event.getX() + 5, event.getY() + 20);
    }

    void cleanup() {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            MyMenuItem m = (MyMenuItem)this.getModel().getElementAt(i);
            m.cleanup();
        }
        for (MouseListener mouseListener : this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : this.getKeyListeners()) {
            this.removeKeyListener((KeyListener)eventListener);
        }
        for (EventListener eventListener : this.getMouseMotionListeners()) {
            this.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        this.toolTip.setComponent(null);
    }
}

