/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.lvm;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.Cluster;
import lcmc.data.Host;
import lcmc.gui.Browser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

public final class PVCreate
extends WizardDialog {
    private static final long serialVersionUID = 1L;
    private final MyButton createButton = new MyButton("Create PV");
    private final BlockDevInfo blockDevInfo;
    private Map<Host, JCheckBox> hostCheckBoxes = null;
    private static final String PV_CREATE_DESCRIPTION = "Initialize a disk or partition for use by LVM.";
    private static final int CREATE_TIMEOUT = 5000;

    public PVCreate(BlockDevInfo blockDevInfo) {
        super(null);
        this.blockDevInfo = blockDevInfo;
    }

    @Override
    protected void finishDialog() {
    }

    @Override
    public WizardDialog nextDialog() {
        return null;
    }

    @Override
    protected String getDialogTitle() {
        return "Create PV";
    }

    @Override
    protected String getDescription() {
        return PV_CREATE_DESCRIPTION;
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[0]);
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        this.makeDefaultAndRequestFocusLater(this.createButton);
    }

    protected void checkButtons() {
        if (!this.blockDevInfo.getBlockDevice().isPhysicalVolume()) {
            SwingUtilities.invokeLater(new EnableCreateRunnable(true));
        }
    }

    @Override
    protected JComponent getInputPane() {
        this.createButton.setEnabled(false);
        JPanel pane = new JPanel(new SpringLayout());
        JPanel inputPane = new JPanel(new SpringLayout());
        inputPane.setBackground(Browser.BUTTON_PANEL_BACKGROUND);
        inputPane.add(new JLabel("Block Device:"));
        inputPane.add(new JLabel(this.blockDevInfo.getName()));
        this.createButton.addActionListener(new CreateActionListener());
        inputPane.add(this.createButton);
        SpringUtilities.makeCompactGrid(inputPane, 1, 3, 1, 1, 1, 1);
        pane.add(inputPane);
        JPanel hostsPane = new JPanel(new FlowLayout(0));
        Cluster cluster = this.blockDevInfo.getHost().getCluster();
        this.hostCheckBoxes = Tools.getHostCheckBoxes(cluster);
        hostsPane.add(new JLabel("Select Hosts: "));
        for (Host h : this.hostCheckBoxes.keySet()) {
            this.hostCheckBoxes.get(h).addItemListener(new ItemChangeListener(true));
            BlockDevInfo oBdi = this.blockDevInfo.getBrowser().getDrbdGraph().findBlockDevInfo(h.getName(), this.blockDevInfo.getName());
            if (this.blockDevInfo.getHost() == h) {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(true);
            } else if (oBdi == null || oBdi.getBlockDevice().isDrbd() || oBdi.getBlockDevice().isPhysicalVolume()) {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(false);
            } else {
                this.hostCheckBoxes.get(h).setEnabled(true);
                this.hostCheckBoxes.get(h).setSelected(false);
            }
            hostsPane.add(this.hostCheckBoxes.get(h));
        }
        JScrollPane sp = new JScrollPane(hostsPane);
        sp.setPreferredSize(new Dimension(0, 45));
        pane.add(sp);
        pane.add(this.getProgressBarPane(null));
        pane.add(this.getAnswerPane(""));
        SpringUtilities.makeCompactGrid(pane, 4, 1, 0, 0, 0, 0);
        this.checkButtons();
        return pane;
    }

    private boolean pvCreate(Host host, BlockDevInfo bdi) {
        boolean ret = bdi.pvCreate(false);
        if (ret) {
            this.answerPaneAddText("Physical volume " + bdi.getName() + " was successfully created " + " on " + host.getName() + ".");
        } else {
            this.answerPaneAddTextError("Creating of physical volume " + bdi.getName() + " on " + host.getName() + " failed.");
        }
        return ret;
    }

    private class ItemChangeListener
    implements ItemListener {
        private final boolean onDeselect;

        public ItemChangeListener(boolean onDeselect) {
            this.onDeselect = onDeselect;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 || this.onDeselect) {
                PVCreate.this.checkButtons();
            }
        }
    }

    private class CreateRunnable
    implements Runnable {
        private CreateRunnable() {
        }

        @Override
        public void run() {
            Tools.invokeAndWait(new EnableCreateRunnable(false));
            PVCreate.this.disableComponents();
            PVCreate.this.getProgressBar().start(5000 * PVCreate.this.hostCheckBoxes.size());
            boolean oneFailed = false;
            for (Host h : PVCreate.this.hostCheckBoxes.keySet()) {
                boolean ret;
                BlockDevInfo oBdi;
                if (!((JCheckBox)PVCreate.this.hostCheckBoxes.get(h)).isSelected() || (oBdi = PVCreate.this.blockDevInfo.getBrowser().getDrbdGraph().findBlockDevInfo(h.getName(), PVCreate.this.blockDevInfo.getName())) == null || (ret = PVCreate.this.pvCreate(h, oBdi))) continue;
                oneFailed = true;
            }
            PVCreate.this.enableComponents();
            if (oneFailed) {
                for (Host h : PVCreate.this.hostCheckBoxes.keySet()) {
                    h.getBrowser().getClusterBrowser().updateHWInfo(h);
                }
                PVCreate.this.checkButtons();
                PVCreate.this.progressBarDoneError();
            } else {
                PVCreate.this.progressBarDone();
                PVCreate.this.disposeDialog();
                for (Host h : PVCreate.this.hostCheckBoxes.keySet()) {
                    h.getBrowser().getClusterBrowser().updateHWInfo(h);
                }
            }
        }
    }

    private class CreateActionListener
    implements ActionListener {
        private CreateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Thread thread = new Thread(new CreateRunnable());
            thread.start();
        }
    }

    private class EnableCreateRunnable
    implements Runnable {
        private final boolean enable;

        public EnableCreateRunnable(boolean enable) {
            this.enable = enable;
        }

        @Override
        public void run() {
            boolean e = this.enable;
            PVCreate.this.createButton.setEnabled(e);
        }
    }
}

