/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lcmc.data.Host;
import lcmc.gui.SSHGui;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.Devices;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.utilities.CancelCallback;
import lcmc.utilities.ConnectionCallback;
import lcmc.utilities.Tools;

public class SSH
extends DialogHost {
    private static final long serialVersionUID = 1L;

    public SSH(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    private String connectHost() {
        String res = null;
        SSHGui sshGui = new SSHGui(this.getDialogPanel(), this.getHost(), this.getProgressBar());
        this.getHost().connect(sshGui, this.getProgressBar(), new ConnectionCallback(){

            @Override
            public void done(int flag) {
                Tools.debug(this, "callback done flag: " + flag, 1);
                SSH.this.getHost().setConnected();
                SSH.this.progressBarDone();
                SSH.this.answerPaneSetText(Tools.getString("Dialog.Host.SSH.Connected"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SSH.this.buttonClass(SSH.this.nextButton()).pressButton();
                    }
                });
            }

            @Override
            public void doneError(final String errorText) {
                SSH.this.getHost().setConnected();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SSH.this.printErrorAndRetry(Tools.getString("Dialog.Host.SSH.NotConnected") + "\n" + errorText);
                    }
                });
            }
        });
        this.getProgressBar().setCancelEnabled(true);
        return res;
    }

    @Override
    public WizardDialog nextDialog() {
        return new Devices(this.getPreviousDialog(), this.getHost());
    }

    @Override
    protected final void initDialog() {
        super.initDialog();
        this.enableComponentsLater(this.nextButtons());
    }

    @Override
    protected final void initDialogAfterVisible() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                SSH.this.connectHost();
            }
        });
        thread.start();
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.SSH.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.SSH.Description");
    }

    @Override
    protected final JComponent getInputPane() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(this.getProgressBarPane(new CancelCallback(){

            @Override
            public void cancel() {
                Tools.debug(this, "cancel callback");
                SSH.this.getHost().getSSH().cancelConnection();
            }
        }));
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.SSH.Connecting")));
        return pane;
    }

    protected JComponent[] nextButtons() {
        return new JComponent[]{this.buttonClass(this.nextButton())};
    }
}

