/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import lcmc.data.Host;
import lcmc.gui.dialog.ConfigDialog;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public final class EditConfig
extends ConfigDialog {
    private static final long serialVersionUID = 1L;
    private final String file;
    private final Set<Host> hosts;
    private final Map<Host, JCheckBox> hostCbs = new HashMap<Host, JCheckBox>();
    private final JCheckBox backupCB = new JCheckBox(Tools.getString("Dialog.EditConfig.Backup.Button"));
    private final JTextArea configArea = new JTextArea(Tools.getString("Dialog.EditConfig.Loading"));
    private final JLabel errorPanel = new JLabel();
    private volatile boolean configInProgress = true;

    public EditConfig(String file, Set<Host> hosts) {
        this.file = file;
        this.hosts = hosts;
        this.addToOptions(this.backupCB);
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        JPanel hostsPanel = new JPanel(new FlowLayout(0));
        this.errorPanel.setForeground(Color.RED);
        int i = 0;
        this.backupCB.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
        hostsPanel.add(this.backupCB);
        for (Host host : this.hosts) {
            JCheckBox hcb = new JCheckBox(host.getName());
            this.hostCbs.put(host, hcb);
            int index = i++;
            hcb.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
            hostsPanel.add(hcb);
        }
        hostsPanel.add(this.errorPanel);
        pane.add(hostsPanel);
        pane.add(this.configArea);
        JScrollPane sp = new JScrollPane(pane);
        sp.setPreferredSize(sp.getMaximumSize());
        return sp;
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(2);
        if (this.buttonClass(this.cancelButton()) != null) {
            this.buttonClass(this.cancelButton()).getParent().setLayout(layout);
        }
        this.buttonClass(this.saveButton()).setEnabled(false);
        this.enableComponents();
    }

    private void setConfigArea(String text, int errorCode, boolean selected) {
        if (selected) {
            String config;
            if (errorCode == 0) {
                config = text;
            } else {
                this.errorPanel.setText("WARNING: " + text);
                config = Tools.getString("Dialog.EditConfig.NewConfig");
            }
            this.configArea.setText(config);
        }
        this.configArea.setCaretPosition(0);
        this.configArea.requestFocus();
        if (errorCode != 0) {
            this.configArea.selectAll();
        }
        this.configInProgress = false;
    }

    @Override
    protected void initDialogAfterVisible() {
        JCheckBox hcb;
        int index;
        SSH.ExecCommandThread[] threads = new SSH.ExecCommandThread[this.hosts.size()];
        final String[] results = new String[this.hosts.size()];
        final Integer[] errors = new Integer[this.hosts.size()];
        int i = 0;
        for (final Host host : this.hosts) {
            index = i;
            ExecCallback execCallback = new ExecCallback(){

                @Override
                public void done(String ans) {
                    String text;
                    results[index] = text = ans.replaceAll("\r", "").replaceFirst("\n$", "");
                    errors[index] = 0;
                }

                @Override
                public void doneError(String ans, int exitCode) {
                    results[index] = ans;
                    errors[index] = exitCode;
                    Tools.sshError(host, "", ans, "", exitCode);
                }
            };
            threads[i] = host.execCommandRaw("@DMCSUDO@cat " + this.file, execCallback, false, true, SSH.DEFAULT_COMMAND_TIMEOUT);
            ++i;
        }
        for (SSH.ExecCommandThread t : threads) {
            try {
                t.join(0L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        i = 0;
        for (Host host : this.hosts) {
            index = i;
            hcb = this.hostCbs.get(host);
            if (i == 0 || results[0].equals(results[i])) {
                hcb.setSelected(true);
            } else {
                this.errorPanel.setText(Tools.getString("Dialog.EditConfig.DifferentFiles"));
            }
            ++i;
        }
        i = 0;
        for (final Host host : this.hosts) {
            index = i;
            hcb = this.hostCbs.get(host);
            hcb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(final ItemEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditConfig.this.setConfigArea(results[index], errors[index], e.getStateChange() == 1);
                            if (e.getStateChange() == 1) {
                                for (Host h : EditConfig.this.hosts) {
                                    JCheckBox thiscb = (JCheckBox)EditConfig.this.hostCbs.get(h);
                                    if (h == host) {
                                        thiscb.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Darker"));
                                        continue;
                                    }
                                    thiscb.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
                                }
                            }
                        }
                    });
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditConfig.this.setConfigArea(results[0], errors[0], true);
            }
        });
        Document caDocument = this.configArea.getDocument();
        caDocument.addDocumentListener(new DocumentListener(){

            private void update() {
                if (!EditConfig.this.configInProgress) {
                    EditConfig.this.buttonClass(EditConfig.this.saveButton()).setEnabled(true);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }
        });
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.EditConfig.Title") + " " + this.file;
    }

    @Override
    protected String getDescription() {
        return "";
    }

    @Override
    protected String defaultButton() {
        return this.cancelButton();
    }

    private String saveButton() {
        return this.buttonString("Save");
    }

    @Override
    protected String[] buttons() {
        return new String[]{this.saveButton(), this.cancelButton()};
    }

    @Override
    protected ImageIcon[] getIcons() {
        return new ImageIcon[]{null, null};
    }

    private void saveButtonWasPressed() {
        String iText = "saving " + this.file + "...";
        Tools.startProgressIndicator(iText);
        for (Host host : this.hosts) {
            if (!this.hostCbs.get(host).isSelected()) continue;
            host.getSSH().createConfig(this.configArea.getText(), this.file, "", null, this.backupCB.isSelected(), null, null);
        }
        Tools.stopProgressIndicator(iText);
    }

    @Override
    protected ConfigDialog checkAnswer() {
        if (this.isPressedButton(this.saveButton())) {
            this.saveButtonWasPressed();
        }
        return null;
    }
}

