/*
 * Decompiled with CFR 0.152.
 */
import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;

public class Integrate {
    public static void main(String[] args) {
        double end;
        double start;
        int procs;
        int exp = 5;
        try {
            procs = Integer.parseInt(args[0]);
            start = new Double(args[1]);
            end = new Double(args[2]);
            if (args.length > 3) {
                exp = Integer.parseInt(args[3]);
            }
        }
        catch (Exception e) {
            System.out.println("Usage: java Integrate <threads> <lower bound> <upper bound> <exponent>\n (for example 2 1 48 5).");
            return;
        }
        System.out.println("Integrating from " + start + " to " + end + " exponent: " + exp);
        SampleFunction f = new SampleFunction(exp);
        FJTaskRunnerGroup group = new FJTaskRunnerGroup(procs);
        Integrator integrator = new Integrator(f, 0.001, group);
        double result = integrator.integral(start, end);
        System.out.println("Answer = " + result);
        group.stats();
    }

    static class Integrator {
        final Function f;
        final double errorTolerance;
        final FJTaskRunnerGroup group;

        Integrator(Function f, double errorTolerance, FJTaskRunnerGroup group) {
            this.f = f;
            this.errorTolerance = errorTolerance;
            this.group = group;
        }

        double integral(double lowerBound, double upperBound) {
            double f_lower = this.f.compute(lowerBound);
            double f_upper = this.f.compute(upperBound);
            double initialArea = 0.5 * (upperBound - lowerBound) * (f_upper + f_lower);
            Quad q = new Quad(lowerBound, upperBound, f_lower, f_upper, initialArea);
            try {
                this.group.invoke(q);
                return q.area;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new Error("Interrupted during computation");
            }
        }

        class Quad
        extends FJTask {
            final double left;
            final double right;
            final double f_left;
            final double f_right;
            volatile double area;

            Quad(double left, double right, double f_left, double f_right, double area) {
                this.left = left;
                this.right = right;
                this.f_left = f_left;
                this.f_right = f_right;
                this.area = area;
            }

            @Override
            public void run() {
                double rightArea;
                double center = 0.5 * (this.left + this.right);
                double f_center = Integrator.this.f.compute(center);
                double leftArea = 0.5 * (center - this.left) * (this.f_left + f_center);
                double sum = leftArea + (rightArea = 0.5 * (this.right - center) * (f_center + this.f_right));
                double diff = sum - this.area;
                if (diff < 0.0) {
                    diff = -diff;
                }
                if (diff >= Integrator.this.errorTolerance) {
                    Quad q1 = new Quad(this.left, center, this.f_left, f_center, leftArea);
                    Quad q2 = new Quad(center, this.right, f_center, this.f_right, rightArea);
                    Quad.coInvoke(q1, q2);
                    sum = q1.area + q2.area;
                }
                this.area = sum;
            }
        }
    }

    static class SampleFunction
    implements Function {
        final int n;

        SampleFunction(int n) {
            this.n = n;
        }

        @Override
        public double compute(double x) {
            double power = x;
            double xsq = x * x;
            double val = power;
            double di = 1.0;
            for (int i = this.n - 1; i > 0; --i) {
                val += (di += 2.0) * (power *= xsq);
            }
            return val;
        }
    }

    static interface Function {
        public double compute(double var1);
    }
}

