/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.i18n;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import javajs.J2SRequireImport;
import javajs.util.PT;
import org.jmol.api.Translator;
import org.jmol.i18n.Language;
import org.jmol.i18n.Resource;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

@J2SRequireImport(value={MessageFormat.class, Resource.class, Language.class, PT.class})
public class GT
implements Translator {
    private static boolean ignoreApplicationBundle = false;
    private static GT getTextWrapper;
    private static Language[] languageList;
    private Resource[] resources = null;
    private int resourceCount = 0;
    private boolean doTranslate = true;
    private String language;
    private static boolean allowDebug;
    static Viewer vwr;
    private static Map<String, String> htLanguages;

    public GT() {
    }

    @Override
    public String translate(String s) {
        return GT.$(s);
    }

    public GT(Viewer vr, String langCode) {
        allowDebug = true;
        this.resources = null;
        this.resourceCount = 0;
        getTextWrapper = this;
        if (langCode != null && langCode.length() == 0) {
            langCode = "none";
        }
        if (langCode != null) {
            this.language = langCode;
        }
        if ("none".equals(this.language)) {
            this.language = null;
        }
        if (this.language == null) {
            this.language = Resource.getLanguage();
        }
        if (this.language == null) {
            this.language = "en";
        }
        String la = this.language;
        String la_co = null;
        String la_co_va = null;
        int i = this.language.indexOf("_");
        if (i >= 0) {
            la = la.substring(0, i);
            la_co = this.language;
            ++i;
            if ((i = la_co.indexOf("_", i)) >= 0) {
                la_co = la_co.substring(0, i);
                la_co_va = this.language;
            }
        }
        if ((this.language = this.getSupported(la_co_va)) == null && (this.language = this.getSupported(la_co)) == null && (this.language = this.getSupported(la)) == null) {
            this.language = "en";
            System.out.println(this.language + " not supported -- using en");
            return;
        }
        la_co_va = null;
        la_co = null;
        switch (this.language.length()) {
            default: {
                la_co_va = this.language;
                la_co = this.language.substring(0, 5);
                la = this.language.substring(0, 2);
                break;
            }
            case 5: {
                la_co = this.language;
                la = this.language.substring(0, 2);
                break;
            }
            case 2: {
                la = this.language;
            }
        }
        la_co = this.getSupported(la_co);
        la = this.getSupported(la);
        if (la == la_co || "en_US".equals(la)) {
            la = null;
        }
        if (la_co == la_co_va) {
            la_co = null;
        }
        if ("en_US".equals(la_co)) {
            return;
        }
        if (allowDebug && Logger.debugging) {
            Logger.debug("Instantiating gettext wrapper for " + this.language + " using files for language:" + la + " country:" + la_co + " variant:" + la_co_va);
        }
        if (!ignoreApplicationBundle) {
            this.addBundles(vr, "Jmol", la_co_va, null, null);
        }
        this.addBundles(vr, "JmolApplet", la_co_va, null, null);
        if (!ignoreApplicationBundle) {
            this.addBundles(vr, "Jmol", null, la_co, null);
        }
        this.addBundles(vr, "JmolApplet", null, la_co, null);
        if (!ignoreApplicationBundle) {
            this.addBundles(vr, "Jmol", null, null, la);
        }
        this.addBundles(vr, "JmolApplet", null, null, la);
    }

    public static Language[] getLanguageList(GT gt) {
        if (languageList == null) {
            if (gt == null) {
                gt = GT.getTextWrapper();
            }
            gt.createLanguageList();
        }
        return languageList;
    }

    public static String getLanguage() {
        return GT.getTextWrapper().language;
    }

    public static void ignoreApplicationBundle() {
        ignoreApplicationBundle = true;
    }

    public static boolean setDoTranslate(boolean TF) {
        boolean b = GT.getDoTranslate();
        GT.getTextWrapper().doTranslate = TF;
        return b;
    }

    public static boolean getDoTranslate() {
        return GT.getTextWrapper().doTranslate;
    }

    public static String $(String string) {
        return GT.getTextWrapper().getString(string);
    }

    public static String o(String s, Object o) {
        if (o instanceof Object[]) {
            if (((Object[])o).length != 1) {
                return MessageFormat.format(s, (Object[])o);
            }
            o = ((Object[])o)[0];
        }
        return PT.rep(s, "{0}", o.toString());
    }

    public static String i(String s, int n) {
        return PT.rep(s, "{0}", "" + n);
    }

    public static String escapeHTML(String msg) {
        int i = msg.length();
        while (--i >= 0) {
            char ch = msg.charAt(i);
            if (ch <= '\u007f') continue;
            msg = msg.substring(0, i) + "&#" + ch + ";" + msg.substring(i + 1);
        }
        return msg;
    }

    private static GT getTextWrapper() {
        return getTextWrapper == null ? (getTextWrapper = new GT(null, null)) : getTextWrapper;
    }

    private synchronized void createLanguageList() {
        boolean wasTranslating = this.doTranslate;
        this.doTranslate = false;
        languageList = Language.getLanguageList();
        this.doTranslate = wasTranslating;
    }

    private String getSupported(String code) {
        if (code == null) {
            return null;
        }
        String s = htLanguages.get(code);
        if (s != null) {
            return s.length() == 0 ? null : s;
        }
        s = Language.getSupported(GT.getLanguageList(this), code);
        htLanguages.put(code, s == null ? "" : s);
        return s;
    }

    private void addBundles(Viewer vwr, String type, String la_co_va, String la_co, String la) {
        try {
            String className = "org.jmol.translation." + type + ".";
            if (la_co_va != null) {
                this.addBundle(vwr, className, la_co_va);
            }
            if (la_co != null) {
                this.addBundle(vwr, className, la_co);
            }
            if (la != null) {
                this.addBundle(vwr, className, la);
            }
        }
        catch (Exception exception) {
            if (allowDebug) {
                Logger.errorEx("Some exception occurred!", exception);
            }
            this.resources = null;
            this.resourceCount = 0;
        }
    }

    private void addBundle(Viewer vwr, String className, String name) {
        Resource resource = Resource.getResource(vwr, className, name);
        if (resource != null) {
            if (this.resources == null) {
                this.resources = new Resource[8];
                this.resourceCount = 0;
            }
            this.resources[this.resourceCount] = resource;
            ++this.resourceCount;
            if (allowDebug) {
                Logger.debug("GT adding " + className);
            }
        }
    }

    private String getString(String s) {
        String trans = null;
        if (this.doTranslate) {
            for (int bundle = 0; bundle < this.resourceCount; ++bundle) {
                trans = this.resources[bundle].getString(s);
                if (trans == null) continue;
                s = trans;
                break;
            }
            if (this.resourceCount > 0 && trans == null && allowDebug && Logger.debugging) {
                Logger.debug("No trans, using default: " + s);
            }
        }
        if (trans == null) {
            if (s.startsWith("[")) {
                s = s.substring(s.indexOf("]") + 1);
            } else if (s.endsWith("]")) {
                s = s.substring(0, s.indexOf("["));
            }
        }
        return s;
    }

    static {
        allowDebug = false;
        htLanguages = new Hashtable<String, String>();
    }
}

