/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSMessage;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;

public final class DNSOutgoing
extends DNSMessage {
    public static boolean USE_DOMAIN_NAME_COMPRESSION = true;
    Map<String, Integer> _names = new HashMap<String, Integer>();
    private int _maxUDPPayload;
    private final MessageOutputStream _questionsBytes;
    private final MessageOutputStream _answersBytes;
    private final MessageOutputStream _authoritativeAnswersBytes;
    private final MessageOutputStream _additionalsAnswersBytes;
    private static final int HEADER_SIZE = 12;

    public DNSOutgoing(int n) {
        this(n, true, 1460);
    }

    public DNSOutgoing(int n, boolean bl) {
        this(n, bl, 1460);
    }

    public DNSOutgoing(int n, boolean bl, int n2) {
        super(n, 0, bl);
        this._maxUDPPayload = n2 > 0 ? n2 : 1460;
        this._questionsBytes = new MessageOutputStream(n2, this);
        this._answersBytes = new MessageOutputStream(n2, this);
        this._authoritativeAnswersBytes = new MessageOutputStream(n2, this);
        this._additionalsAnswersBytes = new MessageOutputStream(n2, this);
    }

    public int availableSpace() {
        return this._maxUDPPayload - 12 - this._questionsBytes.size() - this._answersBytes.size() - this._authoritativeAnswersBytes.size() - this._additionalsAnswersBytes.size();
    }

    public void addQuestion(DNSQuestion dNSQuestion) throws IOException {
        MessageOutputStream messageOutputStream = new MessageOutputStream(512, this);
        messageOutputStream.writeQuestion(dNSQuestion);
        byte[] byArray = messageOutputStream.toByteArray();
        if (byArray.length >= this.availableSpace()) {
            throw new IOException("message full");
        }
        this._questions.add(dNSQuestion);
        this._questionsBytes.write(byArray, 0, byArray.length);
    }

    public void addAnswer(DNSIncoming dNSIncoming, DNSRecord dNSRecord) throws IOException {
        if (dNSIncoming == null || !dNSRecord.suppressedBy(dNSIncoming)) {
            this.addAnswer(dNSRecord, 0L);
        }
    }

    public void addAnswer(DNSRecord dNSRecord, long l) throws IOException {
        if (!(dNSRecord == null || l != 0L && dNSRecord.isExpired(l))) {
            MessageOutputStream messageOutputStream = new MessageOutputStream(512, this);
            messageOutputStream.writeRecord(dNSRecord, l);
            byte[] byArray = messageOutputStream.toByteArray();
            if (byArray.length < this.availableSpace()) {
                this._answers.add(dNSRecord);
                this._answersBytes.write(byArray, 0, byArray.length);
            } else {
                throw new IOException("message full");
            }
        }
    }

    public void addAuthorativeAnswer(DNSRecord dNSRecord) throws IOException {
        MessageOutputStream messageOutputStream = new MessageOutputStream(512, this);
        messageOutputStream.writeRecord(dNSRecord, 0L);
        byte[] byArray = messageOutputStream.toByteArray();
        if (byArray.length >= this.availableSpace()) {
            throw new IOException("message full");
        }
        this._authoritativeAnswers.add(dNSRecord);
        this._authoritativeAnswersBytes.write(byArray, 0, byArray.length);
    }

    public void addAdditionalAnswer(DNSIncoming dNSIncoming, DNSRecord dNSRecord) throws IOException {
        MessageOutputStream messageOutputStream = new MessageOutputStream(512, this);
        messageOutputStream.writeRecord(dNSRecord, 0L);
        byte[] byArray = messageOutputStream.toByteArray();
        if (byArray.length >= this.availableSpace()) {
            throw new IOException("message full");
        }
        this._additionals.add(dNSRecord);
        this._additionalsAnswersBytes.write(byArray, 0, byArray.length);
    }

    public byte[] data() {
        long l = System.currentTimeMillis();
        this._names.clear();
        MessageOutputStream messageOutputStream = new MessageOutputStream(this._maxUDPPayload, this);
        messageOutputStream.writeShort(this._multicast ? 0 : this.getId());
        messageOutputStream.writeShort(this.getFlags());
        messageOutputStream.writeShort(this.getNumberOfQuestions());
        messageOutputStream.writeShort(this.getNumberOfAnswers());
        messageOutputStream.writeShort(this.getNumberOfAuthorities());
        messageOutputStream.writeShort(this.getNumberOfAdditionals());
        for (DNSEntry dNSEntry : this._questions) {
            messageOutputStream.writeQuestion((DNSQuestion)dNSEntry);
        }
        for (DNSEntry dNSEntry : this._answers) {
            messageOutputStream.writeRecord((DNSRecord)dNSEntry, l);
        }
        for (DNSEntry dNSEntry : this._authoritativeAnswers) {
            messageOutputStream.writeRecord((DNSRecord)dNSEntry, l);
        }
        for (DNSEntry dNSEntry : this._additionals) {
            messageOutputStream.writeRecord((DNSRecord)dNSEntry, l);
        }
        return messageOutputStream.toByteArray();
    }

    @Override
    public boolean isQuery() {
        return (this.getFlags() & 0x8000) == 0;
    }

    String print(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.print());
        if (bl) {
            stringBuilder.append(this.print(this.data()));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.isQuery() ? "dns[query:" : "dns[response:");
        stringBuffer.append(" id=0x");
        stringBuffer.append(Integer.toHexString(this.getId()));
        if (this.getFlags() != 0) {
            stringBuffer.append(", flags=0x");
            stringBuffer.append(Integer.toHexString(this.getFlags()));
            if ((this.getFlags() & 0x8000) != 0) {
                stringBuffer.append(":r");
            }
            if ((this.getFlags() & 0x400) != 0) {
                stringBuffer.append(":aa");
            }
            if ((this.getFlags() & 0x200) != 0) {
                stringBuffer.append(":tc");
            }
        }
        if (this.getNumberOfQuestions() > 0) {
            stringBuffer.append(", questions=");
            stringBuffer.append(this.getNumberOfQuestions());
        }
        if (this.getNumberOfAnswers() > 0) {
            stringBuffer.append(", answers=");
            stringBuffer.append(this.getNumberOfAnswers());
        }
        if (this.getNumberOfAuthorities() > 0) {
            stringBuffer.append(", authorities=");
            stringBuffer.append(this.getNumberOfAuthorities());
        }
        if (this.getNumberOfAdditionals() > 0) {
            stringBuffer.append(", additionals=");
            stringBuffer.append(this.getNumberOfAdditionals());
        }
        if (this.getNumberOfQuestions() > 0) {
            stringBuffer.append("\nquestions:");
            for (DNSEntry dNSEntry : this._questions) {
                stringBuffer.append("\n\t");
                stringBuffer.append(dNSEntry);
            }
        }
        if (this.getNumberOfAnswers() > 0) {
            stringBuffer.append("\nanswers:");
            for (DNSEntry dNSEntry : this._answers) {
                stringBuffer.append("\n\t");
                stringBuffer.append(dNSEntry);
            }
        }
        if (this.getNumberOfAuthorities() > 0) {
            stringBuffer.append("\nauthorities:");
            for (DNSEntry dNSEntry : this._authoritativeAnswers) {
                stringBuffer.append("\n\t");
                stringBuffer.append(dNSEntry);
            }
        }
        if (this.getNumberOfAdditionals() > 0) {
            stringBuffer.append("\nadditionals:");
            for (DNSEntry dNSEntry : this._additionals) {
                stringBuffer.append("\n\t");
                stringBuffer.append(dNSEntry);
            }
        }
        stringBuffer.append("\nnames=");
        stringBuffer.append(this._names);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int getMaxUDPPayload() {
        return this._maxUDPPayload;
    }

    public static class MessageOutputStream
    extends ByteArrayOutputStream {
        private final DNSOutgoing _out;
        private final int _offset;

        MessageOutputStream(int n, DNSOutgoing dNSOutgoing) {
            this(n, dNSOutgoing, 0);
        }

        MessageOutputStream(int n, DNSOutgoing dNSOutgoing, int n2) {
            super(n);
            this._out = dNSOutgoing;
            this._offset = n2;
        }

        void writeByte(int n) {
            this.write(n & 0xFF);
        }

        void writeBytes(String string, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                this.writeByte(string.charAt(n + i));
            }
        }

        @Override
        void writeBytes(byte[] byArray) {
            if (byArray != null) {
                this.writeBytes(byArray, 0, byArray.length);
            }
        }

        void writeBytes(byte[] byArray, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                this.writeByte(byArray[n + i]);
            }
        }

        void writeShort(int n) {
            this.writeByte(n >> 8);
            this.writeByte(n);
        }

        void writeInt(int n) {
            this.writeShort(n >> 16);
            this.writeShort(n);
        }

        void writeUTF(String string, int n, int n2) {
            char c;
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                c = string.charAt(n + n3);
                if (c >= '\u0001' && c <= '\u007f') {
                    ++n4;
                    continue;
                }
                if (c > '\u07ff') {
                    n4 += 3;
                    continue;
                }
                n4 += 2;
            }
            this.writeByte(n4);
            for (n3 = 0; n3 < n2; ++n3) {
                c = string.charAt(n + n3);
                if (c >= '\u0001' && c <= '\u007f') {
                    this.writeByte(c);
                    continue;
                }
                if (c > '\u07ff') {
                    this.writeByte(0xE0 | c >> 12 & 0xF);
                    this.writeByte(0x80 | c >> 6 & 0x3F);
                    this.writeByte(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                this.writeByte(0xC0 | c >> 6 & 0x1F);
                this.writeByte(0x80 | c >> 0 & 0x3F);
            }
        }

        void writeName(String string) {
            this.writeName(string, true);
        }

        void writeName(String string, boolean bl) {
            String string2 = string;
            while (true) {
                int n;
                if ((n = string2.indexOf(46)) < 0) {
                    n = string2.length();
                }
                if (n <= 0) {
                    this.writeByte(0);
                    return;
                }
                String string3 = string2.substring(0, n);
                if (bl && USE_DOMAIN_NAME_COMPRESSION) {
                    Integer n2 = this._out._names.get(string2);
                    if (n2 != null) {
                        int n3 = n2;
                        this.writeByte(n3 >> 8 | 0xC0);
                        this.writeByte(n3 & 0xFF);
                        return;
                    }
                    this._out._names.put(string2, this.size() + this._offset);
                    this.writeUTF(string3, 0, string3.length());
                } else {
                    this.writeUTF(string3, 0, string3.length());
                }
                if (!(string2 = string2.substring(n)).startsWith(".")) continue;
                string2 = string2.substring(1);
            }
        }

        void writeQuestion(DNSQuestion dNSQuestion) {
            this.writeName(dNSQuestion.getName());
            this.writeShort(dNSQuestion.getRecordType().indexValue());
            this.writeShort(dNSQuestion.getRecordClass().indexValue());
        }

        void writeRecord(DNSRecord dNSRecord, long l) {
            this.writeName(dNSRecord.getName());
            this.writeShort(dNSRecord.getRecordType().indexValue());
            this.writeShort(dNSRecord.getRecordClass().indexValue() | (dNSRecord.isUnique() && this._out.isMulticast() ? 32768 : 0));
            this.writeInt(l == 0L ? dNSRecord.getTTL() : dNSRecord.getRemainingTTL(l));
            MessageOutputStream messageOutputStream = new MessageOutputStream(512, this._out, this._offset + this.size() + 2);
            dNSRecord.write(messageOutputStream);
            byte[] byArray = messageOutputStream.toByteArray();
            this.writeShort(byArray.length);
            this.write(byArray, 0, byArray.length);
        }
    }
}

