/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.io.IOException;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPPushDataSource;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketConsumer;

public class RTPPacketSender
implements PacketConsumer {
    RTPPushDataSource dest = null;
    RTPConnector connector = null;
    OutputDataStream outstream = null;

    public RTPPacketSender(OutputDataStream os) {
        this.outstream = os;
    }

    public RTPPacketSender(RTPConnector connector) throws IOException {
        this.connector = connector;
        this.outstream = connector.getDataOutputStream();
    }

    public RTPPacketSender(RTPPushDataSource dest) {
        this.dest = dest;
        this.outstream = dest.getInputStream();
    }

    @Override
    public void closeConsumer() {
    }

    @Override
    public String consumerString() {
        String s = "RTPPacketSender for " + this.dest;
        return s;
    }

    public RTPConnector getConnector() {
        return this.connector;
    }

    @Override
    public void sendTo(Packet p) throws IOException {
        if (this.outstream == null) {
            throw new IOException();
        }
        this.outstream.write(p.data, 0, p.length);
    }
}

