/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ScServiceDiscoveryManager;
import net.java.sip.communicator.impl.protocol.jabber.extensions.usersearch.UserSearchIQ;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

public class UserSearchManager {
    private Connection con;
    private UserSearchIQ userSearchForm = null;
    private String searchService;

    public UserSearchManager(Connection con, String searchService) {
        this.con = con;
        this.searchService = searchService;
    }

    public static List<String> getAvailableServiceNames(ProtocolProviderServiceJabberImpl provider) {
        DiscoverItems items;
        ArrayList<String> searchServices = new ArrayList<String>();
        ScServiceDiscoveryManager discoManager = provider.getDiscoveryManager();
        try {
            items = discoManager.discoverItems(provider.getConnection().getServiceName());
        }
        catch (XMPPException e) {
            return searchServices;
        }
        Iterator iter = items.getItems();
        while (iter.hasNext()) {
            DiscoverItems.Item item = (DiscoverItems.Item)iter.next();
            try {
                DiscoverInfo info = discoManager.discoverInfo(item.getEntityID());
                if (!info.containsFeature("jabber:iq:search") || info.containsFeature("http://jabber.org/protocol/muc")) continue;
                searchServices.add(item.getEntityID());
            }
            catch (Exception e) {}
        }
        return searchServices;
    }

    private void getSearchForm() throws XMPPException {
        UserSearchIQ search = new UserSearchIQ();
        search.setType(IQ.Type.GET);
        search.setTo(this.searchService);
        PacketCollector collector = this.con.createPacketCollector((PacketFilter)new PacketIDFilter(search.getPacketID()));
        this.con.sendPacket((Packet)search);
        IQ response = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        this.userSearchForm = (UserSearchIQ)response;
    }

    public ReportedData searchForString(String searchedString) throws XMPPException {
        if (this.userSearchForm == null) {
            this.getSearchForm();
        }
        UserSearchIQ search = new UserSearchIQ();
        search.setType(IQ.Type.SET);
        search.setTo(this.searchService);
        Form form = this.userSearchForm.getAnswerForm();
        if (form != null) {
            Iterator<String> fields = form.getFields();
            while (fields.hasNext()) {
                FormField formField = (FormField)fields.next();
                if (formField.getType().equals("boolean")) {
                    form.setAnswer(formField.getVariable(), true);
                    continue;
                }
                if (!formField.getType().equals("text-single")) continue;
                form.setAnswer(formField.getVariable(), searchedString);
            }
            search.setForm(form.getDataFormToSend());
        } else {
            for (String field : this.userSearchForm.getFields()) {
                search.addField(field, searchedString);
            }
        }
        PacketCollector collector = this.con.createPacketCollector((PacketFilter)new PacketIDFilter(search.getPacketID()));
        this.con.sendPacket((Packet)search);
        UserSearchIQ response = (UserSearchIQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response.getData();
    }
}

