/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.harvest.GoogleTurnCandidateHarvest;
import org.ice4j.ice.harvest.GoogleTurnCandidateHarvester;
import org.ice4j.socket.IceTcpSocketWrapper;
import org.ice4j.socket.MultiplexingSocket;

public class GoogleTurnSSLCandidateHarvester
extends GoogleTurnCandidateHarvester {
    static final byte[] SSL_SERVER_HANDSHAKE = new byte[]{22, 3, 1, 0, 74, 2, 0, 0, 70, 3, 1, 66, -123, 69, -89, 39, -87, 93, -96, -77, -59, -25, 83, -38, 72, 43, 63, -58, 90, -54, -119, -63, 88, 82, -95, 120, 60, 91, 23, 70, 0, -123, 63, 32, 14, -45, 6, 114, 91, 91, 27, 95, 21, -84, 19, -7, -120, 83, -99, -101, -24, 61, 123, 12, 48, 50, 110, 56, 77, -94, 117, 87, 65, 108, 52, 92, 0, 4, 0};
    public static final byte[] SSL_CLIENT_HANDSHAKE = new byte[]{-128, 70, 1, 3, 1, 0, 45, 0, 0, 0, 16, 1, 0, -128, 3, 0, -128, 7, 0, -64, 6, 0, 64, 2, 0, -128, 4, 0, -128, 0, 0, 4, 0, -2, -1, 0, 0, 10, 0, -2, -2, 0, 0, 9, 0, 0, 100, 0, 0, 98, 0, 0, 3, 0, 0, 6, 31, 23, 12, -90, 47, 0, 120, -4, 70, 85, 46, -79, -125, 57, -15, -22};

    public GoogleTurnSSLCandidateHarvester(TransportAddress turnServer) {
        this(turnServer, null, null);
    }

    public GoogleTurnSSLCandidateHarvester(TransportAddress turnServer, String shortTermCredentialUsername, String password) {
        super(turnServer, shortTermCredentialUsername, password);
    }

    @Override
    protected GoogleTurnCandidateHarvest createHarvest(HostCandidate hostCandidate) {
        return new GoogleTurnCandidateHarvest(this, hostCandidate, this.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HostCandidate getHostCandidate(HostCandidate hostCand) {
        HostCandidate cand = null;
        Socket sock = null;
        try {
            sock = new Socket(this.stunServer.getAddress(), this.stunServer.getPort());
            OutputStream outputStream = sock.getOutputStream();
            InputStream inputStream = sock.getInputStream();
            if (GoogleTurnSSLCandidateHarvester.sslHandshake(inputStream, outputStream)) {
                Component parentComponent = hostCand.getParentComponent();
                MultiplexingSocket multiplexing = new MultiplexingSocket(sock);
                cand = new HostCandidate(new IceTcpSocketWrapper(multiplexing), parentComponent, Transport.TCP);
                parentComponent.getParentStream().getParentAgent().getStunStack().addSocket(cand.getStunSocket(null));
                parentComponent.getComponentSocket().add(multiplexing);
            }
        }
        catch (Exception e) {
            cand = null;
        }
        finally {
            if (cand == null && sock != null) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {}
            }
        }
        return cand;
    }

    public static boolean sslHandshake(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] data = new byte[SSL_SERVER_HANDSHAKE.length];
        outputStream.write(SSL_CLIENT_HANDSHAKE);
        inputStream.read(data);
        outputStream = null;
        inputStream = null;
        return Arrays.equals(data, SSL_SERVER_HANDSHAKE);
    }
}

