/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.io.Serializable;
import java.util.Map;

public class JingleNodeDescriptor
implements Serializable {
    public static final String JN_PREFIX = "JINGLENODES";
    public static final String JN_ADDRESS = "ADDRESS";
    public static final String JN_IS_RELAY_SUPPORTED = "IS_RELAY_SUPPORTED";
    public static final int MAX_JN_RELAY_COUNT = 100;
    private String address;
    private boolean relaySupported;

    public JingleNodeDescriptor(String address, boolean relaySupported) {
        this.address = address;
        this.relaySupported = relaySupported;
    }

    public String getJID() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isRelaySupported() {
        return this.relaySupported;
    }

    public void setRelay(boolean relaySupported) {
        this.relaySupported = relaySupported;
    }

    public void storeDescriptor(Map<String, String> props, String namePrefix) {
        if (namePrefix == null) {
            namePrefix = "";
        }
        props.put(namePrefix + JN_ADDRESS, this.getJID());
        props.put(namePrefix + JN_IS_RELAY_SUPPORTED, Boolean.toString(this.isRelaySupported()));
    }

    public static JingleNodeDescriptor loadDescriptor(Map<String, String> props, String namePrefix) {
        String relayAddress;
        if (namePrefix == null) {
            namePrefix = "";
        }
        if ((relayAddress = props.get(namePrefix + JN_ADDRESS)) == null) {
            return null;
        }
        String relayStr = props.get(namePrefix + JN_IS_RELAY_SUPPORTED);
        boolean relay = false;
        try {
            relay = Boolean.parseBoolean(relayStr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JingleNodeDescriptor relayServer = new JingleNodeDescriptor(relayAddress, relay);
        return relayServer;
    }

    public String toString() {
        return "JingleNodesDesc: " + this.getJID() + " relay:" + this.isRelaySupported();
    }
}

