/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatConversationComponent;
import net.java.sip.communicator.impl.gui.main.chat.ChatConversationContainer;
import net.java.sip.communicator.impl.gui.main.chat.ChatHtmlUtils;
import net.java.sip.communicator.impl.gui.main.chat.ChatMessage;
import net.java.sip.communicator.impl.gui.main.chat.Replacer;
import net.java.sip.communicator.impl.gui.main.chat.ShowPreviewDialog;
import net.java.sip.communicator.impl.gui.main.chat.history.HistoryWindow;
import net.java.sip.communicator.impl.gui.main.chat.menus.ChatRightButtonMenu;
import net.java.sip.communicator.impl.gui.main.chat.replacers.BrTagReplacer;
import net.java.sip.communicator.impl.gui.main.chat.replacers.ImgTagReplacer;
import net.java.sip.communicator.impl.gui.main.chat.replacers.KeywordReplacer;
import net.java.sip.communicator.impl.gui.main.chat.replacers.NewlineReplacer;
import net.java.sip.communicator.impl.gui.main.chat.replacers.URLReplacer;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommHTMLEditorKit;
import net.java.sip.communicator.plugin.desktoputil.SIPCommScrollPane;
import net.java.sip.communicator.plugin.desktoputil.SwingWorker;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.ChatLinkClickedListener;
import net.java.sip.communicator.service.gui.ConfigurationContainer;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.replacement.ReplacementProperty;
import net.java.sip.communicator.service.replacement.ReplacementService;
import net.java.sip.communicator.service.replacement.directimage.DirectImageReplacementService;
import net.java.sip.communicator.service.replacement.smilies.SmiliesReplacementService;
import net.java.sip.communicator.util.AvatarCacheUtils;
import net.java.sip.communicator.util.Base64;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.GuiUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.util.StringUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ChatConversationPanel
extends SIPCommScrollPane
implements HyperlinkListener,
MouseListener,
ClipboardOwner,
Skinnable {
    private static final Logger logger = Logger.getLogger(ChatConversationPanel.class);
    private static final Pattern URL_PATTERN = Pattern.compile("((\\bwww\\.[^\\s<>\"]+\\.[^\\s<>\"]+/*[?#]*(\\w+[&=;?]\\w+)*\\b)|(\\bjitsi\\:[^\\s<>\"]+\\.[^\\s<>\"]*\\b)|(\\b\\w+://[^\\s<>\"]+/*[?#]*(\\w+[&=;?]\\w+)*\\b))");
    private static final Pattern DIV_PATTERN = Pattern.compile("(<div[^>]*>)(.*)(</div>)", 32);
    static final Pattern TEXT_TO_REPLACE_PATTERN = Pattern.compile("([^<]*+)(?:<(?:[^>\"]*(?:\"[^\"]*+\"?)*)*+>?)?", 34);
    private Set<ChatLinkClickedListener> chatLinkClickedListeners = new HashSet<ChatLinkClickedListener>();
    private final JTextPane chatTextPane = new MyTextPane();
    private final ChatConversationEditorKit editorKit;
    HTMLDocument document;
    private final ChatConversationContainer chatContainer;
    private ChatRightButtonMenu rightButtonMenu;
    private String currentHref;
    private boolean isCurrentHrefImg = false;
    private final JMenuItem copyLinkItem;
    private final JMenuItem configureReplacementItem;
    private final JSeparator configureReplacementSeparator = new JSeparator();
    private final JMenuItem openLinkItem;
    private final JSeparator copyLinkSeparator = new JSeparator();
    private Date lastIncomingMsgTimestamp = new Date(0L);
    private Date lastMessageTimestamp = new Date(0L);
    private final boolean isHistory;
    private boolean scrollToBottomIsPending = false;
    private String lastMessageUID = null;
    private boolean isSimpleTheme = true;
    private ShowPreviewDialog showPreview = new ShowPreviewDialog(this);
    private final Runnable scrollToBottomRunnable = new Runnable(){

        @Override
        public void run() {
            JScrollBar verticalScrollBar = ChatConversationPanel.this.getVerticalScrollBar();
            if (verticalScrollBar != null) {
                int pos;
                verticalScrollBar.setValue(verticalScrollBar.getMaximum());
                Document doc = ChatConversationPanel.this.chatTextPane.getDocument();
                if (doc != null && (pos = ChatConversationPanel.this.document.getLength()) >= 0 && pos <= ChatConversationPanel.this.chatTextPane.getDocument().getLength()) {
                    ChatConversationPanel.this.chatTextPane.setCaretPosition(pos);
                }
            }
        }
    };

    public ChatConversationPanel(ChatConversationContainer chatContainer) {
        this.editorKit = new ChatConversationEditorKit((JComponent)((Object)this));
        this.chatContainer = chatContainer;
        this.isHistory = chatContainer instanceof HistoryWindow;
        this.rightButtonMenu = new ChatRightButtonMenu(this);
        this.document = (HTMLDocument)this.editorKit.createDefaultDocument();
        this.document.addDocumentListener(this.editorKit);
        this.chatTextPane.setEditorKitForContentType("text/html", (EditorKit)((Object)this.editorKit));
        this.chatTextPane.setEditorKit((EditorKit)((Object)this.editorKit));
        this.chatTextPane.setEditable(false);
        this.chatTextPane.setDocument(this.document);
        this.chatTextPane.setDragEnabled(true);
        this.chatTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        Constants.loadSimpleStyle(this.document.getStyleSheet(), this.chatTextPane.getFont());
        this.chatTextPane.addHyperlinkListener(this);
        this.chatTextPane.addMouseListener(this);
        this.chatTextPane.setCursor(Cursor.getPredefinedCursor(2));
        this.addChatLinkClickedListener(this.showPreview);
        this.setWheelScrollingEnabled(true);
        this.setViewportView(this.chatTextPane);
        this.setBorder(null);
        this.setHorizontalScrollBarPolicy(31);
        ToolTipManager.sharedInstance().registerComponent(this.chatTextPane);
        String copyLinkString = GuiActivator.getResources().getI18NString("service.gui.COPY_LINK");
        this.copyLinkItem = new JMenuItem(copyLinkString, new ImageIcon(ImageLoader.getImage(ImageLoader.COPY_ICON)));
        this.copyLinkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection stringSelection = new StringSelection(ChatConversationPanel.this.currentHref);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, ChatConversationPanel.this);
            }
        });
        String openLinkString = GuiActivator.getResources().getI18NString("service.gui.OPEN_IN_BROWSER");
        this.openLinkItem = new JMenuItem(openLinkString, new ImageIcon(ImageLoader.getImage(ImageLoader.BROWSER_ICON)));
        this.openLinkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiActivator.getBrowserLauncher().openURL(ChatConversationPanel.this.currentHref);
                ChatConversationPanel.this.currentHref = "";
            }
        });
        this.openLinkItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.OPEN_IN_BROWSER"));
        this.copyLinkItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.COPY_LINK"));
        this.configureReplacementItem = new JMenuItem(GuiActivator.getResources().getI18NString("plugin.chatconfig.replacement.CONFIGURE_REPLACEMENT"), GuiActivator.getResources().getImage("service.gui.icons.CONFIGURE_ICON"));
        this.configureReplacementItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationContainer configContainer = GuiActivator.getUIService().getConfigurationContainer();
                ConfigurationForm chatConfigForm = ChatConversationPanel.getChatConfigForm();
                if (chatConfigForm != null) {
                    configContainer.setSelected(chatConfigForm);
                    configContainer.setVisible(true);
                }
            }
        });
        this.isSimpleTheme = ConfigurationUtils.isChatSimpleThemeEnabled();
        ComponentAdapter componentListener = new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent e) {
                Runnable runnable = ChatConversationPanel.this.scrollToBottomRunnable;
                synchronized (runnable) {
                    if (!ChatConversationPanel.this.scrollToBottomIsPending) {
                        return;
                    }
                    ChatConversationPanel.this.scrollToBottomIsPending = false;
                    SwingUtilities.invokeLater(ChatConversationPanel.this.scrollToBottomRunnable);
                }
            }
        };
        this.chatTextPane.addComponentListener(componentListener);
        this.getViewport().addComponentListener(componentListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(int x, int y, int width, int height) {
        Runnable runnable = this.scrollToBottomRunnable;
        synchronized (runnable) {
            BoundedRangeModel verticalScrollBarModel;
            JScrollBar verticalScrollBar = this.getVerticalScrollBar();
            if (!(verticalScrollBar == null || (verticalScrollBarModel = verticalScrollBar.getModel()).getValue() + verticalScrollBarModel.getExtent() < verticalScrollBarModel.getMaximum() && verticalScrollBar.isVisible())) {
                this.scrollToBottomIsPending = true;
            }
        }
        super.setBounds(x, y, width, height);
    }

    public String getMessageContents(String messageUID) {
        Element root = this.document.getDefaultRootElement();
        Element e = this.document.getElement(root, HTML.Attribute.ID, "message" + messageUID);
        if (e == null) {
            logger.warn((Object)("Could not find message with ID " + messageUID));
            return null;
        }
        Object original_message = e.getAttributes().getAttribute("original_message");
        if (original_message == null) {
            logger.warn((Object)("Message with ID " + messageUID + " does not have original_message attribute"));
            return null;
        }
        String res = new String(Base64.decode((String)original_message.toString()));
        res = res.replace("&#10;", "");
        return res;
    }

    public String processMessage(ChatMessage chatMessage, String keyword, ProtocolProviderService protocolProvider, String contactAddress) {
        if (this.isConsecutiveMessage(chatMessage)) {
            this.appendConsecutiveMessage(chatMessage, keyword);
            return null;
        }
        String contentType = chatMessage.getContentType();
        this.lastMessageTimestamp = chatMessage.getDate();
        String contactName = chatMessage.getContactName();
        String contactDisplayName = chatMessage.getContactDisplayName();
        contactDisplayName = contactDisplayName == null || contactDisplayName.trim().length() <= 0 ? contactName : contactDisplayName.replaceAll("&apos;", "&#39;");
        Date date = chatMessage.getDate();
        String messageType = chatMessage.getMessageType();
        String messageTitle = chatMessage.getMessageTitle();
        String message = chatMessage.getMessage();
        String chatString = "";
        String endHeaderTag = "";
        this.lastMessageUID = chatMessage.getMessageUID();
        if (messageType.equals("IncomingMessage")) {
            this.lastIncomingMsgTimestamp = new Date();
            chatString = ChatHtmlUtils.createIncomingMessageTag(this.lastMessageUID, contactName, contactDisplayName, ChatConversationPanel.getContactAvatar(protocolProvider, contactAddress), date, this.formatMessageAsHTML(message, contentType, keyword), "text/html", false, this.isSimpleTheme);
        } else if (messageType.equals("OutgoingMessage")) {
            chatString = ChatHtmlUtils.createOutgoingMessageTag(this.lastMessageUID, contactName, contactDisplayName, ChatConversationPanel.getContactAvatar(protocolProvider), date, this.formatMessageAsHTML(message, contentType, keyword), "text/html", false, this.isSimpleTheme);
        } else if (messageType.equals("HistoryIncomingMessage")) {
            chatString = ChatHtmlUtils.createIncomingMessageTag(this.lastMessageUID, contactName, contactDisplayName, ChatConversationPanel.getContactAvatar(protocolProvider, contactAddress), date, this.formatMessageAsHTML(message, contentType, keyword), "text/html", true, this.isSimpleTheme);
        } else if (messageType.equals("HistoryOutgoingMessage")) {
            chatString = ChatHtmlUtils.createOutgoingMessageTag(this.lastMessageUID, contactName, contactDisplayName, ChatConversationPanel.getContactAvatar(protocolProvider), date, this.formatMessageAsHTML(message, contentType, keyword), "text/html", true, this.isSimpleTheme);
        } else if (messageType.equals("SmsMessage")) {
            chatString = ChatHtmlUtils.createIncomingMessageTag(this.lastMessageUID, contactName, contactDisplayName, ChatConversationPanel.getContactAvatar(protocolProvider, contactAddress), date, ConfigurationUtils.isSmsNotifyTextDisabled() ? this.formatMessageAsHTML(message, contentType, keyword) : this.formatMessageAsHTML("SMS: " + message, contentType, keyword), "text/html", false, this.isSimpleTheme);
        } else if (messageType.equals("StatusMessage")) {
            chatString = "<div id=\"statusMessage\" date=\"" + date + "\" style=\"color: #8F8F8F; font-size: 8px;\">";
            endHeaderTag = "</div>";
            chatString = chatString + GuiUtils.formatTime((Date)date) + " " + StringEscapeUtils.escapeHtml4((String)contactName) + " " + this.formatMessageAsHTML(message, contentType, keyword) + endHeaderTag;
        } else if (messageType.equals("ActionMessage")) {
            chatString = "<p id=\"actionMessage\" date=\"" + date + "\">";
            endHeaderTag = "</p>";
            chatString = chatString + "* " + GuiUtils.formatTime((Date)date) + " " + StringEscapeUtils.escapeHtml4((String)contactName) + " " + this.formatMessageAsHTML(message, contentType, keyword) + endHeaderTag;
        } else if (messageType.equals("SystemMessage")) {
            String startSystemDivTag = "<DIV id=\"systemMessage\" style=\"color:#627EB7;\">";
            String endDivTag = "</DIV>";
            chatString = chatString + startSystemDivTag + this.formatMessageAsHTML(message, contentType, keyword) + endDivTag;
        } else if (messageType.equals("ErrorMessage")) {
            chatString = "<h6 id=\"dateHeader\" date=\"" + date + "\">";
            endHeaderTag = "</h6>";
            String errorIcon = "<IMG SRC=\"" + ImageLoader.getImageUri(ImageLoader.EXCLAMATION_MARK) + "\"></IMG>";
            chatString = messageTitle != null ? chatString + errorIcon + StringEscapeUtils.escapeHtml4((String)messageTitle) + endHeaderTag + "<h5>" + this.formatMessageAsHTML(message, contentType, keyword) + "</h5>" : chatString + endHeaderTag + "<h5>" + errorIcon + " " + this.formatMessageAsHTML(message, contentType, keyword) + "</h5>";
        }
        return chatString;
    }

    public String processMessage(ChatMessage chatMessage, ProtocolProviderService protocolProvider, String contactAddress) {
        return this.processMessage(chatMessage, null, protocolProvider, contactAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendConsecutiveMessage(final ChatMessage chatMessage, final String keyword) {
        String previousMessageUID = this.lastMessageUID;
        this.lastMessageUID = chatMessage.getMessageUID();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatConversationPanel.this.appendConsecutiveMessage(chatMessage, keyword);
                }
            });
            return;
        }
        Element lastMsgElement = this.document.getElement("message" + previousMessageUID);
        String contactAddress = (String)lastMsgElement.getAttributes().getAttribute(HTML.Attribute.NAME);
        boolean isHistory = chatMessage.getMessageType().equals("HistoryIncomingMessage") || chatMessage.getMessageType().equals("HistoryOutgoingMessage");
        String newMessage = ChatHtmlUtils.createMessageTag(chatMessage.getMessageUID(), contactAddress, this.formatMessageAsHTML(chatMessage.getMessage(), chatMessage.getContentType(), keyword), "text/html", chatMessage.getDate(), false, isHistory, this.isSimpleTheme);
        Runnable runnable = this.scrollToBottomRunnable;
        synchronized (runnable) {
            try {
                Element parentElement = lastMsgElement.getParentElement();
                this.document.insertBeforeEnd(parentElement, newMessage);
                SwingUtilities.invokeLater(this.scrollToBottomRunnable);
            }
            catch (BadLocationException ex) {
                logger.error((Object)"Could not replace chat message", (Throwable)ex);
            }
            catch (IOException ex) {
                logger.error((Object)"Could not replace chat message", (Throwable)ex);
            }
        }
        this.finishMessageAdd(newMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void correctMessage(final ChatMessage chatMessage) {
        Element root;
        Element correctedMsgElement;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatConversationPanel.this.correctMessage(chatMessage);
                }
            });
            return;
        }
        String correctedUID = chatMessage.getCorrectedMessageUID();
        if (correctedUID != null && correctedUID.equals(this.lastMessageUID)) {
            this.lastMessageUID = chatMessage.getMessageUID();
        }
        if ((correctedMsgElement = this.document.getElement(root = this.document.getDefaultRootElement(), HTML.Attribute.ID, "message" + correctedUID)) == null) {
            logger.warn((Object)("Could not find message with ID " + correctedUID));
            return;
        }
        String contactAddress = (String)correctedMsgElement.getAttributes().getAttribute(HTML.Attribute.NAME);
        boolean isHistory = chatMessage.getMessageType().equals("HistoryIncomingMessage") || chatMessage.getMessageType().equals("HistoryOutgoingMessage");
        String newMessage = ChatHtmlUtils.createMessageTag(chatMessage.getMessageUID(), contactAddress, this.formatMessageAsHTML(chatMessage.getMessage(), chatMessage.getContentType(), ""), "text/html", chatMessage.getDate(), true, isHistory, this.isSimpleTheme);
        Runnable runnable = this.scrollToBottomRunnable;
        synchronized (runnable) {
            try {
                this.document.setOuterHTML(correctedMsgElement, newMessage);
                SwingUtilities.invokeLater(this.scrollToBottomRunnable);
            }
            catch (BadLocationException ex) {
                logger.error((Object)"Could not replace chat message", (Throwable)ex);
            }
            catch (IOException ex) {
                logger.error((Object)"Could not replace chat message", (Throwable)ex);
            }
        }
        this.finishMessageAdd(newMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessageToEnd(final String original, final String contentType) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatConversationPanel.this.appendMessageToEnd(original, contentType);
                }
            });
            return;
        }
        if (original == null) {
            return;
        }
        String message = "text/html".equalsIgnoreCase(contentType) ? original : StringEscapeUtils.escapeHtml4((String)original);
        Runnable runnable = this.scrollToBottomRunnable;
        synchronized (runnable) {
            Element root = this.document.getDefaultRootElement();
            try {
                this.document.insertBeforeEnd(root.getElement(root.getElementCount() - 1), message);
                SwingUtilities.invokeLater(this.scrollToBottomRunnable);
            }
            catch (BadLocationException e) {
                logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
            }
        }
        String lastElemContent = this.getElementContent(this.lastMessageUID, message);
        if (lastElemContent != null) {
            this.finishMessageAdd(lastElemContent);
        }
    }

    private void finishMessageAdd(String message) {
        ConfigurationService cfg;
        if (!this.isHistory) {
            this.ensureDocumentSize();
        }
        if ((cfg = GuiActivator.getConfigurationService()).getBoolean("net.java.sip.communicator.service.replacement.enable", true) || cfg.getBoolean("plugin.chatconfig.replacement.proposal.enable", true) || cfg.getBoolean(ReplacementProperty.getPropertyName((String)"SMILEY"), true)) {
            this.processReplacement("message" + this.lastMessageUID, message);
        }
    }

    void processReplacement(String messageID, String chatString) {
        new ReplacementWorker(messageID, chatString).start();
    }

    private void ensureDocumentSize() {
        if (this.document.getLength() > 50000) {
            String[] ids = new String[]{"message", "statusMessage", "systemMessage", "actionMessage"};
            Element firstMsgElement = this.findElement(HTML.Attribute.ID, ids);
            int startIndex = firstMsgElement.getStartOffset();
            int endIndex = firstMsgElement.getEndOffset();
            try {
                this.document.remove(startIndex, endIndex - startIndex);
            }
            catch (BadLocationException e) {
                logger.error((Object)"Error removing messages from chat: ", (Throwable)e);
            }
            if (firstMsgElement.getName().equals("table")) {
                this.deleteAllMessagesWithoutHeader();
            }
        }
    }

    private void deleteAllMessagesWithoutHeader() {
        String[] ids = new String[]{"message", "statusMessage", "systemMessage", "actionMessage"};
        Element firstMsgElement = this.findElement(HTML.Attribute.ID, ids);
        if (firstMsgElement == null || !firstMsgElement.getName().equals("div")) {
            return;
        }
        int startIndex = firstMsgElement.getStartOffset();
        int endIndex = firstMsgElement.getEndOffset();
        try {
            if (endIndex - startIndex >= this.document.getLength()) {
                return;
            }
            this.document.remove(startIndex, endIndex - startIndex);
        }
        catch (BadLocationException e) {
            logger.error((Object)"Error removing messages from chat: ", (Throwable)e);
            return;
        }
        this.deleteAllMessagesWithoutHeader();
    }

    private String formatMessageAsHTML(String original, String contentType, String keyword) {
        if (original == null) {
            return "";
        }
        String source = "text/html".equals(contentType) ? original : StringEscapeUtils.escapeHtml4((String)original);
        return this.processReplacers(source, new NewlineReplacer(), new URLReplacer(URL_PATTERN), new KeywordReplacer(keyword), new BrTagReplacer(), new ImgTagReplacer());
    }

    private String processReplacers(String content, Replacer ... replacers) {
        StringBuilder source = new StringBuilder(content);
        for (Replacer replacer : replacers) {
            StringBuilder target = new StringBuilder();
            if (replacer.expectsPlainText()) {
                int startPos = 0;
                Matcher plainTextInHtmlMatcher = TEXT_TO_REPLACE_PATTERN.matcher(source);
                while (plainTextInHtmlMatcher.find()) {
                    String plainTextAsHtml = plainTextInHtmlMatcher.group(1);
                    int startMatchPosition = plainTextInHtmlMatcher.start(1);
                    int endMatchPosition = plainTextInHtmlMatcher.end(1);
                    target.append(source.substring(startPos, startMatchPosition));
                    String plaintext = StringEscapeUtils.unescapeHtml4((String)plainTextAsHtml);
                    try {
                        replacer.replace(target, plaintext);
                    }
                    catch (RuntimeException e) {
                        logger.error((Object)("An error occurred in replacer: " + replacer.getClass().getName()), (Throwable)e);
                    }
                    startPos = endMatchPosition;
                }
                target.append(source.substring(startPos));
            } else {
                try {
                    replacer.replace(target, source.toString());
                }
                catch (RuntimeException e) {
                    logger.error((Object)("An error occurred in replacer: " + replacer.getClass().getName()), (Throwable)e);
                }
            }
            source = target;
        }
        return source.toString();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            String href = e.getDescription();
            this.isCurrentHrefImg = e.getSourceElement().getName().equals("img");
            this.currentHref = href;
        } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.currentHref = "";
            this.isCurrentHrefImg = false;
        }
    }

    public JTextPane getChatTextPane() {
        return this.chatTextPane;
    }

    public Date getLastIncomingMsgTimestamp() {
        return this.lastIncomingMsgTimestamp;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point p = e.getPoint();
        SwingUtilities.convertPointToScreen(p, e.getComponent());
        if ((e.getModifiers() & 4) != 0 || e.isControlDown() && !e.isMetaDown()) {
            this.openContextMenu(p);
        } else if ((e.getModifiers() & 0x10) != 0 && this.currentHref != null && this.currentHref.length() != 0) {
            URI uri;
            try {
                uri = new URI(this.currentHref);
            }
            catch (URISyntaxException e1) {
                logger.error((Object)("Failed to open hyperlink in chat window. Error was: Invalid URL - " + this.currentHref));
                return;
            }
            if ("jitsi".equals(uri.getScheme())) {
                for (ChatLinkClickedListener l : this.chatLinkClickedListeners) {
                    l.chatLinkClicked(uri);
                }
            } else {
                GuiActivator.getBrowserLauncher().openURL(this.currentHref);
            }
            this.currentHref = "";
        }
    }

    private void openContextMenu(Point p) {
        if (this.currentHref != null && this.currentHref.length() != 0 && !this.currentHref.startsWith("jitsi://")) {
            this.rightButtonMenu.insert(this.openLinkItem, 0);
            this.rightButtonMenu.insert(this.copyLinkItem, 1);
            this.rightButtonMenu.insert(this.copyLinkSeparator, 2);
            if (this.isCurrentHrefImg) {
                this.rightButtonMenu.insert(this.configureReplacementItem, 3);
                this.rightButtonMenu.insert(this.configureReplacementSeparator, 4);
            }
        } else {
            this.rightButtonMenu.remove(this.openLinkItem);
            this.rightButtonMenu.remove(this.copyLinkItem);
            this.rightButtonMenu.remove(this.copyLinkSeparator);
            this.rightButtonMenu.remove(this.configureReplacementItem);
            this.rightButtonMenu.remove(this.configureReplacementSeparator);
        }
        if (this.chatTextPane.getSelectedText() != null) {
            this.rightButtonMenu.enableCopy();
        } else {
            this.rightButtonMenu.disableCopy();
        }
        this.rightButtonMenu.setInvoker(this.chatTextPane);
        this.rightButtonMenu.setLocation(p.x, p.y);
        this.rightButtonMenu.setVisible(true);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public ChatConversationContainer getChatContainer() {
        return this.chatContainer;
    }

    public void copyConversation() {
        this.chatTextPane.copy();
    }

    public void clear() {
        this.document = (HTMLDocument)this.editorKit.createDefaultDocument();
        Constants.loadSimpleStyle(this.document.getStyleSheet(), this.chatTextPane.getFont());
        this.isSimpleTheme = ConfigurationUtils.isChatSimpleThemeEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(final HTMLDocument document) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatConversationPanel.this.setContent(document);
                }
            });
            return;
        }
        Runnable runnable = this.scrollToBottomRunnable;
        synchronized (runnable) {
            this.scrollToBottomIsPending = true;
            this.document = document;
            this.chatTextPane.setDocument(this.document);
        }
    }

    public void setDefaultContent() {
        this.setContent(this.document);
    }

    public HTMLDocument getContent() {
        return (HTMLDocument)this.chatTextPane.getDocument();
    }

    public ChatRightButtonMenu getRightButtonMenu() {
        return this.rightButtonMenu;
    }

    public Date getPageFirstMsgTimestamp() {
        Element firstHeaderElement = this.document.getElement("dateHeader");
        if (firstHeaderElement == null) {
            return new Date(Long.MAX_VALUE);
        }
        String dateObject = firstHeaderElement.getAttributes().getAttribute("date").toString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        try {
            return sdf.parse(dateObject);
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    public Date getPageLastMsgTimestamp() {
        Element lastMsgElement;
        Date timestamp = new Date(0L);
        if (this.lastMessageUID != null && (lastMsgElement = this.document.getElement("message" + this.lastMessageUID)) != null) {
            Object date = lastMsgElement.getAttributes().getAttribute("date");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            if (date != null) {
                try {
                    timestamp = sdf.parse(date.toString());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponent(ChatConversationComponent component) {
        Runnable runnable = this.scrollToBottomRunnable;
        synchronized (runnable) {
            StyleSheet styleSheet = this.document.getStyleSheet();
            Style style = styleSheet.addStyle("component", styleSheet.getStyle("body"));
            style.addAttribute("$ename", "component");
            TransparentPanel wrapPanel = new TransparentPanel((LayoutManager)new BorderLayout());
            wrapPanel.add((Component)component, (Object)"North");
            style.addAttribute(StyleConstants.ComponentAttribute, wrapPanel);
            style.addAttribute(HTML.Attribute.ID, "message");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            style.addAttribute("date", sdf.format(component.getDate()));
            this.scrollToBottomIsPending = true;
            this.lastMessageUID = null;
            try {
                this.document.insertString(this.document.getLength(), "ignored text", style);
            }
            catch (BadLocationException e) {
                logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
            }
        }
    }

    public void addChatLinkClickedListener(ChatLinkClickedListener listener) {
        if (!this.chatLinkClickedListeners.contains(listener)) {
            this.chatLinkClickedListeners.add(listener);
        }
    }

    public void removeChatLinkClickedListener(ChatLinkClickedListener listener) {
        this.chatLinkClickedListeners.remove(listener);
    }

    public void loadSkin() {
        this.openLinkItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.BROWSER_ICON)));
        this.copyLinkItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.COPY_ICON)));
        this.getRightButtonMenu().loadSkin();
    }

    public String processMeCommand(ChatMessage chatMessage) {
        String contentType = chatMessage.getContentType();
        String message = chatMessage.getMessage();
        if (message.length() <= 4 || !message.startsWith("/me ")) {
            return "";
        }
        String msgID = "message" + chatMessage.getMessageUID();
        String chatString = "<DIV ID='" + msgID + "'><B><I>";
        String endHeaderTag = "</I></B></DIV>";
        chatString = chatString + GuiUtils.escapeHTMLChars((String)("*** " + chatMessage.getContactName() + " " + message.substring(4))) + endHeaderTag;
        Map<String, ReplacementService> listSources = GuiActivator.getReplacementSources();
        for (ReplacementService source : listSources.values()) {
            boolean isSmiley = source instanceof SmiliesReplacementService;
            if (!isSmiley) continue;
            String sourcePattern = source.getPattern();
            Pattern p = Pattern.compile(sourcePattern, 34);
            Matcher m = p.matcher(chatString);
            chatString = m.replaceAll("text/html".equalsIgnoreCase(contentType) ? "$0" : StringEscapeUtils.escapeHtml4((String)"$0"));
        }
        return chatString;
    }

    private static String getContactAvatar(ProtocolProviderService protocolProvider, String contactAddress) {
        File avatarFile;
        String avatarPath = AvatarCacheUtils.getCachedAvatarPath((ProtocolProviderService)protocolProvider, (String)contactAddress);
        try {
            avatarFile = GuiActivator.getFileAccessService().getPrivatePersistentFile(avatarPath, FileCategory.CACHE);
        }
        catch (Exception e) {
            return null;
        }
        if (avatarFile.exists() && avatarFile.length() > 0L) {
            return "file:" + avatarFile.getAbsolutePath();
        }
        return GuiActivator.getResources().getImageURL("service.gui.DEFAULT_USER_PHOTO_SMALL").toString();
    }

    private static String getContactAvatar(ProtocolProviderService protocolProvider) {
        File avatarFile;
        String avatarPath = AvatarCacheUtils.getCachedAvatarPath((ProtocolProviderService)protocolProvider);
        try {
            avatarFile = GuiActivator.getFileAccessService().getPrivatePersistentFile(avatarPath, FileCategory.CACHE);
        }
        catch (Exception e) {
            return null;
        }
        if (avatarFile.exists() && avatarFile.length() > 0L) {
            return "file:" + avatarFile.getAbsolutePath();
        }
        return GuiActivator.getResources().getImageURL("service.gui.DEFAULT_USER_PHOTO_SMALL").toString();
    }

    private boolean isConsecutiveMessage(ChatMessage chatMessage) {
        if (this.lastMessageUID == null) {
            return false;
        }
        Element lastMsgElement = this.document.getElement("message" + this.lastMessageUID);
        if (lastMsgElement == null) {
            logger.info((Object)("Could not find message with ID " + this.lastMessageUID));
            return false;
        }
        String contactAddress = (String)lastMsgElement.getAttributes().getAttribute(HTML.Attribute.NAME);
        if (contactAddress != null && (chatMessage.getMessageType().equals("IncomingMessage") || chatMessage.getMessageType().equals("OutgoingMessage") || chatMessage.getMessageType().equals("HistoryIncomingMessage") || chatMessage.getMessageType().equals("HistoryOutgoingMessage")) && contactAddress.equals(chatMessage.getContactName()) && chatMessage.getDate().getTime() - this.lastMessageTimestamp.getTime() < 60000L) {
            this.lastMessageTimestamp = chatMessage.getDate();
            return true;
        }
        return false;
    }

    public void dispose() {
        if (this.editorKit != null) {
            this.editorKit.dispose();
        }
        super.dispose();
        if (this.showPreview != null) {
            this.showPreview.dispose();
            this.showPreview = null;
        }
        if (this.rightButtonMenu != null) {
            this.rightButtonMenu.dispose();
            this.rightButtonMenu = null;
        }
        this.clear();
    }

    private Element findElement(HTML.Attribute attribute, String[] matchStrings) {
        return this.findFirstElement(this.document.getDefaultRootElement(), attribute, matchStrings);
    }

    private Element findFirstElement(String name) {
        return this.findFirstElement(this.document.getDefaultRootElement(), name);
    }

    private Element findFirstElement(Element element, HTML.Attribute attrName, String[] matchStrings) {
        String attr = (String)element.getAttributes().getAttribute(attrName);
        if (attr != null) {
            for (String matchString : matchStrings) {
                if (!attr.startsWith(matchString)) continue;
                return element;
            }
        }
        Element resultElement = null;
        for (int i = 0; i < element.getElementCount(); ++i) {
            resultElement = this.findFirstElement(element.getElement(i), attrName, matchStrings);
            if (resultElement == null) continue;
            return resultElement;
        }
        return null;
    }

    private Element findFirstElement(Element element, String name) {
        if (element.getName().equalsIgnoreCase(name)) {
            return element;
        }
        Element resultElement = null;
        for (int i = 0; i < element.getElementCount(); ++i) {
            resultElement = this.findFirstElement(element.getElement(i), name);
            if (resultElement == null) continue;
            return resultElement;
        }
        return null;
    }

    private String getElementContent(String elementId, String message) {
        Pattern p = Pattern.compile(".*(<div.*id=[\\\"']message" + elementId + "[\\\"'].*?</div>)", 32);
        Matcher m = p.matcher(message);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static ConfigurationForm getChatConfigForm() {
        Collection cfgFormRefs;
        String osgiFilter = "(FORM_TYPE=GENERAL_TYPE)";
        try {
            cfgFormRefs = GuiActivator.bundleContext.getServiceReferences(ConfigurationForm.class, osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            cfgFormRefs = null;
        }
        if (cfgFormRefs != null && !cfgFormRefs.isEmpty()) {
            String chatCfgFormClassName = "net.java.sip.communicator.plugin.chatconfig.ChatConfigPanel";
            for (ServiceReference cfgFormRef : cfgFormRefs) {
                LazyConfigurationForm lazyConfigForm;
                ConfigurationForm form = (ConfigurationForm)GuiActivator.bundleContext.getService(cfgFormRef);
                if (!(form instanceof LazyConfigurationForm ? chatCfgFormClassName.equals((lazyConfigForm = (LazyConfigurationForm)form).getFormClassName()) : form.getClass().getName().equals(chatCfgFormClassName))) continue;
                return form;
            }
        }
        return null;
    }

    private final class ReplacementWorker
    extends SwingWorker {
        private final String messageID;
        private final String chatString;
        private int linkCounter = 0;
        private final boolean isEnabled;
        private final boolean isProposalEnabled;

        private ReplacementWorker(String messageID, String chatString) {
            this.messageID = messageID;
            this.chatString = chatString;
            ConfigurationService cfg = GuiActivator.getConfigurationService();
            this.isEnabled = cfg.getBoolean("net.java.sip.communicator.service.replacement.enable", true);
            this.isProposalEnabled = cfg.getBoolean("plugin.chatconfig.replacement.proposal.enable", true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            ShowPreviewDialog previewDialog = ChatConversationPanel.this.showPreview;
            if (previewDialog == null) {
                return;
            }
            String newMessage = (String)this.get();
            if (newMessage != null && !newMessage.equals(this.chatString)) {
                previewDialog.getMsgIDToChatString().put(this.messageID, newMessage);
                Runnable runnable = ChatConversationPanel.this.scrollToBottomRunnable;
                synchronized (runnable) {
                    ChatConversationPanel.this.scrollToBottomIsPending = true;
                    try {
                        Element elem = ChatConversationPanel.this.document.getElement(this.messageID);
                        ChatConversationPanel.this.document.setOuterHTML(elem, newMessage);
                    }
                    catch (BadLocationException ex) {
                        logger.error((Object)"Could not replace chat message", (Throwable)ex);
                    }
                    catch (IOException ex) {
                        logger.error((Object)"Could not replace chat message", (Throwable)ex);
                    }
                }
            }
        }

        public Object construct() throws Exception {
            Matcher divMatcher = DIV_PATTERN.matcher(this.chatString);
            String openingTag = "";
            String msgStore = this.chatString;
            String closingTag = "";
            if (divMatcher.find()) {
                openingTag = divMatcher.group(1);
                msgStore = divMatcher.group(2);
                closingTag = divMatcher.group(3);
            }
            for (Map.Entry<String, ReplacementService> entry : GuiActivator.getReplacementSources().entrySet()) {
                StringBuilder msgBuff = new StringBuilder();
                this.processReplacementService(entry.getValue(), msgStore, msgBuff);
                msgStore = msgBuff.toString();
            }
            return openingTag + msgStore + closingTag;
        }

        private void processReplacementService(ReplacementService service, String msg, StringBuilder buff) {
            String sourcePattern = service.getPattern();
            Pattern pattern = Pattern.compile(sourcePattern, 34);
            int startPos = 0;
            Matcher plainTextInHtmlMatcher = TEXT_TO_REPLACE_PATTERN.matcher(msg);
            while (plainTextInHtmlMatcher.find()) {
                String plainTextAsHtml = plainTextInHtmlMatcher.group(1);
                int startMatchPosition = plainTextInHtmlMatcher.start(1);
                int endMatchPosition = plainTextInHtmlMatcher.end(1);
                if (StringUtils.isNullOrEmpty((String)plainTextAsHtml)) continue;
                buff.append(msg.substring(startPos, startMatchPosition));
                String plaintext = StringEscapeUtils.unescapeHtml4((String)plainTextAsHtml);
                boolean isURL = URL_PATTERN.matcher(plaintext).matches();
                this.processText(plaintext, buff, pattern, service, isURL);
                startPos = endMatchPosition;
            }
            buff.append(msg.substring(startPos));
        }

        private void processText(String plainText, StringBuilder msgBuff, Pattern pattern, ReplacementService rService, boolean isURL) {
            ShowPreviewDialog previewDialog = ChatConversationPanel.this.showPreview;
            if (previewDialog == null) {
                return;
            }
            Matcher m = pattern.matcher(plainText);
            ConfigurationService cfg = GuiActivator.getConfigurationService();
            boolean isSmiley = rService instanceof SmiliesReplacementService;
            boolean isDirectImage = rService instanceof DirectImageReplacementService;
            boolean isEnabledForSource = cfg.getBoolean(ReplacementProperty.getPropertyName((String)rService.getSourceName()), true);
            int startPos = 0;
            while (m.find()) {
                msgBuff.append(StringEscapeUtils.escapeHtml4((String)plainText.substring(startPos, m.start())));
                startPos = m.end();
                String group = m.group();
                String temp = rService.getReplacement(group);
                String group0 = m.group(0);
                if (!temp.equals(group0) || isDirectImage) {
                    if (isSmiley) {
                        if (cfg.getBoolean(ReplacementProperty.getPropertyName((String)"SMILEY"), true) && !isURL) {
                            msgBuff.append("<IMG SRC=\"");
                            msgBuff.append(temp);
                            msgBuff.append("\" BORDER=\"0\" ALT=\"");
                            msgBuff.append(group0);
                            msgBuff.append("\"></IMG>");
                            continue;
                        }
                        msgBuff.append(StringEscapeUtils.escapeHtml4((String)group));
                        continue;
                    }
                    if (this.isProposalEnabled) {
                        msgBuff.append(StringEscapeUtils.escapeHtml4((String)group));
                        msgBuff.append("</A> <A href=\"jitsi://" + previewDialog.getClass().getName() + "/SHOWPREVIEW?" + this.messageID + "#" + this.linkCounter + "\">" + StringEscapeUtils.escapeHtml4((String)GuiActivator.getResources().getI18NString("service.gui.SHOW_PREVIEW")));
                        previewDialog.getMsgIDandPositionToLink().put(this.messageID + "#" + this.linkCounter++, group);
                        previewDialog.getLinkToReplacement().put(group, temp);
                        continue;
                    }
                    if (this.isEnabled && isEnabledForSource) {
                        if (isDirectImage) {
                            DirectImageReplacementService service = (DirectImageReplacementService)rService;
                            if (service.isDirectImage(group) && service.getImageSize(group) != -1) {
                                msgBuff.append("<IMG HEIGHT=\"90\" WIDTH=\"120\" SRC=\"");
                                msgBuff.append(temp);
                                msgBuff.append("\" BORDER=\"0\" ALT=\"");
                                msgBuff.append(group0);
                                msgBuff.append("\"></IMG>");
                                continue;
                            }
                            msgBuff.append(StringEscapeUtils.escapeHtml4((String)group));
                            continue;
                        }
                        msgBuff.append("<IMG HEIGHT=\"90\" WIDTH=\"120\" SRC=\"");
                        msgBuff.append(temp);
                        msgBuff.append("\" BORDER=\"0\" ALT=\"");
                        msgBuff.append(group0);
                        msgBuff.append("\"></IMG>");
                        continue;
                    }
                    msgBuff.append(StringEscapeUtils.escapeHtml4((String)group));
                    continue;
                }
                msgBuff.append(StringEscapeUtils.escapeHtml4((String)group));
            }
            msgBuff.append(StringEscapeUtils.escapeHtml4((String)plainText.substring(startPos)));
        }
    }

    private class ChatConversationEditorKit
    extends SIPCommHTMLEditorKit
    implements DocumentListener {
        private List<ImageView> imageViews;

        public ChatConversationEditorKit(JComponent container) {
            super(container);
            this.imageViews = new ArrayList<ImageView>();
        }

        public void dispose() {
            if (ChatConversationPanel.this.document != null) {
                ChatConversationPanel.this.document.removeDocumentListener(this);
            }
            for (ImageView iv : this.imageViews) {
                Image img = iv.getImage();
                if (img == null) continue;
                img.flush();
            }
            this.imageViews.clear();
        }

        protected void viewCreated(ViewFactory factory, View view) {
            if (view instanceof ImageView) {
                Element e = ChatConversationPanel.this.findFirstElement(view.getElement(), "img");
                if (e == null) {
                    return;
                }
                Object src = e.getAttributes().getAttribute(HTML.Attribute.SRC);
                if (src != null && src instanceof String && ((String)src).endsWith("gif")) {
                    this.imageViews.add((ImageView)view);
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            Iterator<ImageView> imageViewIterator = this.imageViews.iterator();
            while (imageViewIterator.hasNext()) {
                ImageView iv = imageViewIterator.next();
                if (iv.getElement().getEndOffset() - iv.getElement().getStartOffset() != 0) continue;
                Image img = iv.getImage();
                if (img != null) {
                    img.flush();
                }
                imageViewIterator.remove();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        public void debug() {
            try {
                this.write(System.out, ChatConversationPanel.this.document, 0, ChatConversationPanel.this.document.getLength());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class MyTextPane
    extends JTextPane {
        private MyTextPane() {
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return ChatConversationPanel.this.currentHref != null && ChatConversationPanel.this.currentHref.length() != 0 ? ChatConversationPanel.this.currentHref : null;
        }
    }
}

