/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.util.Map;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.protocol.sip.SipAccountID;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;

public class SipAccountIDImpl
extends SipAccountID {
    private static String stripServerNameFromUserID(String userID) {
        int index = userID.indexOf("@");
        return index > -1 ? userID.substring(0, index) : userID;
    }

    static String sipUriToUserID(String sipUri) {
        int index = sipUri.indexOf("sip:");
        String userID = index > -1 ? sipUri.substring(4) : sipUri;
        return SipAccountIDImpl.stripServerNameFromUserID(userID);
    }

    static String sipUriToUserAddress(String sipUri) {
        int index = sipUri.indexOf("sip:");
        String userAddress = index > -1 ? sipUri.substring(4) : sipUri;
        return userAddress;
    }

    protected SipAccountIDImpl(String userID, Map<String, String> accountProperties, String serverName) {
        super(SipAccountIDImpl.stripServerNameFromUserID(userID), accountProperties, serverName);
    }

    public String getAccountAddress() {
        StringBuffer accountAddress = new StringBuffer();
        accountAddress.append("sip:");
        accountAddress.append(this.getUserID());
        String service = this.getService();
        if (service != null) {
            accountAddress.append('@');
            accountAddress.append(service);
        }
        return accountAddress.toString();
    }

    public String getDisplayName() {
        String key;
        String accountDisplayName;
        String protocolName = this.getAccountPropertyString("PROTOCOL_NAME");
        String service = this.getService();
        if (service == null || service.trim().length() == 0) {
            protocolName = "RegistrarLess " + protocolName;
        }
        if ((accountDisplayName = (String)this.accountProperties.get(key = "ACCOUNT_DISPLAY_NAME")) != null && accountDisplayName.length() > 0) {
            return accountDisplayName + " (" + protocolName + ")";
        }
        String returnValue = super.getAccountPropertyString((Object)"USER_ID");
        if (protocolName != null && protocolName.trim().length() > 0) {
            returnValue = returnValue + " (" + protocolName + ")";
        }
        return returnValue;
    }

    public String getSystemProtocolName() {
        return "SIP";
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && ((SipAccountIDImpl)((Object)obj)).getProtocolName().equals(this.getProtocolName()) && (this.getService() == null || this.getService().equals(((SipAccountIDImpl)((Object)obj)).getService()));
    }

    public String getAccountPropertyString(Object key) {
        if (key.equals("OPT_CLIST_PASSWORD")) {
            CredentialsStorageService credentialsStorage = (CredentialsStorageService)ServiceUtils.getService((BundleContext)SipActivator.getBundleContext(), CredentialsStorageService.class);
            return credentialsStorage.loadPassword(this.getAccountUniqueID() + ".xcap");
        }
        return super.getAccountPropertyString(key);
    }
}

