/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.MultiplexedXXXSocket;

abstract class MultiplexingXXXSocketSupport<MultiplexedXXXSocketT extends MultiplexedXXXSocket> {
    private static final Logger logger = Logger.getLogger(MultiplexingXXXSocketSupport.class.getName());
    private boolean inReceive = false;
    private int receiveBufferSize;
    private final Object receiveSyncRoot = new Object();
    private boolean setReceiveBufferSize = false;
    private final List<MultiplexedXXXSocketT> sockets = new ArrayList<MultiplexedXXXSocketT>();

    public static DatagramPacket clone(DatagramPacket p) {
        return MultiplexingXXXSocketSupport.clone(p, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DatagramPacket clone(DatagramPacket p, boolean arraycopy) {
        int port;
        InetAddress address;
        int len;
        int off;
        byte[] data;
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            data = p.getData();
            off = p.getOffset();
            len = p.getLength();
            byte[] dataClone = new byte[data.length];
            if (arraycopy && len > 0) {
                int arraycopyLen;
                int arraycopyOff;
                if (off >= 0 && off < data.length && off + len <= data.length) {
                    arraycopyOff = off;
                    arraycopyLen = len;
                } else {
                    arraycopyOff = 0;
                    arraycopyLen = data.length;
                }
                System.arraycopy(data, arraycopyOff, dataClone, arraycopyOff, arraycopyLen);
            }
            data = dataClone;
            address = p.getAddress();
            port = p.getPort();
        }
        DatagramPacket c = new DatagramPacket(data, off, len);
        if (address != null) {
            c.setAddress(address);
        }
        if (port >= 0) {
            c.setPort(port);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(DatagramPacket src, DatagramPacket dest) {
        DatagramPacket datagramPacket = dest;
        synchronized (datagramPacket) {
            dest.setAddress(src.getAddress());
            dest.setPort(src.getPort());
            byte[] srcData = src.getData();
            if (srcData == null) {
                dest.setLength(0);
            } else {
                byte[] destData = dest.getData();
                if (destData == null) {
                    dest.setLength(0);
                } else {
                    int srcLength;
                    int destOffset = dest.getOffset();
                    int destLength = destData.length - destOffset;
                    if (destLength >= (srcLength = src.getLength())) {
                        destLength = srcLength;
                    } else if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "Truncating received DatagramPacket data!");
                    }
                    System.arraycopy(srcData, src.getOffset(), destData, destOffset, destLength);
                    dest.setLength(destLength);
                }
            }
        }
    }

    protected MultiplexingXXXSocketSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptBySocketsOrThis(DatagramPacket p) {
        List<MultiplexedXXXSocketT> list = this.sockets;
        synchronized (list) {
            boolean accepted = false;
            for (MultiplexedXXXSocket socket : this.sockets) {
                List<DatagramPacket> socketReceived;
                if (!this.getFilter(socket).accept(p)) continue;
                List<DatagramPacket> list2 = socketReceived = this.getReceived(socket);
                synchronized (list2) {
                    socketReceived.add(accepted ? MultiplexingXXXSocketSupport.clone(p, true) : p);
                    socketReceived.notifyAll();
                }
                accepted = true;
            }
            if (!accepted) {
                List<DatagramPacket> thisReceived;
                List<DatagramPacket> list3 = thisReceived = this.getReceived();
                synchronized (list3) {
                    thisReceived.add(p);
                    thisReceived.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(MultiplexedXXXSocketT multiplexed) {
        List<MultiplexedXXXSocketT> list = this.sockets;
        synchronized (list) {
            this.sockets.remove(multiplexed);
        }
    }

    protected abstract MultiplexedXXXSocketT createSocket(DatagramPacketFilter var1) throws SocketException;

    protected abstract void doReceive(DatagramPacket var1) throws IOException;

    protected abstract void doSetReceiveBufferSize(int var1) throws SocketException;

    protected DatagramPacketFilter getFilter(MultiplexedXXXSocketT socket) {
        return socket.getFilter();
    }

    protected abstract List<DatagramPacket> getReceived();

    protected abstract List<DatagramPacket> getReceived(MultiplexedXXXSocketT var1);

    public MultiplexedXXXSocketT getSocket(DatagramPacketFilter filter) throws SocketException {
        return this.getSocket(filter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexedXXXSocketT getSocket(DatagramPacketFilter filter, boolean create) throws SocketException {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        List<MultiplexedXXXSocketT> list = this.sockets;
        synchronized (list) {
            for (MultiplexedXXXSocket socket : this.sockets) {
                if (!filter.equals(this.getFilter(socket))) continue;
                return (MultiplexedXXXSocketT)socket;
            }
            if (!create) {
                return null;
            }
            MultiplexedXXXSocketT socket = this.createSocket(filter);
            if (socket != null) {
                this.sockets.add(socket);
                this.moveReceivedFromThisToSocket(socket);
            }
            return socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveReceivedFromThisToSocket(MultiplexedXXXSocketT socket) {
        List<DatagramPacket> thisReceived = this.getReceived();
        DatagramPacketFilter socketFilter = this.getFilter(socket);
        LinkedList<DatagramPacket> toMove = null;
        List<DatagramPacket> list = thisReceived;
        synchronized (list) {
            if (thisReceived.isEmpty()) {
                return;
            }
            Iterator<DatagramPacket> i = thisReceived.iterator();
            while (i.hasNext()) {
                DatagramPacket p = i.next();
                if (!socketFilter.accept(p)) continue;
                if (toMove == null) {
                    toMove = new LinkedList<DatagramPacket>();
                }
                toMove.add(p);
                i.remove();
            }
        }
        if (toMove != null) {
            List<DatagramPacket> socketReceived;
            List<DatagramPacket> list2 = socketReceived = this.getReceived(socket);
            synchronized (list2) {
                socketReceived.addAll(toMove);
                socketReceived.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void receive(List<DatagramPacket> received, DatagramPacket p, int timeout) throws IOException {
        Object object;
        long startTime = System.currentTimeMillis();
        DatagramPacket r = null;
        while (true) {
            DatagramPacket c;
            block33: {
                boolean wait;
                long remainingTimeout;
                long now = System.currentTimeMillis();
                List<DatagramPacket> list = received;
                // MONITORENTER : list
                if (!received.isEmpty() && (r = received.remove(0)) != null) {
                    // MONITOREXIT : list
                    MultiplexingXXXSocketSupport.copy(r, p);
                    return;
                }
                // MONITOREXIT : list
                if (timeout > 0) {
                    remainingTimeout = (long)timeout - (now - startTime);
                    if (remainingTimeout <= 0L) {
                        throw new SocketTimeoutException(Long.toString(remainingTimeout));
                    }
                } else {
                    remainingTimeout = 1000L;
                }
                object = this.receiveSyncRoot;
                // MONITORENTER : object
                if (this.inReceive) {
                    wait = true;
                } else {
                    wait = false;
                    this.inReceive = true;
                }
                // MONITOREXIT : object
                if (wait) {
                    object = received;
                    // MONITORENTER : object
                    if (received.isEmpty()) {
                        try {
                            received.wait(remainingTimeout);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        received.notifyAll();
                    }
                    // MONITOREXIT : object
                    continue;
                }
                c = MultiplexingXXXSocketSupport.clone(p, false);
                Object object2 = this.receiveSyncRoot;
                // MONITORENTER : object2
                if (this.setReceiveBufferSize) {
                    this.setReceiveBufferSize = false;
                    try {
                        this.doSetReceiveBufferSize(this.receiveBufferSize);
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) break block33;
                        throw (ThreadDeath)t;
                    }
                }
            }
            // MONITOREXIT : object2
            this.doReceive(c);
            this.acceptBySocketsOrThis(c);
            continue;
            break;
        }
        finally {
            object = this.receiveSyncRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceiveBufferSize(int receiveBufferSize) throws SocketException {
        Object object = this.receiveSyncRoot;
        synchronized (object) {
            this.receiveBufferSize = receiveBufferSize;
            if (this.inReceive) {
                this.setReceiveBufferSize = true;
            } else {
                this.doSetReceiveBufferSize(receiveBufferSize);
                this.setReceiveBufferSize = false;
            }
        }
    }
}

