/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.ircaccregwizz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.TrimTextField;
import net.java.sip.communicator.plugin.ircaccregwizz.IrcAccRegWizzActivator;
import net.java.sip.communicator.plugin.ircaccregwizz.IrcAccountRegistration;
import net.java.sip.communicator.plugin.ircaccregwizz.IrcAccountRegistrationWizard;
import net.java.sip.communicator.plugin.ircaccregwizz.Resources;
import net.java.sip.communicator.service.gui.WizardPage;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class FirstWizardPage
extends TransparentPanel
implements WizardPage,
DocumentListener,
ActionListener {
    private static final long serialVersionUID = 0L;
    public static final String FIRST_PAGE_IDENTIFIER = "FirstPageIdentifier";
    public static final String USER_NAME_EXAMPLE = Resources.getString("plugin.ircaccregwizz.EXAMPLE_USERNAME");
    public static final String SERVER_EXAMPLE = Resources.getString("plugin.ircaccregwizz.EXAMPLE_SERVER");
    private static final String DEFAULT_PLAINTEXT_PORT = "6667";
    private static final String DEFAULT_SECURE_PORT = "6697";
    private JPanel userPassPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JPanel serverPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JPanel optionsPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JPanel saslPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JPanel labelsPanel = new TransparentPanel();
    private JPanel valuesPanel = new TransparentPanel();
    private JPanel labelsServerPanel = new TransparentPanel();
    private JPanel valuesServerPanel = new TransparentPanel();
    private JPanel labelsOptionsPanel = new TransparentPanel();
    private JPanel valuesOptionsPanel = new TransparentPanel();
    private JLabel infoPassword = new JLabel(Resources.getString("plugin.ircaccregwizz.INFO_PASSWORD"));
    private JLabel nick = new JLabel(Resources.getString("plugin.ircaccregwizz.USERNAME") + ":");
    private JLabel passLabel = new JLabel(Resources.getString("service.gui.PASSWORD") + ":");
    private JLabel server = new JLabel(Resources.getString("plugin.ircaccregwizz.HOST"));
    private JLabel port = new JLabel(Resources.getString("service.gui.PORT") + ":");
    private JPanel emptyPanel = new TransparentPanel();
    private JPanel emptyPanel2 = new TransparentPanel();
    private JLabel nickExampleLabel = new JLabel(USER_NAME_EXAMPLE);
    private JLabel serverExampleLabel = new JLabel(SERVER_EXAMPLE);
    private JTextField userIDField = new TrimTextField();
    private JPasswordField passField = new JPasswordField();
    private JTextField serverField = new JTextField();
    private JTextField portField = new JTextField();
    private JCheckBox rememberPassBox = new SIPCommCheckBox(Resources.getString("service.gui.REMEMBER_PASSWORD"));
    private JCheckBox autoNickChange = new SIPCommCheckBox(Resources.getString("plugin.ircaccregwizz.AUTO_NICK_CHANGE"));
    private JCheckBox resolveDnsThroughProxy = new SIPCommCheckBox(Resources.getString("plugin.ircaccregwizz.RESOLVE_DNS_THROUGH_PROXY"));
    private JCheckBox defaultPort = new SIPCommCheckBox(Resources.getString("plugin.ircaccregwizz.USE_DEFAULT_PORT"));
    private JCheckBox passwordNotRequired = new SIPCommCheckBox(Resources.getString("plugin.ircaccregwizz.PASSWORD_NOT_REQUIRED"));
    private JCheckBox useSecureConnection = new SIPCommCheckBox(Resources.getString("plugin.ircaccregwizz.USE_SECURE_CONNECTION"));
    private JCheckBox enableContactPresenceTask = new SIPCommCheckBox(Resources.getString("plugin.ircaccregwizz.ENABLE_CONTACT_PRESENCE"));
    private JCheckBox enableChatRoomPresenceTask = new SIPCommCheckBox(Resources.getString("plugin.ircaccregwizz.ENABLE_CHAT_ROOM_PRESENCE"));
    private JCheckBox saslEnabled = new SIPCommCheckBox(Resources.getString("plugin.ircaccregwizz.ENABLE_SASL_AUTHENTICATION"));
    private JTextField saslUserIdField = new JTextField();
    private JTextField saslRoleField = new JTextField();
    private JPanel mainPanel = new TransparentPanel();
    private Object nextPageIdentifier = "SUMMARY";
    private IrcAccountRegistrationWizard wizard;
    private boolean isCommitted = false;

    public FirstWizardPage(IrcAccountRegistrationWizard wizard, String userId, String server) {
        super((LayoutManager)new BorderLayout());
        this.wizard = wizard;
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.init(userId, server);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.labelsPanel.setLayout(new BoxLayout(this.labelsPanel, 1));
        this.valuesPanel.setLayout(new BoxLayout(this.valuesPanel, 1));
        this.labelsServerPanel.setLayout(new BoxLayout(this.labelsServerPanel, 1));
        this.valuesServerPanel.setLayout(new BoxLayout(this.valuesServerPanel, 1));
        this.labelsOptionsPanel.setLayout(new BoxLayout(this.labelsOptionsPanel, 1));
        this.valuesOptionsPanel.setLayout(new BoxLayout(this.valuesOptionsPanel, 1));
        this.portField.setEnabled(false);
        this.rememberPassBox.setEnabled(false);
        this.useSecureConnection.setEnabled(true);
        this.resolveDnsThroughProxy.setEnabled(true);
    }

    private void init(String userId, String server) {
        this.mainPanel.setOpaque(false);
        this.labelsPanel.setOpaque(false);
        this.valuesPanel.setOpaque(false);
        this.emptyPanel.setOpaque(false);
        this.userIDField.getDocument().addDocumentListener(this);
        this.serverField.getDocument().addDocumentListener(this);
        this.passField.getDocument().addDocumentListener(this);
        this.defaultPort.addActionListener(this);
        this.passwordNotRequired.addActionListener(this);
        this.useSecureConnection.addActionListener(this);
        this.saslEnabled.addActionListener(this);
        this.userIDField.setText(userId);
        this.serverField.setText(server);
        this.passField.setEnabled(false);
        this.rememberPassBox.setSelected(true);
        this.autoNickChange.setSelected(true);
        this.resolveDnsThroughProxy.setSelected(true);
        this.defaultPort.setSelected(true);
        this.passwordNotRequired.setSelected(true);
        this.useSecureConnection.setSelected(true);
        this.enableContactPresenceTask.setSelected(true);
        this.enableChatRoomPresenceTask.setSelected(true);
        this.portField.setText(this.useSecureConnection.isSelected() ? DEFAULT_SECURE_PORT : DEFAULT_PLAINTEXT_PORT);
        this.nickExampleLabel.setForeground(Color.GRAY);
        this.nickExampleLabel.setFont(this.nickExampleLabel.getFont().deriveFont(8));
        this.serverExampleLabel.setForeground(Color.GRAY);
        this.serverExampleLabel.setFont(this.serverExampleLabel.getFont().deriveFont(8));
        this.emptyPanel.setMaximumSize(new Dimension(40, 35));
        this.emptyPanel2.setMaximumSize(new Dimension(40, 35));
        this.nickExampleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.serverExampleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.labelsPanel.add(this.nick);
        this.labelsPanel.add(this.emptyPanel);
        this.labelsPanel.add(this.passLabel);
        this.valuesPanel.add(this.userIDField);
        this.valuesPanel.add(this.nickExampleLabel);
        this.valuesPanel.add(this.passField);
        this.userPassPanel.add((Component)this.infoPassword, "North");
        this.userPassPanel.add((Component)this.labelsPanel, "West");
        this.userPassPanel.add((Component)this.valuesPanel, "Center");
        this.userPassPanel.add((Component)this.passwordNotRequired, "South");
        this.userPassPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.ircaccregwizz.USERNAME_AND_PASSWORD")));
        this.labelsServerPanel.add(this.server);
        this.labelsServerPanel.add(this.emptyPanel2);
        this.labelsServerPanel.add(this.port);
        this.valuesServerPanel.add(this.serverField);
        this.valuesServerPanel.add(this.serverExampleLabel);
        this.valuesServerPanel.add(this.portField);
        this.serverPanel.add((Component)this.labelsServerPanel, "West");
        this.serverPanel.add((Component)this.valuesServerPanel, "Center");
        JPanel serverSubPanel = new JPanel(new BorderLayout());
        serverSubPanel.setOpaque(false);
        serverSubPanel.add((Component)this.defaultPort, "West");
        serverSubPanel.add((Component)this.useSecureConnection, "East");
        this.serverPanel.add((Component)serverSubPanel, "South");
        this.serverPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.ircaccregwizz.IRC_SERVER")));
        TransparentPanel optionsSubPanel = new TransparentPanel();
        optionsSubPanel.setLayout(new BoxLayout((Container)optionsSubPanel, 1));
        this.optionsPanel.add((Component)optionsSubPanel, "West");
        optionsSubPanel.add(this.rememberPassBox);
        optionsSubPanel.add(this.autoNickChange);
        TransparentPanel partition = new TransparentPanel();
        optionsSubPanel.add(this.resolveDnsThroughProxy);
        this.optionsPanel.add((Component)partition, "South");
        partition.setLayout(new BorderLayout());
        partition.add((Component)this.enableContactPresenceTask, "West");
        partition.add((Component)this.enableChatRoomPresenceTask, "East");
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("service.gui.OPTIONS")));
        this.saslPanel.add((Component)this.saslEnabled, "North");
        TransparentPanel saslControlsPanel = new TransparentPanel();
        saslControlsPanel.setLayout((LayoutManager)new BoxLayout((Container)saslControlsPanel, 1));
        this.saslPanel.add((Component)saslControlsPanel, "Center");
        JLabel saslUserLabel = new JLabel(Resources.getString("plugin.ircaccregwizz.SASL_USERNAME") + ":");
        saslControlsPanel.add((Component)this.horizontal(100, saslUserLabel, this.saslUserIdField));
        JLabel saslPassLabel = new JLabel(Resources.getString("service.gui.PASSWORD") + ":");
        saslControlsPanel.add((Component)this.horizontal(100, saslPassLabel, new JLabel(Resources.getString("plugin.ircaccregwizz.SASL_IRC_PASSWORD_USED"))));
        JLabel saslRoleLabel = new JLabel(Resources.getString("plugin.ircaccregwizz.SASL_AUTHZ_ROLE") + ":");
        saslControlsPanel.add((Component)this.horizontal(100, saslRoleLabel, this.saslRoleField));
        this.saslPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.ircaccregwizz.SASL_AUTHENTICATION_TITLE")));
        this.mainPanel.add(this.userPassPanel);
        this.mainPanel.add(this.serverPanel);
        this.mainPanel.add(this.optionsPanel);
        this.mainPanel.add(this.saslPanel);
        this.add(this.mainPanel, "North");
    }

    private JPanel horizontal(int width, Component cmp1, Component cmp2) {
        TransparentPanel panel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        cmp1.setPreferredSize(new Dimension(width, cmp1.getHeight()));
        panel.add(cmp1, (Object)"West");
        panel.add(cmp2, (Object)"Center");
        return panel;
    }

    public Object getIdentifier() {
        return FIRST_PAGE_IDENTIFIER;
    }

    public Object getNextPageIdentifier() {
        return this.nextPageIdentifier;
    }

    public Object getBackPageIdentifier() {
        return null;
    }

    public Object getWizardForm() {
        return this;
    }

    public void pageShowing() {
        this.setNextButtonAccordingToUserID();
    }

    public void commitPage() {
        this.nextPageIdentifier = "SUMMARY";
        IrcAccountRegistration registration = this.wizard.getRegistration();
        String userID = this.userIDField.getText();
        if (userID == null || userID.trim().length() == 0) {
            throw new IllegalStateException("No user ID provided.");
        }
        registration.setUserID(userID);
        if (this.passField.getPassword() != null) {
            registration.setPassword(new String(this.passField.getPassword()));
        }
        registration.setServer(this.serverField.getText());
        registration.setPort(this.portField.getText());
        registration.setRememberPassword(this.rememberPassBox.isSelected());
        registration.setAutoChangeNick(this.autoNickChange.isSelected());
        registration.setRequiredPassword(!this.passwordNotRequired.isSelected());
        registration.setSecureConnection(this.useSecureConnection.isSelected());
        registration.setContactPresenceTaskEnabled(this.enableContactPresenceTask.isSelected());
        registration.setChatRoomPresenceTaskEnabled(this.enableChatRoomPresenceTask.isSelected());
        registration.setSaslEnabled(!this.passwordNotRequired.isSelected() && this.saslEnabled.isSelected());
        registration.setSaslUser(this.saslUserIdField.getText());
        registration.setSaslRole(this.saslRoleField.getText());
        registration.setResolveDnsThroughProxy(this.resolveDnsThroughProxy.isSelected());
        this.isCommitted = true;
    }

    private void setNextButtonAccordingToUserID() {
        if (this.userIDField.getText() == null || this.userIDField.getText().equals("") || this.serverField.getText() == null || this.serverField.getText().equals("") || !this.passwordNotRequired.isSelected() && this.isEmpty(this.passField)) {
            this.wizard.getWizardContainer().setNextFinishButtonEnabled(false);
        } else {
            this.wizard.getWizardContainer().setNextFinishButtonEnabled(true);
        }
    }

    private boolean isEmpty(JPasswordField passField) {
        char[] pass;
        if (passField.getDocument() != null && (pass = passField.getPassword()) != null) {
            Arrays.fill(pass, '\u0000');
            return pass.length <= 0;
        }
        return true;
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.setNextButtonAccordingToUserID();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.setNextButtonAccordingToUserID();
    }

    public void loadAccount(ProtocolProviderService protocolProvider) {
        AccountID accountID = protocolProvider.getAccountID();
        String password = IrcAccRegWizzActivator.getIrcProtocolProviderFactory().loadPassword(accountID);
        String server = accountID.getAccountPropertyString((Object)"SERVER_ADDRESS");
        String port = accountID.getAccountPropertyString((Object)"SERVER_PORT");
        String autoNickChange = accountID.getAccountPropertyString((Object)"AUTO_CHANGE_USER_NAME");
        String noPasswordRequired = accountID.getAccountPropertyString((Object)"NO_PASSWORD_REQUIRED");
        boolean useSecureConnection = accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true);
        boolean resolveDnsThroughProxy = accountID.getAccountPropertyBoolean((Object)"RESOLVE_DNS_THROUGH_PROXY", true);
        boolean contactPresenceTaskEnabled = accountID.getAccountPropertyBoolean((Object)"CONTACT_PRESENCE_TASK", true);
        boolean chatRoomPresenceTaskEnabled = accountID.getAccountPropertyBoolean((Object)"CHAT_ROOM_PRESENCE_TASK", true);
        boolean enableSaslAuthentication = accountID.getAccountPropertyBoolean((Object)"SASL_ENABLED", false);
        String saslUser = accountID.getAccountPropertyString((Object)"SASL_USERNAME", "");
        String saslRole = accountID.getAccountPropertyString((Object)"SASL_ROLE", "");
        this.userIDField.setEnabled(false);
        this.userIDField.setText(accountID.getUserID());
        this.serverField.setText(server);
        if (password != null) {
            this.passField.setText(password);
            this.rememberPassBox.setSelected(true);
        }
        if (port != null) {
            this.portField.setText(port);
            boolean defaultPort = useSecureConnection && DEFAULT_SECURE_PORT.equals(port) || DEFAULT_PLAINTEXT_PORT.equals(port);
            this.portField.setEnabled(!defaultPort);
            this.defaultPort.setSelected(defaultPort);
        }
        if (autoNickChange != null) {
            this.autoNickChange.setSelected(new Boolean(autoNickChange));
        }
        this.resolveDnsThroughProxy.setSelected(resolveDnsThroughProxy);
        if (noPasswordRequired != null) {
            boolean isPassRequired = Boolean.valueOf(noPasswordRequired) == false;
            this.passwordNotRequired.setSelected(!isPassRequired);
            this.rememberPassBox.setEnabled(isPassRequired);
            this.passField.setEnabled(isPassRequired);
        }
        this.useSecureConnection.setSelected(useSecureConnection);
        this.enableContactPresenceTask.setSelected(contactPresenceTaskEnabled);
        this.enableChatRoomPresenceTask.setSelected(chatRoomPresenceTaskEnabled);
        this.saslEnabled.setSelected(enableSaslAuthentication);
        this.saslUserIdField.setText(saslUser);
        this.saslRoleField.setText(saslRole);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean passwordRequired;
        if (this.defaultPort.isSelected()) {
            this.portField.setText(this.useSecureConnection.isSelected() ? DEFAULT_SECURE_PORT : DEFAULT_PLAINTEXT_PORT);
            this.portField.setEnabled(false);
        } else {
            this.portField.setEnabled(true);
        }
        boolean bl = passwordRequired = !this.passwordNotRequired.isSelected();
        if (passwordRequired) {
            this.passField.setEnabled(true);
            this.rememberPassBox.setEnabled(true);
            this.saslEnabled.setEnabled(true);
        } else {
            this.passField.setText("");
            this.passField.setEnabled(false);
            this.rememberPassBox.setEnabled(false);
            this.saslEnabled.setEnabled(false);
        }
        boolean enableSaslControls = passwordRequired && this.saslEnabled.isSelected();
        this.saslUserIdField.setEnabled(enableSaslControls);
        this.saslRoleField.setEnabled(enableSaslControls);
        this.setNextButtonAccordingToUserID();
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
    }

    public void pageHiding() {
    }

    public void pageShown() {
    }

    public void pageBack() {
    }

    public Object getSimpleForm() {
        TransparentPanel simplePanel = new TransparentPanel((LayoutManager)new BorderLayout());
        TransparentPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
        TransparentPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
        simplePanel.setOpaque(false);
        labelsPanel.setOpaque(false);
        valuesPanel.setOpaque(false);
        this.emptyPanel2.setOpaque(false);
        simplePanel.add((Component)labelsPanel, "West");
        simplePanel.add((Component)valuesPanel, "Center");
        labelsPanel.add(this.nick);
        labelsPanel.add(this.emptyPanel);
        labelsPanel.add(this.server);
        labelsPanel.add(this.emptyPanel2);
        valuesPanel.add(this.userIDField);
        valuesPanel.add(this.nickExampleLabel);
        valuesPanel.add(this.serverField);
        valuesPanel.add(this.serverExampleLabel);
        return simplePanel;
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public String getCurrentUserId() {
        return this.userIDField.getText();
    }

    public String getCurrentServer() {
        return this.serverField.getText();
    }
}

