/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call.conference;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.conference.BasicConferenceCallPanel;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.util.skin.Skinnable;

public class CallPeerMenu
extends SIPCommMenu
implements CallPeerListener,
Skinnable {
    private static final long serialVersionUID = 0L;
    private final CallPeer callPeer;
    private BasicConferenceCallPanel conferenceCallPanel;
    private final String onHoldText = GuiActivator.getResources().getI18NString("service.gui.PUT_ON_HOLD");
    private final String offHoldText = GuiActivator.getResources().getI18NString("service.gui.PUT_OFF_HOLD");
    private final JMenuItem holdMenuItem;

    public CallPeerMenu(CallPeer peer, BasicConferenceCallPanel conferencePanel) {
        this.callPeer = peer;
        this.conferenceCallPanel = conferencePanel;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setPreferredSize(new Dimension(16, 16));
        this.setHorizontalAlignment(0);
        this.loadSkin();
        this.setIconTextGap(0);
        this.addItem(GuiActivator.getResources().getI18NString("service.gui.HANG_UP"), null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CallPeerMenu.this.callPeer.getState() == CallPeerState.DISCONNECTED || CallPeerMenu.this.callPeer.getState() == CallPeerState.FAILED) {
                    CallPeerMenu.this.conferenceCallPanel.removeDelayedCallPeer(CallPeerMenu.this.callPeer, true);
                    CallPeerMenu.this.conferenceCallPanel.updateViewFromModel();
                } else {
                    CallManager.hangupCallPeer(CallPeerMenu.this.callPeer);
                }
            }
        });
        this.holdMenuItem = new JMenuItem(CallPeerState.isOnHold((CallPeerState)this.callPeer.getState()) ? this.offHoldText : this.onHoldText);
        this.initHoldMenuItem();
        this.add(this.holdMenuItem);
        peer.addCallPeerListener((CallPeerListener)this);
    }

    private void initHoldMenuItem() {
        this.holdMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CallPeerMenu.this.holdMenuItem.getText().equals(CallPeerMenu.this.onHoldText)) {
                    CallManager.putOnHold(CallPeerMenu.this.callPeer, true);
                    CallPeerMenu.this.holdMenuItem.setText(CallPeerMenu.this.offHoldText);
                } else {
                    CallManager.putOnHold(CallPeerMenu.this.callPeer, false);
                    CallPeerMenu.this.holdMenuItem.setText(CallPeerMenu.this.onHoldText);
                }
            }
        });
    }

    public void peerStateChanged(final CallPeerChangeEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CallPeerMenu.this.peerStateChanged(evt);
                }
            });
            return;
        }
        CallPeerState newState = (CallPeerState)evt.getNewValue();
        CallPeerState oldState = (CallPeerState)evt.getOldValue();
        if (newState == CallPeerState.CONNECTED && CallPeerState.isOnHold((CallPeerState)oldState)) {
            this.holdMenuItem.setText(this.onHoldText);
        } else if (CallPeerState.isOnHold((CallPeerState)newState)) {
            this.holdMenuItem.setText(this.offHoldText);
        }
        this.holdMenuItem.setEnabled(CallPeerState.DISCONNECTED != newState && CallPeerState.FAILED != newState);
    }

    public void peerAddressChanged(CallPeerChangeEvent evt) {
    }

    public void peerDisplayNameChanged(CallPeerChangeEvent evt) {
    }

    public void peerImageChanged(CallPeerChangeEvent evt) {
    }

    public void peerTransportAddressChanged(CallPeerChangeEvent evt) {
    }

    public void loadSkin() {
        Component[] components;
        this.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CALL_PEER_TOOLS)));
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof Skinnable)) continue;
            Skinnable skinnableComponent = (Skinnable)component;
            skinnableComponent.loadSkin();
        }
    }
}

