/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.replacement.vimeo;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sip.communicator.service.replacement.ReplacementService;
import net.java.sip.communicator.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ReplacementServiceVimeoImpl
implements ReplacementService {
    private static final Logger logger = Logger.getLogger(ReplacementServiceVimeoImpl.class);
    public static final String VIMEO_PATTERN = "(https?\\:\\/\\/(www\\.)*?vimeo\\.com\\/([a-zA-Z0-9_\\-]+))";
    public static final String VIMEO_CONFIG_LABEL = "Vimeo";
    public static final String SOURCE_NAME = "VIMEO";

    public ReplacementServiceVimeoImpl() {
        logger.trace((Object)"Creating a Vimeo Source.");
    }

    public String getReplacement(String sourceString) {
        Pattern p = Pattern.compile(".+\\.com\\/([a-zA-Z0-9_\\-]+)", 34);
        Matcher m = p.matcher(sourceString);
        String thumbUrl = sourceString;
        while (m.find()) {
            try {
                String inputLine;
                String url = "http://vimeo.com/api/v2/video/" + m.group(1) + ".json";
                URL vimeoURL = new URL(url);
                URLConnection conn = vimeoURL.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String holder = "";
                while ((inputLine = in.readLine()) != null) {
                    holder = inputLine;
                }
                in.close();
                JSONArray result = (JSONArray)JSONValue.parseWithException((String)holder);
                if (result.isEmpty()) continue;
                thumbUrl = (String)((JSONObject)result.get(0)).get((Object)"thumbnail_medium");
            }
            catch (Throwable e) {
                logger.error((Object)"Error parsing", e);
            }
        }
        return thumbUrl;
    }

    public String getSourceName() {
        return SOURCE_NAME;
    }

    public String getPattern() {
        return VIMEO_PATTERN;
    }
}

