/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.service.protocol.AccountInfoUtils;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetAvatar;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.service.protocol.event.AvatarEvent;
import net.java.sip.communicator.service.protocol.event.AvatarListener;
import net.java.sip.communicator.util.Logger;

public abstract class AbstractOperationSetAvatar<T extends ProtocolProviderService>
implements OperationSetAvatar {
    private static final Logger logger = Logger.getLogger(AbstractOperationSetAvatar.class);
    private final int maxWidth;
    private final int maxHeight;
    private final int maxSize;
    private final T parentProvider;
    private final OperationSetServerStoredAccountInfo accountInfoOpSet;
    private final List<AvatarListener> avatarListeners = new ArrayList<AvatarListener>();

    protected AbstractOperationSetAvatar(T parentProvider, OperationSetServerStoredAccountInfo accountInfoOpSet, int maxWidth, int maxHeight, int maxSize) {
        this.parentProvider = parentProvider;
        this.accountInfoOpSet = accountInfoOpSet;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.maxSize = maxSize;
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public byte[] getAvatar() {
        return AccountInfoUtils.getImage(this.accountInfoOpSet);
    }

    @Override
    public void setAvatar(byte[] avatar) {
        ServerStoredDetails.ImageDetail oldDetail = null;
        ServerStoredDetails.ImageDetail newDetail = new ServerStoredDetails.ImageDetail("avatar", avatar);
        Iterator<ServerStoredDetails.GenericDetail> imageDetails = this.accountInfoOpSet.getDetails(ServerStoredDetails.ImageDetail.class);
        if (imageDetails.hasNext()) {
            oldDetail = (ServerStoredDetails.ImageDetail)imageDetails.next();
        }
        try {
            if (oldDetail == null) {
                this.accountInfoOpSet.addDetail(newDetail);
            } else {
                this.accountInfoOpSet.replaceDetail(oldDetail, newDetail);
            }
            this.accountInfoOpSet.save();
        }
        catch (OperationFailedException e) {
            logger.warn((Object)"Unable to set new avatar", (Throwable)e);
        }
        this.fireAvatarChanged(avatar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAvatarListener(AvatarListener listener) {
        List<AvatarListener> list = this.avatarListeners;
        synchronized (list) {
            if (!this.avatarListeners.contains(listener)) {
                this.avatarListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAvatarListener(AvatarListener listener) {
        List<AvatarListener> list = this.avatarListeners;
        synchronized (list) {
            if (this.avatarListeners.contains(listener)) {
                this.avatarListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAvatarChanged(byte[] newAvatar) {
        ArrayList<AvatarListener> listeners;
        List<AvatarListener> list = this.avatarListeners;
        synchronized (list) {
            listeners = new ArrayList<AvatarListener>(this.avatarListeners);
        }
        if (!listeners.isEmpty()) {
            AvatarEvent event = new AvatarEvent(this, (ProtocolProviderService)this.parentProvider, newAvatar);
            for (AvatarListener l : listeners) {
                l.avatarChanged(event);
            }
        }
    }
}

