/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.macwidgets.plaf.HudPaintingUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.plaf.basic.BasicCheckBoxUI;

public class HudCheckBoxUI
extends BasicCheckBoxUI {
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        HudPaintingUtils.initHudComponent(b);
        b.setIconTextGap(5);
        this.icon = new CheckIcon();
    }

    private static class CheckIcon
    implements Icon {
        private final int CHECK_BOX_SIZE = 12;

        private CheckIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton button = (AbstractButton)c;
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.translate(x, y);
            HudPaintingUtils.paintHudControlBackground(graphics, button, 12, 12, HudPaintingUtils.Roundedness.CHECK_BOX);
            this.drawCheckMarkIfNecessary(graphics, button.getModel());
            graphics.dispose();
        }

        private void drawCheckMarkIfNecessary(Graphics2D graphics, ButtonModel model) {
            if (model.isSelected()) {
                this.drawCheckMark(graphics, model);
            }
        }

        private void drawCheckMark(Graphics2D graphics, ButtonModel model) {
            int x1 = 3;
            int y1 = 4;
            int x2 = x1 + 2;
            int y2 = y1 + 3;
            int x3 = 10;
            int y3 = -1;
            Color color = model.isPressed() ? HudPaintingUtils.PRESSED_MARK_COLOR : HudPaintingUtils.FONT_COLOR;
            graphics.setStroke(new BasicStroke(1.65f, 2, 1));
            graphics.setColor(color);
            graphics.drawLine(x1, y1, x2, y2);
            graphics.drawLine(x2, y2, x3, y3);
        }

        public int getIconWidth() {
            return 12;
        }

        public int getIconHeight() {
            return 12;
        }
    }
}

