/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.registry;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import net.sf.fmj.registry.RegistryContents;
import net.sf.fmj.registry.RegistryIO;

class PropertiesRegistryIO
implements RegistryIO {
    private final RegistryContents contents;
    final String[] PLUGIN_TYPE_STRINGS = new String[]{"demux", "codec", "effect", "renderer", "mux"};
    final String CONTENT_PREFIX_STRING = "content-prefix";
    final String PROTOCOL_PREFIX_STRING = "protocol-prefix";
    private static final int MAX = 100;

    public PropertiesRegistryIO(RegistryContents contents) {
        this.contents = contents;
    }

    private void fromProperties(Properties p) {
        String s;
        int j;
        for (int i = 0; i < this.contents.plugins.length; ++i) {
            String typeStr = this.PLUGIN_TYPE_STRINGS[i];
            Vector<String> v = this.contents.plugins[i];
            for (int j2 = 0; j2 < 100; ++j2) {
                String s2 = p.getProperty(typeStr + j2);
                if (s2 == null || s2.equals("")) continue;
                v.add(s2);
            }
        }
        Vector<String> v = this.contents.contentPrefixList;
        for (j = 0; j < 100; ++j) {
            s = p.getProperty("content-prefix" + j);
            if (s == null || s.equals("")) continue;
            v.add(s);
        }
        v = this.contents.protocolPrefixList;
        for (j = 0; j < 100; ++j) {
            s = p.getProperty("protocol-prefix" + j);
            if (s == null || s.equals("")) continue;
            v.add(s);
        }
    }

    @Override
    public void load(InputStream is) throws IOException {
        Properties p = new Properties();
        p.load(is);
        this.fromProperties(p);
    }

    private Properties toProperties() {
        int j;
        Properties p = new Properties();
        for (int i = 0; i < this.contents.plugins.length; ++i) {
            String typeStr = this.PLUGIN_TYPE_STRINGS[i];
            Vector<String> v = this.contents.plugins[i];
            for (int j2 = 0; j2 < v.size(); ++j2) {
                p.setProperty(typeStr + j2, v.get(j2));
            }
        }
        Vector<String> v = this.contents.contentPrefixList;
        for (j = 0; j < v.size(); ++j) {
            p.setProperty("content-prefix" + j, v.get(j));
        }
        v = this.contents.protocolPrefixList;
        for (j = 0; j < v.size(); ++j) {
            p.setProperty("protocol-prefix" + j, v.get(j));
        }
        return p;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        Properties p = this.toProperties();
        p.store(os, "FMJ registry");
    }
}

