/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.contactlist.RenameGroupPanel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.MetaContactListService;

public class RenameGroupDialog
extends SIPCommDialog
implements ActionListener {
    private RenameGroupPanel renameGroupPanel;
    private JButton renameButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.RENAME"));
    private JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    private TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
    private TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private MetaContactListService clist;
    private MetaContactGroup metaGroup;

    public RenameGroupDialog(MainFrame mainFrame, MetaContactGroup metaGroup) {
        super((Frame)((Object)mainFrame));
        this.setSize(new Dimension(520, 270));
        this.clist = GuiActivator.getContactListService();
        this.metaGroup = metaGroup;
        this.renameGroupPanel = new RenameGroupPanel(metaGroup.getGroupName());
        this.init();
    }

    private void init() {
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.RENAME_GROUP"));
        this.getRootPane().setDefaultButton(this.renameButton);
        this.renameButton.setName("rename");
        this.cancelButton.setName("cancel");
        this.renameButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.RENAME"));
        this.cancelButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CANCEL"));
        this.renameButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttonsPanel.add((Component)this.renameButton);
        this.buttonsPanel.add((Component)this.cancelButton);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        this.mainPanel.add((Component)((Object)this.renameGroupPanel), (Object)"North");
        this.mainPanel.add((Component)this.buttonsPanel, (Object)"South");
        this.getContentPane().add((Component)this.mainPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        String name = button.getName();
        if (name.equals("rename")) {
            if (this.metaGroup != null) {
                new Thread(){

                    @Override
                    public void run() {
                        RenameGroupDialog.this.clist.renameMetaContactGroup(RenameGroupDialog.this.metaGroup, RenameGroupDialog.this.renameGroupPanel.getNewName());
                    }
                }.start();
            }
            this.dispose();
        } else {
            this.dispose();
        }
    }

    public void requestFocusInFiled() {
        this.renameGroupPanel.requestFocusInField();
    }

    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }
}

