/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.contactlist.AddContactDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.MetaContactListManager;
import net.java.sip.communicator.impl.gui.main.contactlist.RenameGroupDialog;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class GroupRightButtonMenu
extends SIPCommPopupMenu
implements ActionListener,
PluginComponentListener,
Skinnable {
    private final Logger logger = Logger.getLogger(GroupRightButtonMenu.class);
    private final JMenuItem addContactItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT") + "...");
    private final JMenuItem removeGroupItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.REMOVE_GROUP"));
    private final JMenuItem renameGroupItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.RENAME_GROUP"));
    private final MetaContactGroup group;
    private final MainFrame mainFrame;

    public GroupRightButtonMenu(MainFrame mainFrame, MetaContactGroup group) {
        this.group = group;
        this.mainFrame = mainFrame;
        if (!ConfigurationUtils.isAddContactDisabled()) {
            this.add(this.addContactItem);
            this.addSeparator();
        }
        if (!ConfigurationUtils.isGroupRenameDisabled()) {
            this.add(this.renameGroupItem);
        }
        if (!ConfigurationUtils.isGroupRemoveDisabled()) {
            this.add(this.removeGroupItem);
        }
        this.addContactItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.ADD_CONTACT"));
        this.renameGroupItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.RENAME_GROUP"));
        this.removeGroupItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.REMOVE_GROUP"));
        this.addContactItem.addActionListener(this);
        this.renameGroupItem.addActionListener(this);
        this.removeGroupItem.addActionListener(this);
        this.loadSkin();
        this.initPluginComponents();
    }

    private void initPluginComponents() {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(CONTAINER_ID=" + Container.CONTAINER_GROUP_RIGHT_BUTTON_MENU.getID() + ")";
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(PluginComponentFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException exc) {
            this.logger.error((Object)"Could not obtain plugin reference.", (Throwable)exc);
        }
        if (serRefs != null) {
            for (int i = 0; i < serRefs.length; ++i) {
                PluginComponentFactory factory = (PluginComponentFactory)GuiActivator.bundleContext.getService(serRefs[i]);
                PluginComponent component = factory.getPluginComponentInstance((Object)this);
                component.setCurrentContactGroup(this.group);
                this.add((Component)component.getComponent());
                this.repaint();
            }
        }
        GuiActivator.getUIService().addPluginComponentListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem item = (JMenuItem)e.getSource();
        if (item.equals(this.removeGroupItem)) {
            if (this.group != null) {
                MetaContactListManager.removeMetaContactGroup(this.group);
            }
        } else if (item.equals(this.renameGroupItem)) {
            RenameGroupDialog dialog = new RenameGroupDialog(this.mainFrame, this.group);
            dialog.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - 200, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - 50);
            dialog.setVisible(true);
            dialog.requestFocusInFiled();
        } else if (item.equals(this.addContactItem)) {
            AddContactDialog dialog = new AddContactDialog((Frame)((Object)this.mainFrame));
            dialog.setSelectedGroup(this.group);
            dialog.setVisible(true);
        }
    }

    @Override
    public void pluginComponentAdded(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (!factory.getContainer().equals((Object)Container.CONTAINER_GROUP_RIGHT_BUTTON_MENU)) {
            return;
        }
        PluginComponent c = factory.getPluginComponentInstance((Object)this);
        this.add((Component)c.getComponent());
        c.setCurrentContactGroup(this.group);
        this.repaint();
    }

    @Override
    public void pluginComponentRemoved(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (factory.getContainer().equals((Object)Container.CONTAINER_GROUP_RIGHT_BUTTON_MENU)) {
            this.remove((Component)factory.getPluginComponentInstance((Object)this).getComponent());
        }
    }

    public void loadSkin() {
        this.addContactItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.ADD_CONTACT_16x16_ICON)));
        this.removeGroupItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.DELETE_16x16_ICON)));
        this.renameGroupItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.RENAME_16x16_ICON)));
    }
}

