/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.amrwb;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.audio.FFmpegAudioEncoder;

public class JNIEncoder
extends FFmpegAudioEncoder {
    static final int[] BIT_RATES;
    static final AudioFormat[] SUPPORTED_INPUT_FORMATS;
    static final AudioFormat[] SUPPORTED_OUTPUT_FORMATS;
    private int bitRate = BIT_RATES[BIT_RATES.length - 1];
    private boolean packetize = false;

    public JNIEncoder() {
        super("AMR-WB JNI Encoder", 73729, (Format[])SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
    }

    @Override
    protected void configureAVCodecContext(long avctx, AudioFormat format) {
        super.configureAVCodecContext(avctx, format);
        FFmpeg.avcodeccontext_set_bit_rate((long)avctx, (int)this.bitRate);
    }

    @Override
    protected int doProcess(Buffer inBuf, Buffer outBuf) {
        int doProcess = super.doProcess(inBuf, outBuf);
        if (this.packetize && (doProcess & 1) == 0 && (doProcess & 4) == 0) {
            int packetize = this.packetize(outBuf);
            if ((packetize & 1) != 0) {
                doProcess |= 1;
            }
            if ((packetize & 4) != 0) {
                doProcess |= 4;
            }
        }
        return doProcess;
    }

    private int packetize(Buffer buf) {
        byte[] src = (byte[])buf.getData();
        int srcLen = buf.getLength();
        int srcOff = buf.getOffset();
        int dstLen = srcLen + 1;
        byte[] dst = new byte[dstLen];
        int cmr = 15;
        int ft = 8;
        int q = 1;
        dst[0] = (byte)((cmr & 0xF) << 4 | (ft & 0xE) >>> 1);
        dst[1] = (byte)((ft & 1) << 7 | (q & 1) << 6);
        int srcEnd = srcOff + srcLen;
        int dstI = 1;
        for (int srcI = srcOff + 1; srcI < srcEnd; ++srcI) {
            int s = 0xFF & src[srcI];
            int d = 0xC0 & dst[dstI];
            dst[dstI] = (byte)(d |= (0xFC & s) >>> 2);
            dst[++dstI] = (byte)((3 & s) << 6);
        }
        buf.setData((Object)dst);
        buf.setDuration(20000000L);
        buf.setLength(dstLen);
        buf.setOffset(0);
        return 0;
    }

    @Override
    public Format setOutputFormat(Format format) {
        if ((format = super.setOutputFormat(format)) != null) {
            String encoding = format.getEncoding();
            this.packetize = encoding != null && encoding.endsWith("/rtp");
        }
        return format;
    }

    static {
        JNIEncoder.assertFindAVCodec(73729);
        BIT_RATES = new int[]{6600, 8850, 12650, 14250, 15850, 18250, 19850, 23050, 23850};
        SUPPORTED_INPUT_FORMATS = new AudioFormat[]{new AudioFormat("LINEAR", 16000.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
        SUPPORTED_OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat("AMR-WB/rtp", 16000.0, -1, 1), new AudioFormat("AMR-WB", 16000.0, -1, 1)};
    }
}

