/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cryptozrtp.agreement;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import java.security.SecureRandom;
import org.bouncycastle.cryptozrtp.CipherParameters;
import org.bouncycastle.cryptozrtp.params.AsymmetricKeyParameter;
import org.bouncycastle.cryptozrtp.params.DHParameters;
import org.bouncycastle.cryptozrtp.params.DHPrivateKeyParameters;
import org.bouncycastle.cryptozrtp.params.DHPublicKeyParameters;
import org.bouncycastle.cryptozrtp.params.ParametersWithRandom;

public class DHAgreement {
    private DHPrivateKeyParameters key;
    private DHParameters dhParams;
    private BigIntegerCrypto privateValue;
    private SecureRandom random;

    public void init(CipherParameters param) {
        AsymmetricKeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)((Object)param);
            this.random = rParam.getRandom();
            kParam = (AsymmetricKeyParameter)rParam.getParameters();
        } else {
            this.random = new SecureRandom();
            kParam = (AsymmetricKeyParameter)param;
        }
        if (!(kParam instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.key = (DHPrivateKeyParameters)kParam;
        this.dhParams = this.key.getParameters();
    }

    public BigIntegerCrypto calculateMessage() {
        int bits = this.dhParams.getP().bitLength() - 1;
        this.privateValue = new BigIntegerCrypto(bits, this.random).setBit(bits - 1);
        return this.dhParams.getG().modPow(this.privateValue, this.dhParams.getP());
    }

    public BigIntegerCrypto calculateAgreement(DHPublicKeyParameters pub, BigIntegerCrypto message) {
        if (!pub.getParameters().equals(this.dhParams)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        return message.modPow(this.key.getX(), this.dhParams.getP()).multiply(pub.getY().modPow(this.privateValue, this.dhParams.getP())).mod(this.dhParams.getP());
    }
}

