/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.muc;

import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.impl.muc.ServerChatRoomQuery;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.SortedGenericSourceContact;
import net.java.sip.communicator.service.muc.ChatRoomPresenceStatus;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class BaseChatRoomSourceContact
extends SortedGenericSourceContact {
    protected final ContactQuery parentQuery;
    private String chatRoomName;
    private String chatRoomID;
    private ProtocolProviderService provider;

    public BaseChatRoomSourceContact(String chatRoomName, String chatRoomID, ContactQuery query, ProtocolProviderService pps) {
        super(query, query.getContactSource(), chatRoomName, BaseChatRoomSourceContact.generateDefaultContactDetails(chatRoomName));
        this.chatRoomName = chatRoomName;
        this.chatRoomID = chatRoomID;
        this.provider = pps;
        this.parentQuery = query;
        this.initContactProperties(ChatRoomPresenceStatus.CHAT_ROOM_OFFLINE);
        this.setDisplayDetails(pps.getAccountID().getDisplayName());
    }

    protected void initContactProperties(PresenceStatus status) {
        this.setPresenceStatus(status);
        this.setContactAddress(this.chatRoomName);
    }

    private static List<ContactDetail> generateDefaultContactDetails(String chatRoomName) {
        ContactDetail contactDetail = new ContactDetail(chatRoomName);
        ArrayList<Class<OperationSetMultiUserChat>> supportedOpSets = new ArrayList<Class<OperationSetMultiUserChat>>();
        supportedOpSets.add(OperationSetMultiUserChat.class);
        contactDetail.setSupportedOpSets(supportedOpSets);
        ArrayList<ContactDetail> contactDetails = new ArrayList<ContactDetail>();
        contactDetails.add(contactDetail);
        return contactDetails;
    }

    public String getChatRoomID() {
        return this.chatRoomID;
    }

    public String getChatRoomName() {
        return this.chatRoomName;
    }

    public ProtocolProviderService getProvider() {
        return this.provider;
    }

    public int getIndex() {
        if (this.parentQuery instanceof ServerChatRoomQuery) {
            return ((ServerChatRoomQuery)this.parentQuery).indexOf(this);
        }
        return -1;
    }
}

