/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.rvcmd.InvitationMessage;
import net.kano.joscar.rvcmd.sendfile.FileSendBlock;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.MutableSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ChecksummerImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.DefaultTransferredFileFactory;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FileChecksummer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FileTransferHelper;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FileTransferRequestMaker;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.NextStateControllerInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.OutgoingFileTransfer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.OutgoingRvConnectionImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvRequestMaker;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.TransferredFileFactory;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ChecksumController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ConnectedController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.SendFileController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.SendOverProxyController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.SendPassivelyController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferredFile;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ChecksummingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectionCompleteEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.RvConnectionEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.UnknownErrorEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.ComputedChecksumsInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.FailedStateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StateInfo;
import net.kano.joustsim.oscar.proxy.AimProxyInfo;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingFileTransferImpl
extends OutgoingRvConnectionImpl
implements OutgoingFileTransfer {
    @Nullable
    private String displayName;
    private Map<TransferredFile, Long> checksums = new HashMap<TransferredFile, Long>();
    private FileChecksummer fileChecksummer = new FileChecksummerImpl();
    private final FileTransferHelper helper = new FileTransferHelper(this);
    private List<TransferredFile> tfiles = new ArrayList<TransferredFile>();
    private TransferredFileFactory transferredFileFactory = new DefaultTransferredFileFactory();

    public OutgoingFileTransferImpl(AimProxyInfo proxy, Screenname screenname, RvSessionConnectionInfo rvsessioninfo) {
        super(proxy, screenname, rvsessioninfo);
    }

    public OutgoingFileTransferImpl(AimProxyInfo proxy, Screenname screenname, RvSession session) {
        super(proxy, screenname, new MutableSessionConnectionInfo(session));
        ((MutableSessionConnectionInfo)this.getRvSessionInfo()).setMaker(new FileTransferRequestMaker(this));
    }

    @Override
    public void sendRequest(InvitationMessage msg) {
        this.setInvitationMessage(msg);
        this.startStateController(new ChecksumController());
    }

    @Override
    public TransferredFile setSingleFile(File file) throws IOException {
        this.setDisplayName(file.getName());
        return this.addFile(file);
    }

    @Override
    public synchronized String getDisplayName() {
        return this.displayName;
    }

    @Override
    public synchronized List<TransferredFile> getFiles() {
        return DefensiveTools.getUnmodifiableCopy(this.tfiles);
    }

    @Override
    public synchronized TransferredFile addFile(File file) throws IOException {
        return this.addFile(file, file.getName());
    }

    @Override
    public synchronized TransferredFile addFile(File file, String name) throws IOException {
        DefensiveTools.checkNull(file, "file");
        DefensiveTools.checkNull(name, "name");
        this.displayName = null;
        TransferredFile tfile = this.transferredFileFactory.getTransferredFile(file, name);
        this.tfiles.add(tfile);
        return tfile;
    }

    @Override
    public synchronized List<TransferredFile> addFilesInFlatFolder(String folderName, List<File> files) throws IOException {
        DefensiveTools.checkNull(folderName, "folderName");
        DefensiveTools.checkNullElements(files, "files");
        ArrayList<TransferredFile> tfiles = new ArrayList<TransferredFile>(files.size());
        for (File file : files) {
            tfiles.add(this.transferredFileFactory.getTransferredFileInFolder(file, folderName));
        }
        this.tfiles.addAll(tfiles);
        return tfiles;
    }

    @Override
    public synchronized List<TransferredFile> addFilesInHierarchy(@Nullable String folderName, File root, List<File> files) throws IOException {
        DefensiveTools.checkNull(root, "root");
        DefensiveTools.checkNullElements(files, "files");
        ArrayList<TransferredFile> tfiles = new ArrayList<TransferredFile>(files.size());
        for (File file : files) {
            tfiles.add(this.transferredFileFactory.getTransferredFileFromRoot(file, root, folderName));
        }
        this.tfiles.addAll(tfiles);
        return tfiles;
    }

    @Override
    public synchronized void addFilesWithDetails(List<TransferredFile> files) {
        DefensiveTools.checkNullElements(files, "files");
        this.tfiles.addAll(files);
    }

    @Override
    public synchronized void setDisplayName(String name) {
        this.displayName = name;
    }

    @Override
    public FileChecksummer getChecksummer() {
        return this.fileChecksummer;
    }

    @Override
    public synchronized TransferredFileFactory getTransferredFileFactory() {
        return this.transferredFileFactory;
    }

    @Override
    public synchronized void setTransferredFileFactory(TransferredFileFactory transferredFileFactory) {
        this.transferredFileFactory = transferredFileFactory;
    }

    @Override
    public FileSendBlock getRequestFileInfo() {
        String filename;
        int sendType;
        boolean folderMode;
        long totalSize = 0L;
        List<TransferredFile> files = this.getFiles();
        for (TransferredFile file : files) {
            totalSize += file.getSize();
        }
        int numFiles = files.size();
        boolean bl = folderMode = numFiles > 1;
        if (folderMode) {
            sendType = 2;
            filename = this.getDisplayName();
        } else {
            assert (numFiles == 1);
            sendType = 1;
            filename = files.get(0).getTransferredName();
        }
        return new FileSendBlock(sendType, filename, numFiles, totalSize);
    }

    @Override
    protected NextStateControllerInfo getNextControllerFromUnknownError(StateController oldController, FailedStateInfo failedStateInfo, RvConnectionEvent event) {
        if (oldController instanceof SendFileController) {
            return new NextStateControllerInfo(RvConnectionState.FAILED, event == null ? new UnknownErrorEvent() : event);
        }
        throw new IllegalStateException("unknown previous controller " + oldController + ": " + failedStateInfo + ", " + event);
    }

    @Override
    protected NextStateControllerInfo getNextControllerFromSuccess(StateController oldController, StateInfo endState) {
        if (oldController instanceof SendFileController) {
            return new NextStateControllerInfo(RvConnectionState.FINISHED, (RvConnectionEvent)new ConnectionCompleteEvent());
        }
        if (oldController instanceof ChecksumController) {
            if (endState instanceof ComputedChecksumsInfo) {
                ComputedChecksumsInfo info = (ComputedChecksumsInfo)endState;
                this.checksums.putAll(info.getChecksums());
            }
            if (this.getSettings().isOnlyUsingProxy()) {
                return new NextStateControllerInfo(new SendOverProxyController());
            }
            return new NextStateControllerInfo(new SendPassivelyController());
        }
        throw new IllegalStateException("unknown previous controller " + oldController);
    }

    @Override
    protected ConnectedController createConnectedController(StateInfo endState) {
        return new SendFileController();
    }

    @Override
    protected boolean isConnectedController(StateController controller) {
        return controller instanceof SendFileController;
    }

    public RvRequestMaker getRvRequestMaker() {
        return this.helper.getRvRequestMaker();
    }

    @Override
    public InvitationMessage getInvitationMessage() {
        return this.helper.getInvitationMessage();
    }

    private void setInvitationMessage(InvitationMessage msg) {
        this.helper.setInvitationMessage(msg);
    }

    @Override
    public void sendRequest() {
        this.sendRequest(null);
    }

    private class FileChecksummerImpl
    implements FileChecksummer {
        private FileChecksummerImpl() {
        }

        public long getChecksum(TransferredFile mfile) throws IOException {
            Long sum = (Long)OutgoingFileTransferImpl.this.checksums.get(mfile);
            if (sum == null) {
                RandomAccessFile raf = new RandomAccessFile(mfile.getRealFile(), "r");
                ChecksummerImpl summer = new ChecksummerImpl(raf.getChannel(), raf.length());
                OutgoingFileTransferImpl.this.fireEvent(new ChecksummingEvent(mfile, summer));
                sum = summer.compute();
            }
            return sum;
        }
    }
}

