/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.icq.AbstractContactGroupIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ContactGroupIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class RootContactGroupIcqImpl
extends AbstractContactGroupIcqImpl {
    private String ROOT_CONTACT_GROUP_NAME = "ContactListRoot";
    private List<ContactGroup> subGroups = new LinkedList<ContactGroup>();
    private boolean isResolved = false;
    private List<Contact> dummyContacts = new LinkedList<Contact>();
    private final ProtocolProviderServiceIcqImpl protocolProvider;

    RootContactGroupIcqImpl(ProtocolProviderServiceIcqImpl protocolProvider) {
        this.protocolProvider = protocolProvider;
    }

    public boolean canContainSubgroups() {
        return true;
    }

    public String getGroupName() {
        return this.ROOT_CONTACT_GROUP_NAME;
    }

    void addSubGroup(int index, ContactGroupIcqImpl group) {
        this.subGroups.add(index, group);
    }

    void addSubGroup(ContactGroupIcqImpl group) {
        this.addSubGroup(this.countContacts() + this.countSubgroups(), group);
    }

    void removeSubGroup(ContactGroupIcqImpl group) {
        this.removeSubGroup(this.subGroups.indexOf(group));
    }

    void removeSubGroup(int index) {
        this.subGroups.remove(index);
    }

    void reorderSubGroups(List<ContactGroupIcqImpl> newOrder) {
        this.subGroups.removeAll(newOrder);
        this.subGroups.addAll(0, newOrder);
    }

    public int countSubgroups() {
        return this.subGroups.size();
    }

    public ContactGroup getParentContactGroup() {
        return null;
    }

    public ContactGroup getGroup(int index) {
        return this.subGroups.get(index);
    }

    public ContactGroup getGroup(String groupName) {
        Iterator<ContactGroup> subgroups = this.subgroups();
        while (subgroups.hasNext()) {
            ContactGroup grp = subgroups.next();
            if (!grp.getGroupName().equals(groupName)) continue;
            return grp;
        }
        return null;
    }

    public Contact getContact(String id) {
        return null;
    }

    public Iterator<ContactGroup> subgroups() {
        return this.subGroups.iterator();
    }

    public int countContacts() {
        return 0;
    }

    public Iterator<Contact> contacts() {
        return this.dummyContacts.iterator();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(this.getGroupName());
        buff.append(".subGroups=" + this.countSubgroups() + ":\n");
        Iterator<ContactGroup> subGroups = this.subgroups();
        while (subGroups.hasNext()) {
            ContactGroup group = subGroups.next();
            buff.append(group.toString());
            if (!subGroups.hasNext()) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.protocolProvider;
    }

    public boolean isPersistent() {
        return true;
    }

    public String getPersistentData() {
        return null;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public String getUID() {
        return this.getGroupName();
    }
}

