/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.icq.AdHocChatRoomIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.AdHocChatRoomInvitationIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetPersistentPresenceIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.service.protocol.AdHocChatRoom;
import net.java.sip.communicator.service.protocol.AdHocChatRoomInvitation;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetAdHocMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomInvitationListener;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomInvitationReceivedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomInvitationRejectionListener;
import net.java.sip.communicator.service.protocol.event.LocalUserAdHocChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserAdHocChatRoomPresenceListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import net.kano.joscar.OscarTools;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatInvitation;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomManager;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomManagerListener;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomSession;

public class OperationSetAdHocMultiUserChatIcqImpl
implements OperationSetAdHocMultiUserChat {
    private static final Logger logger = Logger.getLogger(OperationSetAdHocMultiUserChatIcqImpl.class);
    private ProtocolProviderServiceIcqImpl icqProvider = null;
    private Vector<AdHocChatRoomInvitationListener> invitationListeners = new Vector();
    private Vector<AdHocChatRoomInvitationRejectionListener> invitationRejectionListeners = new Vector();
    private Vector<LocalUserAdHocChatRoomPresenceListener> presenceListeners = new Vector();
    private Hashtable<String, AdHocChatRoom> chatRoomCache = new Hashtable();
    private RegistrationStateListener providerRegListener = new RegistrationStateListener();
    protected OperationSetPersistentPresenceIcqImpl opSetPersPresence = null;
    private Hashtable<AdHocChatRoom, ChatInvitation> invitations = new Hashtable();

    OperationSetAdHocMultiUserChatIcqImpl(ProtocolProviderServiceIcqImpl icqProvider) {
        this.icqProvider = icqProvider;
        icqProvider.addRegistrationStateChangeListener(this.providerRegListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationListener(AdHocChatRoomInvitationListener listener) {
        Vector<AdHocChatRoomInvitationListener> vector = this.invitationListeners;
        synchronized (vector) {
            if (!this.invitationListeners.contains(listener)) {
                this.invitationListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationRejectionListener(AdHocChatRoomInvitationRejectionListener listener) {
        Vector<AdHocChatRoomInvitationRejectionListener> vector = this.invitationRejectionListeners;
        synchronized (vector) {
            if (!this.invitationRejectionListeners.contains(listener)) {
                this.invitationRejectionListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPresenceListener(LocalUserAdHocChatRoomPresenceListener listener) {
        Vector<LocalUserAdHocChatRoomPresenceListener> vector = this.presenceListeners;
        synchronized (vector) {
            if (!this.presenceListeners.contains(listener)) {
                this.presenceListeners.add(listener);
            }
        }
    }

    public List<AdHocChatRoom> getAdHocChatRooms() {
        return new ArrayList<AdHocChatRoom>(this.chatRoomCache.values());
    }

    public AdHocChatRoom createAdHocChatRoom(String roomName, Map<String, Object> roomProperties) throws OperationFailedException, OperationNotSupportedException {
        AdHocChatRoom chatRoom = null;
        ChatRoomManager chatRoomManager = this.icqProvider.getAimConnection().getChatRoomManager();
        ChatRoomSession chatRoomSession = chatRoomManager.joinRoom(roomName);
        if (chatRoomSession != null) {
            chatRoom = this.createLocalChatRoomInstance(roomName, chatRoomSession);
        }
        return chatRoom;
    }

    public AdHocChatRoom createAdHocChatRoom(String adHocRoomName, List<String> contacts, String reason) throws OperationFailedException, OperationNotSupportedException {
        AdHocChatRoom adHocChatRoom = this.createAdHocChatRoom("chat" + new Date().getTime(), new Hashtable<String, Object>());
        if (adHocChatRoom != null && contacts != null) {
            for (String address : contacts) {
                adHocChatRoom.invite(address, reason);
            }
        }
        return adHocChatRoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdHocChatRoom createLocalChatRoomInstance(ChatInvitation chatInvitation) {
        Hashtable<String, AdHocChatRoom> hashtable = this.chatRoomCache;
        synchronized (hashtable) {
            AdHocChatRoomIcqImpl newChatRoom = new AdHocChatRoomIcqImpl(chatInvitation, this.icqProvider);
            this.chatRoomCache.put(chatInvitation.getRoomName(), newChatRoom);
            return newChatRoom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdHocChatRoom createLocalChatRoomInstance(String roomName, ChatRoomSession chatRoomSession) {
        Hashtable<String, AdHocChatRoom> hashtable = this.chatRoomCache;
        synchronized (hashtable) {
            AdHocChatRoomIcqImpl newChatRoom = new AdHocChatRoomIcqImpl(roomName, chatRoomSession, this.icqProvider);
            this.chatRoomCache.put(roomName, newChatRoom);
            return newChatRoom;
        }
    }

    public void rejectInvitation(AdHocChatRoomInvitation invitation, String rejectReason) {
        ChatInvitation inv = this.invitations.get(invitation.getTargetAdHocChatRoom());
        if (inv != null) {
            inv.reject();
        }
        this.invitations.remove(invitation.getTargetAdHocChatRoom());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationListener(AdHocChatRoomInvitationListener listener) {
        Vector<AdHocChatRoomInvitationListener> vector = this.invitationListeners;
        synchronized (vector) {
            this.invitationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationRejectionListener(AdHocChatRoomInvitationRejectionListener listener) {
        Vector<AdHocChatRoomInvitationRejectionListener> vector = this.invitationRejectionListeners;
        synchronized (vector) {
            this.invitationRejectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePresenceListener(LocalUserAdHocChatRoomPresenceListener listener) {
        Vector<LocalUserAdHocChatRoomPresenceListener> vector = this.presenceListeners;
        synchronized (vector) {
            this.presenceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInvitationEvent(AdHocChatRoom targetChatRoom, String inviter, String reason, byte[] password) {
        ArrayList<AdHocChatRoomInvitationListener> listeners;
        AdHocChatRoomInvitationIcqImpl invitation = new AdHocChatRoomInvitationIcqImpl(targetChatRoom, inviter, reason, password);
        AdHocChatRoomInvitationReceivedEvent evt = new AdHocChatRoomInvitationReceivedEvent((OperationSetAdHocMultiUserChat)this, (AdHocChatRoomInvitation)invitation, new Date(System.currentTimeMillis()));
        Vector<AdHocChatRoomInvitationListener> vector = this.invitationListeners;
        synchronized (vector) {
            listeners = new ArrayList<AdHocChatRoomInvitationListener>(this.invitationListeners);
        }
        for (AdHocChatRoomInvitationListener listener : listeners) {
            listener.invitationReceived(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireLocalUserPresenceEvent(AdHocChatRoom chatRoom, String eventType, String reason) {
        LocalUserAdHocChatRoomPresenceChangeEvent evt = new LocalUserAdHocChatRoomPresenceChangeEvent((OperationSetAdHocMultiUserChat)this, chatRoom, eventType, reason);
        ArrayList<LocalUserAdHocChatRoomPresenceListener> listeners = null;
        Vector<LocalUserAdHocChatRoomPresenceListener> vector = this.presenceListeners;
        synchronized (vector) {
            listeners = new ArrayList<LocalUserAdHocChatRoomPresenceListener>(this.presenceListeners);
        }
        for (LocalUserAdHocChatRoomPresenceListener listener : listeners) {
            listener.localUserAdHocPresenceChanged(evt);
        }
    }

    private class ChatRoomManagerListenerImpl
    implements ChatRoomManagerListener {
        private ChatRoomManagerListenerImpl() {
        }

        @Override
        public void handleInvitation(ChatRoomManager chatRoomManager, ChatInvitation chatInvitation) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invitation received: " + chatInvitation.getRoomName()));
            }
            AdHocChatRoom chatRoom = OperationSetAdHocMultiUserChatIcqImpl.this.createLocalChatRoomInstance(chatInvitation);
            OperationSetAdHocMultiUserChatIcqImpl.this.invitations.put(chatRoom, chatInvitation);
            OperationSetAdHocMultiUserChatIcqImpl.this.fireInvitationEvent(chatRoom, chatInvitation.getScreenname().toString(), chatInvitation.getMessage(), null);
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The ICQ provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                String customMessageEncoding = null;
                customMessageEncoding = System.getProperty("icq.custom.message.charset");
                if (customMessageEncoding != null) {
                    OscarTools.setDefaultCharset(customMessageEncoding);
                }
                OperationSetAdHocMultiUserChatIcqImpl.this.opSetPersPresence = (OperationSetPersistentPresenceIcqImpl)OperationSetAdHocMultiUserChatIcqImpl.this.icqProvider.getOperationSet(OperationSetPersistentPresence.class);
                OperationSetAdHocMultiUserChatIcqImpl.this.icqProvider.getAimConnection().getChatRoomManager().addListener(new ChatRoomManagerListenerImpl());
            }
        }
    }
}

