/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;
import net.kano.joscar.snaccmd.icbm.ParamInfo;

public class ParamInfoCmd
extends IcbmCommand {
    private final ParamInfo paramInfo;

    protected ParamInfoCmd(SnacPacket packet) {
        super(5);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        this.paramInfo = ParamInfo.readParamInfo(snacData);
    }

    public ParamInfoCmd(ParamInfo paramInfo) {
        super(5);
        this.paramInfo = paramInfo;
    }

    public final ParamInfo getParamInfo() {
        return this.paramInfo;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.paramInfo != null) {
            this.paramInfo.write(out);
        }
    }

    public String toString() {
        return "ParamInfoCmd: paramInfo=<" + this.paramInfo + ">";
    }
}

