/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.slick.protocol.icq.IcqSlickFixture;
import net.java.sip.communicator.util.Logger;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icbm.Conversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationListener;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmBuddyInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmService;
import net.kano.joustsim.oscar.oscar.service.icbm.MessageInfo;

public class TestOperationSetBasicInstantMessaging
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetBasicInstantMessaging.class);
    private IcqSlickFixture fixture = new IcqSlickFixture();
    private OperationSetBasicInstantMessaging opSetBasicIM = null;
    private OperationSetPresence opSetPresence = null;

    public TestOperationSetBasicInstantMessaging(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets = this.fixture.provider.getSupportedOperationSets();
        if (supportedOperationSets == null || supportedOperationSets.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this ICQ implementation. ");
        }
        this.opSetBasicIM = (OperationSetBasicInstantMessaging)supportedOperationSets.get(OperationSetBasicInstantMessaging.class.getName());
        if (this.opSetBasicIM == null) {
            throw new NullPointerException("No implementation for basic IM was found");
        }
        this.opSetPresence = (OperationSetPresence)supportedOperationSets.get(OperationSetPresence.class.getName());
        if (this.opSetPresence == null) {
            throw new NullPointerException("An implementation of the ICQ service must provide an implementation of at least one of the PresenceOperationSets");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fixture.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TestOperationSetBasicInstantMessaging.class);
        suite.addTest((Test)new TestOperationSetBasicInstantMessaging("firstTestReceiveMessage"));
        suite.addTest((Test)new TestOperationSetBasicInstantMessaging("thenTestSendMessage"));
        return suite;
    }

    public void firstTestReceiveMessage() {
        String body = "This is an IM coming from the tester agent on " + new Date().toString();
        ImEventCollector evtCollector = new ImEventCollector();
        this.opSetBasicIM.addMessageListener((MessageListener)evtCollector);
        IcqSlickFixture.testerAgent.sendMessage(this.fixture.ourUserID, body);
        evtCollector.waitForEvent(10000L);
        this.opSetBasicIM.removeMessageListener((MessageListener)evtCollector);
        TestOperationSetBasicInstantMessaging.assertTrue((String)"No events delivered upon a received message", (evtCollector.collectedEvents.size() > 0 ? 1 : 0) != 0);
        TestOperationSetBasicInstantMessaging.assertTrue((String)("Received evt was not an instance of " + MessageReceivedEvent.class.getName()), (boolean)(evtCollector.collectedEvents.get(0) instanceof MessageReceivedEvent));
        MessageReceivedEvent evt = (MessageReceivedEvent)evtCollector.collectedEvents.get(0);
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message sender ", (String)evt.getSourceContact().getAddress(), (String)IcqSlickFixture.testerAgent.getIcqUIN());
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message body", (String)body, (String)evt.getSourceMessage().getContent());
    }

    public void thenTestSendMessage() {
        String body = "This is an IM coming from the tested implementation on " + new Date().toString();
        Message msg = this.opSetBasicIM.createMessage(body);
        ImEventCollector imEvtCollector = new ImEventCollector();
        this.opSetBasicIM.addMessageListener((MessageListener)imEvtCollector);
        JoustSimMessageEventCollector jsEvtCollector = new JoustSimMessageEventCollector();
        IcqSlickFixture.testerAgent.addConversationListener(this.fixture.ourUserID, jsEvtCollector);
        Contact testerAgentContact = this.opSetPresence.findContactByID(IcqSlickFixture.testerAgent.getIcqUIN());
        this.opSetBasicIM.sendInstantMessage(testerAgentContact, msg);
        imEvtCollector.waitForEvent(10000L);
        jsEvtCollector.waitForEvent(10000L);
        IcqSlickFixture.testerAgent.removeConversationListener(this.fixture.ourUserID, jsEvtCollector);
        this.opSetBasicIM.removeMessageListener((MessageListener)imEvtCollector);
        TestOperationSetBasicInstantMessaging.assertTrue((String)"No events delivered when sending a message", (imEvtCollector.collectedEvents.size() > 0 ? 1 : 0) != 0);
        TestOperationSetBasicInstantMessaging.assertTrue((String)("Received evt was not an instance of " + MessageDeliveredEvent.class.getName()), (boolean)(imEvtCollector.collectedEvents.get(0) instanceof MessageDeliveredEvent));
        MessageDeliveredEvent evt = (MessageDeliveredEvent)imEvtCollector.collectedEvents.get(0);
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message destination ", (String)evt.getDestinationContact().getAddress(), (String)IcqSlickFixture.testerAgent.getIcqUIN());
        TestOperationSetBasicInstantMessaging.assertSame((String)"source message", (Object)msg, (Object)evt.getSourceMessage());
        TestOperationSetBasicInstantMessaging.assertTrue((String)"No messages received by the tester agent", (jsEvtCollector.collectedMessageInfo.size() > 0 ? 1 : 0) != 0);
        String receivedBody = ((MessageInfo)jsEvtCollector.collectedMessageInfo.get(0)).getMessage().getMessageBody();
        TestOperationSetBasicInstantMessaging.assertEquals((String)"received message body", (String)msg.getContent(), (String)receivedBody);
    }

    public void testCreateMessage1() {
        String body = "This is an IM coming from the tested implementation on " + new Date().toString();
        Message msg = this.opSetBasicIM.createMessage(body);
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message body", (String)body, (String)msg.getContent());
        TestOperationSetBasicInstantMessaging.assertTrue((String)"message body bytes", (boolean)Arrays.equals(body.getBytes(), msg.getRawData()));
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message length", (int)body.length(), (int)msg.getSize());
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message content type", (String)"text/plain", (String)msg.getContentType());
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message encoding", (String)"UTF-8", (String)msg.getEncoding());
        TestOperationSetBasicInstantMessaging.assertNotNull((String)"message uid", (Object)msg.getMessageUID());
        Message msg2 = this.opSetBasicIM.createMessage(body);
        TestOperationSetBasicInstantMessaging.assertFalse((String)"message uid", (boolean)msg.getMessageUID().equals(msg2.getMessageUID()));
    }

    public void testCreateMessage2() {
        String body = "This is an IM coming from the tested implementation on " + new Date().toString();
        String contentType = "text/html";
        String encoding = "UTF-16";
        String subject = "test message";
        Message msg = this.opSetBasicIM.createMessage(body, contentType, encoding, subject);
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message body", (String)body, (String)msg.getContent());
        TestOperationSetBasicInstantMessaging.assertTrue((String)"message body bytes", (boolean)Arrays.equals(body.getBytes(), msg.getRawData()));
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message length", (int)body.length(), (int)msg.getSize());
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message content type", (String)contentType, (String)msg.getContentType());
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message encoding", (String)encoding, (String)msg.getEncoding());
        TestOperationSetBasicInstantMessaging.assertNotNull((String)"message uid", (Object)msg.getMessageUID());
        Message msg2 = this.opSetBasicIM.createMessage(body);
        TestOperationSetBasicInstantMessaging.assertFalse((String)"message uid", (boolean)msg.getMessageUID().equals(msg2.getMessageUID()));
    }

    public void testSendFunMessages() {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getHostName() + ": ";
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String message = hostname + "Hello this is the SIP Communicator (version " + System.getProperty("sip-communicator.version") + ") build on: " + new Date().toString() + ". Have a very nice day!";
        String list = System.getProperty("accounts.reporting.ICQ_REPORT_LIST");
        logger.debug((Object)("Will send message " + message + " to: " + list));
        if (list == null || list.trim().length() == 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(list, " ");
        while (tokenizer.hasMoreTokens()) {
            IcqSlickFixture.testerAgent.sendMessage(tokenizer.nextToken(), message);
        }
    }

    public void testReceiveOfflineMessages() {
        String messageText = IcqSlickFixture.offlineMsgCollector.getMessageText();
        Message receiveMessage = IcqSlickFixture.offlineMsgCollector.getReceivedMessage();
        TestOperationSetBasicInstantMessaging.assertNotNull((String)"No Offline messages have been received", (Object)receiveMessage);
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message body", (String)messageText, (String)receiveMessage.getContent());
    }

    private class JoustSimMessageEventCollector
    implements ConversationListener {
        private List<MessageInfo> collectedMessageInfo = new LinkedList<MessageInfo>();

        private JoustSimMessageEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void gotMessage(Conversation c, MessageInfo minfo) {
            logger.debug((Object)("Message: [" + minfo.getMessage() + "] received from: " + c.getBuddy()));
            JoustSimMessageEventCollector joustSimMessageEventCollector = this;
            synchronized (joustSimMessageEventCollector) {
                this.collectedMessageInfo.add(minfo);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            JoustSimMessageEventCollector joustSimMessageEventCollector = this;
            synchronized (joustSimMessageEventCollector) {
                if (this.collectedMessageInfo.size() > 0) {
                    logger.trace((Object)("evt already received. " + this.collectedMessageInfo));
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }

        public void buddyInfoUpdated(IcbmService service, Screenname buddy, IcbmBuddyInfo info) {
        }

        @Override
        public void conversationClosed(Conversation c) {
        }

        @Override
        public void gotOtherEvent(Conversation conversation, ConversationEventInfo event) {
        }

        @Override
        public void sentOtherEvent(Conversation conversation, ConversationEventInfo event) {
        }

        @Override
        public void canSendMessageChanged(Conversation c, boolean canSend) {
        }

        @Override
        public void conversationOpened(Conversation c) {
        }

        public void newConversation(IcbmService service, Conversation conv) {
        }

        @Override
        public void sentMessage(Conversation c, MessageInfo minfo) {
        }
    }

    private class ImEventCollector
    implements MessageListener {
        private List<EventObject> collectedEvents = new LinkedList<EventObject>();

        private ImEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(MessageReceivedEvent evt) {
            logger.debug((Object)("Received a MessageReceivedEvent: " + evt));
            ImEventCollector imEventCollector = this;
            synchronized (imEventCollector) {
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageDeliveryFailed(MessageDeliveryFailedEvent evt) {
            logger.debug((Object)("Received a MessageDeliveryFailedEvent: " + evt));
            ImEventCollector imEventCollector = this;
            synchronized (imEventCollector) {
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageDelivered(MessageDeliveredEvent evt) {
            logger.debug((Object)("Received a MessageDeliveredEvent: " + evt));
            ImEventCollector imEventCollector = this;
            synchronized (imEventCollector) {
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            ImEventCollector imEventCollector = this;
            synchronized (imEventCollector) {
                if (this.collectedEvents.size() > 0) {
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a message evt", (Throwable)ex);
                }
            }
        }
    }
}

