/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.contactsource;

import java.util.List;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.GenericSourceContact;
import net.java.sip.communicator.service.contactsource.SourceContact;

public class SortedGenericSourceContact
extends GenericSourceContact
implements Comparable<SourceContact> {
    private final ContactQuery parentQuery;

    public SortedGenericSourceContact(ContactQuery parentQuery, ContactSourceService cSourceService, String displayName, List<ContactDetail> contactDetails) {
        super(cSourceService, displayName, contactDetails);
        this.parentQuery = parentQuery;
    }

    @Override
    public int compareTo(SourceContact o) {
        SourceContact target = o;
        int comparePresence = 0;
        if (this.getPresenceStatus() != null && target.getPresenceStatus() != null) {
            int isOnline = this.getPresenceStatus().isOnline() ? 1 : 0;
            int targetIsOnline = target.getPresenceStatus().isOnline() ? 1 : 0;
            comparePresence = 10 - isOnline - (10 - targetIsOnline);
        }
        int compareDDetails = 0;
        if (this.getDisplayDetails() != null && target.getDisplayDetails() != null) {
            compareDDetails = this.getDisplayDetails().compareToIgnoreCase(target.getDisplayDetails());
        }
        return comparePresence * 100000000 + this.getDisplayName().compareToIgnoreCase(target.getDisplayName()) * 10000 + compareDDetails * 100 + String.valueOf(this.hashCode()).compareToIgnoreCase(String.valueOf(o.hashCode()));
    }

    @Override
    public int getIndex() {
        return this.parentQuery.getQueryResults().indexOf(this);
    }
}

