/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.transforms.atom;

import com.google.common.collect.Lists;
import com.google.gdata.data.DateTime;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.Metadata;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.MetadataValueTransform;
import com.google.gdata.model.QName;
import com.google.gdata.model.atom.Author;
import com.google.gdata.model.atom.Category;
import com.google.gdata.model.atom.Content;
import com.google.gdata.model.atom.Contributor;
import com.google.gdata.model.atom.Entry;
import com.google.gdata.model.atom.Feed;
import com.google.gdata.model.atom.Link;
import com.google.gdata.model.atom.OutOfLineContent;
import com.google.gdata.model.atom.Person;
import com.google.gdata.model.atom.Source;
import com.google.gdata.model.atom.TextContent;
import com.google.gdata.model.atompub.Edited;
import com.google.gdata.model.gd.GdAttributes;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import com.google.gdata.wireformats.XmlGenerator;
import com.google.gdata.wireformats.XmlWireFormatProperties;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AtomRssTransforms {
    private static final QName DOMAIN = new QName("domain");
    private static final QName CATEGORY = new QName(Namespaces.rssNs, "category");
    private static final QName ITEM = new QName(Namespaces.rssNs, "item");
    private static final QName GUID = new QName(Namespaces.rssNs, "guid");
    private static final QName TITLE = new QName(Namespaces.rssNs, "title");
    private static final QName PUB_DATE = new QName(Namespaces.rssNs, "pubDate");
    private static final QName AUTHOR = new QName(Namespaces.rssNs, "author");
    private static final QName RSS_NAME = new QName(Namespaces.rssNs, "rss");
    private static final QName DESCRIPTION = new QName(Namespaces.rssNs, "description");
    private static final QName LAST_BUILD_DATE = new QName(Namespaces.rssNs, "lastBuildDate");
    private static final QName COPYRIGHT = new QName(Namespaces.rssNs, "copyright");
    private static final QName MANAGING_EDITOR = new QName(Namespaces.rssNs, "managingEditor");
    private static final QName GENERATOR = new QName(Namespaces.rssNs, "generator");

    public static void addTransforms(MetadataRegistry registry) {
        AtomRssTransforms.addCategoryTransforms(registry);
        AtomRssTransforms.addContentTransforms(registry);
        AtomRssTransforms.addEntryTransforms(registry);
        AtomRssTransforms.addEntryOutOfLineContentTransforms(registry);
        AtomRssTransforms.addFeedTransforms(registry);
        AtomRssTransforms.addLinkTransforms(registry);
        AtomRssTransforms.addSourceTransforms(registry);
        AtomRssTransforms.addPersonTransforms(registry);
        AtomRssTransforms.addGeneratorTransforms(registry);
        AtomRssTransforms.addAppEditedTransforms(registry);
    }

    private static void addCategoryTransforms(MetadataRegistry registry) {
        registry.build(Category.KEY, MetadataContext.RSS).setName(CATEGORY).setVirtualValue(new MetadataValueTransform(Category.TERM, Category.LABEL));
        registry.build(Category.KEY, Category.SCHEME, MetadataContext.RSS).setName(DOMAIN);
        registry.build(Category.KEY, Category.LABEL, MetadataContext.RSS).setVisible(false);
        registry.build(Category.KEY, Category.TERM, MetadataContext.RSS).setVisible(false);
    }

    private static void addContentTransforms(MetadataRegistry registry) {
        registry.build(TextContent.KEY, MetadataContext.RSS).setName(DESCRIPTION).whitelistAttributes(new AttributeKey[0]);
        registry.build(TextContent.CONSTRUCT, MetadataContext.RSS).whitelistAttributes(new AttributeKey[0]);
    }

    private static void addEntryTransforms(MetadataRegistry registry) {
        registry.build(Entry.KEY, MetadataContext.RSS).setName(ITEM);
        registry.build(Entry.KEY, GdAttributes.ETAG, MetadataContext.RSS).setVisible(false);
        XmlWireFormatProperties properties = new XmlWireFormatProperties();
        properties.setElementGenerator(new XmlGenerator.XmlElementGenerator(){

            @Override
            protected List<XmlWriter.Attribute> getAttributes(Element e, ElementMetadata<?, ?> metadata) {
                ArrayList attrs = super.getAttributes(e, metadata);
                if (attrs == null) {
                    attrs = Lists.newArrayListWithExpectedSize((int)1);
                }
                attrs.add(new XmlWriter.Attribute("isPermaLink", "false"));
                return attrs;
            }
        });
        registry.build(Entry.KEY, Entry.ID, MetadataContext.RSS).setName(GUID).setProperties(properties);
        registry.build(Entry.KEY, Entry.TITLE, MetadataContext.RSS).setName(TITLE);
        registry.build(Entry.KEY, Entry.PUBLISHED, MetadataContext.RSS).setName(PUB_DATE).setVirtualValue(new Metadata.VirtualValue(){

            @Override
            public Object generate(Element element, ElementMetadata<?, ?> metadata) {
                DateTime date = element.getTextValue(Entry.PUBLISHED);
                return date == null ? "" : date.toStringRfc822();
            }

            @Override
            public void parse(Element element, ElementMetadata<?, ?> metadata, Object value) throws ParseException {
                DateTime parsed = DateTime.parseRfc822(value.toString());
                element.setTextValue(parsed);
            }
        });
        XmlWireFormatProperties personProperties = new XmlWireFormatProperties();
        personProperties.setElementGenerator(new XmlGenerator.XmlElementGenerator(){

            @Override
            public boolean startElement(XmlWriter xw, Element parent, Element e, ElementMetadata<?, ?> metadata) throws IOException {
                boolean hasEmail;
                if (!(e instanceof Person)) {
                    return super.startElement(xw, parent, e, metadata);
                }
                Person person = (Person)e;
                String email = person.getEmail();
                String name = person.getName();
                StringBuilder text = new StringBuilder();
                boolean bl = hasEmail = email != null;
                if (hasEmail) {
                    text.append(email);
                }
                if (name != null) {
                    if (hasEmail) {
                        text.append(" (");
                    }
                    text.append(name);
                    if (hasEmail) {
                        text.append(")");
                    }
                }
                QName xmlName = this.getName(e, metadata);
                xw.simpleElement(xmlName.getNs(), xmlName.getLocalName(), null, text.toString());
                return false;
            }

            @Override
            public void textContent(XmlWriter xw, Element e, ElementMetadata<?, ?> metadata) {
            }

            @Override
            public void endElement(XmlWriter xw, Element e, ElementMetadata<?, ?> metadata) {
            }
        });
        registry.build(Entry.KEY, Author.KEY, MetadataContext.RSS).setName(AUTHOR).setProperties(personProperties);
        registry.build(Entry.KEY, Contributor.KEY, MetadataContext.RSS).setName(AUTHOR).setProperties(personProperties);
        registry.build(Entry.KEY, Entry.RIGHTS, MetadataContext.RSS).setVisible(false);
    }

    private static void addEntryOutOfLineContentTransforms(MetadataRegistry registry) {
        XmlWireFormatProperties properties = new XmlWireFormatProperties();
        properties.setElementGenerator(new XmlGenerator.XmlElementGenerator(){

            @Override
            public boolean startElement(XmlWriter xw, Element parent, Element e, ElementMetadata<?, ?> metadata) throws IOException {
                if (!(e instanceof OutOfLineContent)) {
                    return super.startElement(xw, parent, e, metadata);
                }
                OutOfLineContent content = (OutOfLineContent)e;
                ContentType type = content.getMimeType();
                URI src = content.getSrc();
                AtomRssTransforms.generateEnclosure(xw, type == null ? null : type.getMediaType(), src == null ? null : src.toString(), content.getLength());
                return false;
            }

            @Override
            public void textContent(XmlWriter xw, Element e, ElementMetadata<?, ?> metadata) {
            }

            @Override
            public void endElement(XmlWriter xw, Element e, ElementMetadata<?, ?> metadata) {
            }
        });
        registry.build(OutOfLineContent.KEY, MetadataContext.RSS).setProperties(properties);
    }

    private static void addFeedTransforms(MetadataRegistry registry) {
        registry.build(Feed.KEY, GdAttributes.ETAG, MetadataContext.RSS).setVisible(false);
        XmlWireFormatProperties properties = new XmlWireFormatProperties();
        properties.setElementGenerator(new XmlGenerator.XmlElementGenerator(){

            @Override
            public boolean startElement(XmlWriter xw, Element parent, Element e, ElementMetadata<?, ?> metadata) throws IOException {
                Collection<XmlNamespace> namespaces = this.getNamespaces(parent, e, metadata);
                ArrayList attrs = this.getAttributes(e, metadata);
                if (attrs == null) {
                    attrs = Lists.newArrayList();
                }
                attrs.add(new XmlWriter.Attribute("version", "2.0"));
                xw.startElement(Namespaces.rssNs, "rss", attrs, namespaces);
                xw.startElement(Namespaces.rssNs, "channel", null, null);
                if (!e.hasElement(Source.SUBTITLE) && !e.hasElement(Content.KEY)) {
                    xw.simpleElement(Namespaces.rssNs, "description", null, "");
                }
                return true;
            }

            @Override
            public void endElement(XmlWriter xw, Element e, ElementMetadata<?, ?> metadata) throws IOException {
                xw.endElement(Namespaces.rssNs, "channel");
                super.endElement(xw, e, metadata);
            }
        });
        registry.build(Feed.KEY, MetadataContext.RSS).setName(RSS_NAME).setProperties(properties);
        registry.build(Feed.KEY, Feed.UPDATED, MetadataContext.RSS).setName(LAST_BUILD_DATE).setVirtualValue(new Metadata.VirtualValue(){

            @Override
            public Object generate(Element element, ElementMetadata<?, ?> metadata) {
                DateTime date = (DateTime)element.getTextValue(Feed.UPDATED);
                return date == null ? "" : date.toStringRfc822();
            }

            @Override
            public void parse(Element element, ElementMetadata<?, ?> metadata, Object value) throws ParseException {
                DateTime parsed = DateTime.parseRfc822(value.toString());
                element.setTextValue(parsed);
            }
        });
    }

    private static void addLinkTransforms(MetadataRegistry registry) {
        XmlWireFormatProperties properties = new XmlWireFormatProperties();
        properties.setElementGenerator(new XmlGenerator.XmlElementGenerator(){

            @Override
            public boolean startElement(XmlWriter xw, Element parent, Element e, ElementMetadata<?, ?> metadata) throws IOException {
                if (!(e instanceof Link)) {
                    return super.startElement(xw, parent, e, metadata);
                }
                Link link = (Link)e;
                String rel = link.getRel();
                String type = link.getType();
                String href = link.getHref();
                long length = link.getLength();
                if (rel != null && rel.equals("enclosure")) {
                    AtomRssTransforms.generateEnclosure(xw, type, href, length);
                } else if ("comments".equals(rel)) {
                    xw.simpleElement(Namespaces.rssNs, "comments", null, href);
                } else if ("alternate".equals(rel)) {
                    xw.simpleElement(Namespaces.rssNs, "link", null, href);
                } else if ("via".equals(rel) && href != null) {
                    List<XmlWriter.Attribute> attrs = Collections.singletonList(new XmlWriter.Attribute("url", href));
                    xw.simpleElement(Namespaces.rssNs, "source", attrs, null);
                }
                return false;
            }

            @Override
            public void textContent(XmlWriter xw, Element e, ElementMetadata<?, ?> metadata) {
            }

            @Override
            public void endElement(XmlWriter xw, Element e, ElementMetadata<?, ?> metadata) {
            }
        });
        registry.build(Link.KEY, MetadataContext.RSS).setProperties(properties);
    }

    private static void addSourceTransforms(MetadataRegistry registry) {
        registry.build(Source.CONSTRUCT, Source.TITLE, MetadataContext.RSS).setName(TITLE);
        registry.build(Source.CONSTRUCT, Source.SUBTITLE, MetadataContext.RSS).setName(DESCRIPTION);
        XmlWireFormatProperties properties = new XmlWireFormatProperties();
        properties.setElementGenerator(new XmlGenerator.XmlElementGenerator(){

            @Override
            public boolean startElement(XmlWriter xw, Element parent, Element e, ElementMetadata<?, ?> metadata) throws IOException {
                Link htmlLink;
                boolean isIcon = e.getElementId().equals(Source.ICON.getId());
                boolean isLogo = e.getElementId().equals(Source.LOGO.getId());
                if (!isIcon && !isLogo || !(parent instanceof Source)) {
                    return super.startElement(xw, parent, e, metadata);
                }
                Source source = (Source)parent;
                if (isIcon && source.hasElement(Source.LOGO)) {
                    return false;
                }
                xw.startElement(Namespaces.rssNs, "image", null, null);
                xw.simpleElement(Namespaces.rssNs, "url", null, String.valueOf(e.getTextValue()));
                TextContent title = source.getTitle();
                if (title != null) {
                    xw.simpleElement(Namespaces.rssNs, "title", null, title.getPlainText());
                }
                if ((htmlLink = source.getHtmlLink()) != null) {
                    xw.simpleElement(Namespaces.rssNs, "link", null, htmlLink.getHref());
                }
                xw.endElement(Namespaces.rssNs, "image");
                return false;
            }

            @Override
            public void textContent(XmlWriter xw, Element e, ElementMetadata<?, ?> metadata) {
            }

            @Override
            public void endElement(XmlWriter xw, Element e, ElementMetadata<?, ?> metadata) {
            }
        });
        registry.build(Source.CONSTRUCT, Source.ICON, MetadataContext.RSS).setProperties(properties);
        registry.build(Source.CONSTRUCT, Source.LOGO, MetadataContext.RSS).setProperties(properties);
        registry.build(Source.CONSTRUCT, Source.RIGHTS, MetadataContext.RSS).setVisible(true).setName(COPYRIGHT);
        registry.build(Source.CONSTRUCT, Author.KEY, MetadataContext.RSS).setName(MANAGING_EDITOR).setVirtualValue(new MetadataValueTransform(Person.NAME));
    }

    private static void addPersonTransforms(MetadataRegistry registry) {
        registry.build(Person.KEY, Person.EMAIL, MetadataContext.RSS).setVisible(false);
        registry.build(Person.KEY, Person.NAME, MetadataContext.RSS).setVisible(false);
        registry.build(Person.KEY, Person.URI, MetadataContext.RSS).setVisible(false);
    }

    private static void addGeneratorTransforms(MetadataRegistry registry) {
        registry.build(Source.Generator.KEY, MetadataContext.RSS).setName(GENERATOR);
        registry.build(Source.Generator.KEY, Source.Generator.URI, MetadataContext.RSS).setVisible(false);
        registry.build(Source.Generator.KEY, Source.Generator.VERSION, MetadataContext.RSS).setVisible(false);
    }

    private static void addAppEditedTransforms(MetadataRegistry registry) {
        registry.build(Edited.KEY, MetadataContext.RSS).setVisible(false);
    }

    private static void generateEnclosure(XmlWriter xw, String type, String href, long length) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(3);
        if (type != null) {
            attrs.add(new XmlWriter.Attribute("type", type));
        }
        if (href != null) {
            attrs.add(new XmlWriter.Attribute("url", href));
        }
        attrs.add(new XmlWriter.Attribute("length", Long.toString(length == -1L ? 0L : length)));
        xw.simpleElement(Namespaces.rssNs, "enclosure", attrs, null);
    }

    private AtomRssTransforms() {
    }
}

