/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atom;

import com.google.gdata.data.IPerson;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.util.Namespaces;
import java.net.URI;
import java.net.URISyntaxException;

public class Person
extends Element
implements IPerson {
    public static final ElementKey<Void, Person> KEY = ElementKey.of(null, Person.class);
    public static final ElementKey<String, Element> EMAIL = ElementKey.of(new QName(Namespaces.atomNs, "email"));
    public static final ElementKey<String, Element> NAME = ElementKey.of(new QName(Namespaces.atomNs, "name"));
    public static final ElementKey<URI, Element> URI = ElementKey.of(new QName(Namespaces.atomNs, "uri"), URI.class, Element.class);

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        registry.build(NAME);
        registry.build(URI);
        registry.build(EMAIL);
        ElementCreator builder = registry.build(KEY).setCardinality(ElementMetadata.Cardinality.MULTIPLE);
        builder.addElement(NAME).setRequired(true);
        builder.addElement(URI);
        builder.addElement(EMAIL);
    }

    public Person() {
        super(KEY);
    }

    protected Person(ElementKey<?, ?> key) {
        super(key);
    }

    protected Person(ElementKey<?, ? extends Person> key, Element source) {
        super(key, source);
    }

    public Person(ElementKey<?, ?> key, String name) {
        super(key);
        if (name == null) {
            throw new NullPointerException("Name must have a value");
        }
        this.setName(name);
    }

    public Person(ElementKey<?, ?> key, String name, URI uri, String email) {
        super(key);
        this.setName(name);
        this.setUri(uri);
        this.setEmail(email);
    }

    @Override
    public String getName() {
        if (!this.hasElement(NAME)) {
            return null;
        }
        return this.getElementValue(NAME);
    }

    public void setName(String v) {
        this.setElement(NAME, v == null ? null : new Element(NAME).setTextValue(v));
    }

    @Override
    public String getNameLang() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public void setNameLang(String v) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    @Deprecated
    public String getUri() {
        URI uri = this.getUriUri();
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    public URI getUriUri() {
        return this.getElementValue(URI);
    }

    @Deprecated
    public void setUri(String v) {
        try {
            this.setUri(v == null ? null : new URI(v));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void setUri(URI v) {
        this.setElement(URI, v == null ? null : new Element(URI).setTextValue(v));
    }

    @Override
    public String getEmail() {
        return this.getElementValue(EMAIL);
    }

    public void setEmail(String v) {
        this.setElement(EMAIL, v == null ? null : new Element(EMAIL).setTextValue(v));
    }
}

