/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atom;

import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.model.atom.Content;
import com.google.gdata.model.atom.Entry;
import com.google.gdata.model.atom.Feed;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.common.util.Base64;
import com.google.gdata.util.common.util.Base64DecoderException;
import java.util.Iterator;

public class OtherContent
extends Content {
    public static final String KIND = "other";
    public static final ElementKey<String, OtherContent> KEY = ElementKey.of(Content.KEY.getId(), String.class, OtherContent.class);

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        Content.registerMetadata(registry);
        ElementCreator builder = registry.build(KEY);
        builder.addElement(Feed.KEY);
        builder.addElement(Entry.KEY);
        registry.adapt(Content.KEY, KIND, KEY);
    }

    public OtherContent() {
        super(KEY);
    }

    public OtherContent(Content content) {
        super(KEY, content);
    }

    protected OtherContent(ElementKey<?, ?> key) {
        super(key);
    }

    @Override
    public int getType() {
        if (this.getXml() != null || this.getXmlContent() != null) {
            return 5;
        }
        if (this.getMimeType().getMediaType().equals("text")) {
            return 4;
        }
        return 6;
    }

    public void setMimeType(ContentType v) {
        this.setAttributeValue(TYPE, (Object)v.getMediaType());
    }

    public XmlBlob getXml() {
        return null;
    }

    public void setXml(XmlBlob v) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public Element getXmlContent() {
        Iterator<Element> iter = this.getElementIterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public void setXmlContent(Element content) {
        this.addElement(content);
    }

    public String getText() {
        return this.getTextValue(KEY);
    }

    public void setText(String v) {
        this.setTextValue(v);
    }

    public byte[] getBytes() {
        String value = this.getText();
        try {
            return value == null ? null : Base64.decode(value);
        }
        catch (Base64DecoderException e) {
            throw new IllegalStateException("Value was not base64 encoded: " + value);
        }
    }

    public void setBytes(byte[] v) {
        this.setText(Base64.encode(v));
    }

    @Override
    protected void validate(ElementMetadata<?, ?> metadata, ValidationContext vc) {
        int maximumChildren;
        super.validate(metadata, vc);
        int n = maximumChildren = this.hasTextValue() ? 0 : 1;
        if (this.getElementCount() > maximumChildren) {
            vc.addError((Element)this, "Content cannot contain more than " + maximumChildren + " child elements, but contains " + this.getElementCount());
        }
    }
}

