/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.io.IOException;
import java.util.Arrays;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.conference.AudioMixerPushBufferStream;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferDataSource;
import org.jitsi.impl.neomedia.control.ControlsAdapter;
import org.jitsi.util.ArrayIOUtils;
import org.jitsi.util.Logger;

public class AudioMixingPushBufferStream
extends ControlsAdapter
implements PushBufferStream {
    private static final Logger logger = Logger.getLogger(AudioMixingPushBufferStream.class);
    private final AudioMixerPushBufferStream audioMixerStream;
    private long bytesRead;
    private final AudioMixingPushBufferDataSource dataSource;
    private short[][] inSamples;
    private int maxInSampleCount;
    private short[] outSamples;
    private final Object readSyncRoot = new Object();
    private long timeStamp = -1L;
    private BufferTransferHandler transferHandler;

    private static int getMaxOutSample(AudioFormat outFormat) throws UnsupportedFormatException {
        switch (outFormat.getSampleSizeInBits()) {
            case 8: {
                return 127;
            }
            case 16: {
                return Short.MAX_VALUE;
            }
            case 32: {
                return Integer.MAX_VALUE;
            }
        }
        throw new UnsupportedFormatException("Format.getSampleSizeInBits()", (Format)outFormat);
    }

    AudioMixingPushBufferStream(AudioMixerPushBufferStream audioMixerStream, AudioMixingPushBufferDataSource dataSource) {
        this.audioMixerStream = audioMixerStream;
        this.dataSource = dataSource;
    }

    private short[] allocateOutSamples(int minSize) {
        short[] outSamples = this.outSamples;
        if (outSamples == null || outSamples.length < minSize) {
            this.outSamples = outSamples = new short[minSize];
        }
        return outSamples;
    }

    public boolean endOfStream() {
        return this.audioMixerStream.endOfStream();
    }

    public ContentDescriptor getContentDescriptor() {
        return this.audioMixerStream.getContentDescriptor();
    }

    public long getContentLength() {
        return this.audioMixerStream.getContentLength();
    }

    public AudioMixingPushBufferDataSource getDataSource() {
        return this.dataSource;
    }

    public AudioFormat getFormat() {
        return this.audioMixerStream.getFormat();
    }

    private short[] mix(short[][] inSamples, AudioFormat outFormat, int outSampleCount) {
        float maxOutSample;
        if (inSamples.length == 1 || inSamples[1] == null) {
            short[] outSamples;
            int inStreamSampleCount;
            short[] inStreamSamples = inSamples[0];
            if (inStreamSamples == null) {
                inStreamSampleCount = 0;
                outSamples = this.allocateOutSamples(outSampleCount);
            } else if (inStreamSamples.length < outSampleCount) {
                inStreamSampleCount = inStreamSamples.length;
                outSamples = this.allocateOutSamples(outSampleCount);
                System.arraycopy(inStreamSamples, 0, outSamples, 0, inStreamSampleCount);
            } else {
                inStreamSampleCount = outSampleCount;
                outSamples = inStreamSamples;
            }
            if (inStreamSampleCount != outSampleCount) {
                Arrays.fill(outSamples, inStreamSampleCount, outSampleCount, (short)0);
            }
            return outSamples;
        }
        short[] outSamples = this.allocateOutSamples(outSampleCount);
        Arrays.fill(outSamples, 0, outSampleCount, (short)0);
        try {
            maxOutSample = AudioMixingPushBufferStream.getMaxOutSample(outFormat);
        }
        catch (UnsupportedFormatException ufex) {
            throw new UnsupportedOperationException(ufex);
        }
        for (short[] inStreamSamples : inSamples) {
            int inStreamSampleCount;
            if (inStreamSamples == null || (inStreamSampleCount = Math.min(inStreamSamples.length, outSampleCount)) == 0) continue;
            for (int i = 0; i < inStreamSampleCount; ++i) {
                short inStreamSample = inStreamSamples[i];
                short outSample = outSamples[i];
                outSamples[i] = (short)(inStreamSample + outSample - Math.round((float)inStreamSample * ((float)outSample / maxOutSample)));
            }
        }
        return outSamples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        long timeStamp;
        int maxInSampleCount;
        short[][] inSamples;
        Object object = this.readSyncRoot;
        synchronized (object) {
            inSamples = this.inSamples;
            maxInSampleCount = this.maxInSampleCount;
            timeStamp = this.timeStamp;
            this.inSamples = null;
            this.maxInSampleCount = 0;
        }
        if (inSamples == null || inSamples.length == 0 || maxInSampleCount <= 0) {
            buffer.setDiscard(true);
            return;
        }
        AudioFormat outFormat = this.getFormat();
        short[] outSamples = this.mix(inSamples, outFormat, maxInSampleCount);
        int outSampleCount = Math.min(maxInSampleCount, outSamples.length);
        if (Format.byteArray.equals(outFormat.getDataType())) {
            int outLength;
            Object o = buffer.getData();
            byte[] outData = null;
            if (o instanceof byte[]) {
                outData = (byte[])o;
            }
            switch (outFormat.getSampleSizeInBits()) {
                case 16: {
                    outLength = outSampleCount * 2;
                    if (outData == null || outData.length < outLength) {
                        outData = new byte[outLength];
                    }
                    for (int i = 0; i < outSampleCount; ++i) {
                        ArrayIOUtils.writeShort(outSamples[i], outData, i * 2);
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("AudioMixingPushBufferStream.read(Buffer)");
                }
            }
            buffer.setData((Object)outData);
            buffer.setFormat((Format)outFormat);
            buffer.setLength(outLength);
            buffer.setOffset(0);
            buffer.setTimeStamp(timeStamp);
            this.bytesRead += (long)outLength;
        } else {
            throw new UnsupportedOperationException("AudioMixingPushBufferStream.read(Buffer)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInSamples(short[][] inSamples, int maxInSampleCount, long timeStamp) {
        Object object = this.readSyncRoot;
        synchronized (object) {
            this.inSamples = inSamples;
            this.maxInSampleCount = maxInSampleCount;
            this.timeStamp = timeStamp;
        }
        BufferTransferHandler transferHandler = this.transferHandler;
        if (transferHandler != null) {
            transferHandler.transferData((PushBufferStream)this);
        }
    }

    public void setTransferHandler(BufferTransferHandler transferHandler) {
        this.transferHandler = transferHandler;
    }

    synchronized void start() throws IOException {
        this.audioMixerStream.addOutStream(this);
        if (logger.isTraceEnabled()) {
            logger.trace("Started " + this.getClass().getSimpleName() + " with hashCode " + this.hashCode());
        }
    }

    synchronized void stop() throws IOException {
        this.audioMixerStream.removeOutStream(this);
        if (logger.isTraceEnabled()) {
            logger.trace("Stopped " + this.getClass().getSimpleName() + " with hashCode " + this.hashCode());
        }
    }
}

