/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.pluginmanager.ManageButtonsPanel;
import net.java.sip.communicator.plugin.pluginmanager.PluginListCellRenderer;
import net.java.sip.communicator.plugin.pluginmanager.PluginManagerActivator;
import net.java.sip.communicator.plugin.pluginmanager.PluginTableModel;
import net.java.sip.communicator.plugin.pluginmanager.Resources;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class PluginManagerPanel
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private final JTable pluginTable = new JTable();
    private final PluginTableModel tableModel = new PluginTableModel();
    private final ManageButtonsPanel buttonsPanel;
    private JCheckBox showSysBundlesCheckBox = new SIPCommCheckBox(Resources.getString("plugin.pluginmanager.SHOW_SYSTEM_BUNDLES"));

    public PluginManagerPanel() {
        super((LayoutManager)new BorderLayout());
        JScrollPane pluginListScrollPane = new JScrollPane();
        this.pluginTable.setModel(this.tableModel);
        TableColumn col = this.pluginTable.getColumnModel().getColumn(0);
        col.setCellRenderer(new PluginListCellRenderer());
        PluginListSelectionListener selectionListener = new PluginListSelectionListener();
        this.pluginTable.getSelectionModel().addListSelectionListener(selectionListener);
        this.pluginTable.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
        this.pluginTable.setRowHeight(48);
        this.pluginTable.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.pluginTable.setTableHeader(null);
        this.buttonsPanel = new ManageButtonsPanel(this.pluginTable);
        this.add(pluginListScrollPane, "Center");
        this.add((Component)((Object)this.buttonsPanel), "East");
        this.initSystemBundleCheckBox();
        pluginListScrollPane.getViewport().add(this.pluginTable);
        pluginListScrollPane.getVerticalScrollBar().setUnitIncrement(30);
        PluginManagerActivator.bundleContext.addBundleListener((BundleListener)new PluginListBundleListener());
    }

    private void initSystemBundleCheckBox() {
        String showSystemBundlesProp = PluginManagerActivator.getConfigurationService().getString("net.java.sip.communicator.plugin.pluginManager.showSystemBundles");
        if (showSystemBundlesProp != null) {
            boolean isShowSystemBundles = new Boolean(showSystemBundlesProp);
            this.showSysBundlesCheckBox.setSelected(isShowSystemBundles);
            ((PluginTableModel)this.pluginTable.getModel()).setShowSystemBundles(isShowSystemBundles);
        }
        this.showSysBundlesCheckBox.addChangeListener(new ShowSystemBundlesChangeListener());
        TransparentPanel checkBoxPanel = new TransparentPanel((LayoutManager)new FlowLayout(0));
        checkBoxPanel.add(this.showSysBundlesCheckBox);
        this.add((Component)checkBoxPanel, "South");
    }

    private class ShowSystemBundlesChangeListener
    implements ChangeListener {
        private boolean currentValue = false;

        public ShowSystemBundlesChangeListener() {
            this.currentValue = PluginManagerPanel.this.showSysBundlesCheckBox.isSelected();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.currentValue == PluginManagerPanel.this.showSysBundlesCheckBox.isSelected()) {
                return;
            }
            this.currentValue = PluginManagerPanel.this.showSysBundlesCheckBox.isSelected();
            PluginManagerActivator.getConfigurationService().setProperty("net.java.sip.communicator.plugin.pluginManager.showSystemBundles", (Object)new Boolean(PluginManagerPanel.this.showSysBundlesCheckBox.isSelected()));
            PluginTableModel tableModel = (PluginTableModel)PluginManagerPanel.this.pluginTable.getModel();
            tableModel.setShowSystemBundles(PluginManagerPanel.this.showSysBundlesCheckBox.isSelected());
            tableModel.update();
            PluginManagerPanel.this.buttonsPanel.defaultButtonState();
        }
    }

    private class PluginListBundleListener
    implements BundleListener {
        private PluginListBundleListener() {
        }

        public void bundleChanged(final BundleEvent event) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PluginListBundleListener.this.bundleChanged(event);
                    }
                });
                return;
            }
            PluginManagerPanel.this.tableModel.update();
            if (event.getType() == 1) {
                PluginManagerPanel.this.pluginTable.scrollRectToVisible(new Rectangle(0, PluginManagerPanel.this.pluginTable.getHeight(), 1, PluginManagerPanel.this.pluginTable.getHeight()));
            }
        }
    }

    private class PluginListSelectionListener
    implements ListSelectionListener {
        private PluginListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = PluginManagerPanel.this.pluginTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            Bundle selectedBundle = (Bundle)PluginManagerPanel.this.pluginTable.getValueAt(selectedRow, 0);
            if (PluginManagerActivator.isSystemBundle(selectedBundle)) {
                PluginManagerPanel.this.buttonsPanel.enableUninstallButton(false);
                PluginManagerPanel.this.buttonsPanel.enableDeactivateButton(false);
                if (selectedBundle.getState() != 32) {
                    PluginManagerPanel.this.buttonsPanel.enableActivateButton(true);
                } else {
                    PluginManagerPanel.this.buttonsPanel.enableActivateButton(false);
                }
            } else {
                PluginManagerPanel.this.buttonsPanel.enableUninstallButton(true);
                if (selectedBundle.getState() != 32) {
                    PluginManagerPanel.this.buttonsPanel.enableActivateButton(true);
                    PluginManagerPanel.this.buttonsPanel.enableDeactivateButton(false);
                } else {
                    PluginManagerPanel.this.buttonsPanel.enableActivateButton(false);
                    PluginManagerPanel.this.buttonsPanel.enableDeactivateButton(true);
                }
            }
            PluginManagerPanel.this.buttonsPanel.enableUpdateButton(true);
        }
    }
}

