/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main;

import com.explodingpixels.macwidgets.HudWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.DialPadFieldUI;
import net.java.sip.communicator.impl.gui.main.GeneralDialPanel;
import net.java.sip.communicator.impl.gui.main.call.CallInterfaceListener;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.DTMFHandler;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextButton;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.plaf.SIPCommTextFieldUI;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.util.OSUtils;

public class GeneralDialPadDialog {
    private final JTextField callField;
    private final JDialog dialPadDialog = OSUtils.IS_MAC ? new HudWindow().getJDialog() : new SIPCommDialog(false);
    private JButton callButton;
    private KeyboardFocusManager keyManager;
    private KeyEventDispatcher keyDispatcher;

    public GeneralDialPadDialog() {
        this.dialPadDialog.setTitle(GuiActivator.getResources().getI18NString("service.gui.DIALPAD"));
        this.callField = new CallField(GuiActivator.getResources().getI18NString("service.gui.ENTER_NAME_OR_NUMBER"));
        this.initInputMap();
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.add((Component)this.callField, "North");
        final DTMFHandler dtmfHandler = new DTMFHandler();
        mainPanel.add((Component)((Object)new GeneralDialPanel(this, dtmfHandler)));
        mainPanel.add((Component)this.createCallPanel(), "South");
        this.dialPadDialog.add((Component)mainPanel);
        this.dialPadDialog.pack();
        this.dialPadDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (GeneralDialPadDialog.this.keyManager == null) {
                    GeneralDialPadDialog.this.keyManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                }
                if (GeneralDialPadDialog.this.keyDispatcher == null) {
                    GeneralDialPadDialog.this.keyDispatcher = new MainKeyDispatcher(GeneralDialPadDialog.this.keyManager);
                }
                GeneralDialPadDialog.this.keyManager.addKeyEventDispatcher(GeneralDialPadDialog.this.keyDispatcher);
                dtmfHandler.addParent(GeneralDialPadDialog.this.dialPadDialog);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                try {
                    if (GeneralDialPadDialog.this.keyManager != null) {
                        GeneralDialPadDialog.this.keyManager.removeKeyEventDispatcher(GeneralDialPadDialog.this.keyDispatcher);
                        GeneralDialPadDialog.this.keyManager = null;
                    }
                    GeneralDialPadDialog.this.keyDispatcher = null;
                }
                finally {
                    dtmfHandler.removeParent(GeneralDialPadDialog.this.dialPadDialog);
                }
            }
        });
    }

    private void initInputMap() {
        InputMap imap = this.dialPadDialog.getRootPane().getInputMap(1);
        imap.put(KeyStroke.getKeyStroke(27, 0), "escape");
        ActionMap amap = this.dialPadDialog.getRootPane().getActionMap();
        amap.put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = GeneralDialPadDialog.this.callField.getText();
                if (text == null || text.length() <= 0) {
                    GeneralDialPadDialog.this.dialPadDialog.setVisible(false);
                } else {
                    GeneralDialPadDialog.this.callField.setText("");
                }
            }
        });
        if (OSUtils.IS_MAC) {
            imap.put(KeyStroke.getKeyStroke(87, 256), "close");
            imap.put(KeyStroke.getKeyStroke(87, 128), "close");
            amap.put("close", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeneralDialPadDialog.this.dialPadDialog.setVisible(false);
                }
            });
        }
    }

    private JComponent createCallPanel() {
        TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
        BufferedImage callButtonImage = ImageLoader.getImage(ImageLoader.DIAL_PAD_CALL_BUTTON_BG);
        this.callButton = new SIPCommTextButton(GuiActivator.getResources().getI18NString("service.gui.CALL"), (Image)callButtonImage);
        this.callButton.setPreferredSize(new Dimension(((Image)callButtonImage).getWidth(null), ((Image)callButtonImage).getHeight(null)));
        this.callButton.setForeground(Color.WHITE);
        this.callButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String callNumber = GeneralDialPadDialog.this.callField.getText();
                if (callNumber != null && callNumber.length() > 0) {
                    CallManager.createCall(GeneralDialPadDialog.this.callField.getText(), GeneralDialPadDialog.this.callButton, new CallInterfaceListener(){

                        @Override
                        public void callInterfaceStarted() {
                            GeneralDialPadDialog.this.dialPadDialog.setVisible(false);
                        }
                    });
                }
            }
        });
        buttonsPanel.add(this.callButton);
        this.dialPadDialog.getRootPane().setDefaultButton(this.callButton);
        return buttonsPanel;
    }

    public void dialButtonPressed(String s) {
        String currentText = this.callField.getText();
        if (currentText == null) {
            currentText = "";
        }
        this.callField.setText(currentText + s);
    }

    public void setVisible(boolean visible) {
        this.dialPadDialog.setLocationRelativeTo((Component)((Object)GuiActivator.getUIService().getMainFrame()));
        this.dialPadDialog.setVisible(visible);
        this.callField.requestFocus();
    }

    public void clear() {
        this.callField.setText("");
    }

    private static class CallField
    extends SIPCommTextField
    implements Skinnable {
        private static final String uiClassID = CallField.class.getName() + "FieldUI";
        private SIPCommTextFieldUI textFieldUI;

        public CallField(String text) {
            super(text);
            if (this.getUI() instanceof DialPadFieldUI) {
                ((DialPadFieldUI)((Object)this.getUI())).setDeleteButtonEnabled(true);
            }
            this.setPreferredSize(new Dimension(200, 23));
            this.setBorder(null);
            this.setOpaque(false);
            this.setDragEnabled(true);
            this.loadSkin();
        }

        public void loadSkin() {
            if (!(this.getUI() instanceof SIPCommTextFieldUI)) {
                return;
            }
            this.textFieldUI = (SIPCommTextFieldUI)this.getUI();
            this.textFieldUI.loadSkin();
            if (OSUtils.IS_MAC) {
                this.textFieldUI.setBgStartColor(Color.BLACK);
                this.textFieldUI.setBgEndColor(Color.BLACK);
                this.textFieldUI.setBgBorderStartColor(Color.DARK_GRAY);
                this.textFieldUI.setBgBorderEndColor(Color.GRAY);
                this.setForegroundColor(Color.WHITE);
                this.setDefaultTextColor(Color.GRAY);
                this.setCaretColor(Color.WHITE);
            }
        }

        public String getUIClassID() {
            return uiClassID;
        }

        static {
            UIManager.getDefaults().put(uiClassID, DialPadFieldUI.class.getName());
        }
    }

    private class MainKeyDispatcher
    implements KeyEventDispatcher {
        private final KeyboardFocusManager keyManager;

        public MainKeyDispatcher(KeyboardFocusManager keyManager) {
            this.keyManager = keyManager;
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (!GeneralDialPadDialog.this.dialPadDialog.isFocused() || e.getID() != 400) {
                return false;
            }
            switch (e.getKeyChar()) {
                case '\b': 
                case '\t': 
                case '\n': 
                case ' ': 
                case '\u007f': 
                case '\uffff': {
                    return false;
                }
            }
            if (!GeneralDialPadDialog.this.callField.isFocusOwner() && this.keyManager.getFocusOwner() != null) {
                GeneralDialPadDialog.this.callField.requestFocusInWindow();
                this.keyManager.redispatchEvent(GeneralDialPadDialog.this.callField, e);
                return true;
            }
            return false;
        }
    }
}

