/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.dns;

import java.io.IOException;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.TXTRecord;

public class SecureMessage
extends Message {
    private boolean secure;
    private boolean bogus;
    private String bogusReason;

    public SecureMessage(Message msg) throws IOException {
        super(msg.toWire());
        this.secure = msg.getHeader().getFlag(10);
        this.bogus = !this.secure && msg.getRcode() == 2;
        for (RRset set : msg.getSectionRRsets(3)) {
            if (!set.getName().equals((Object)Name.root) || set.getType() != 16 || set.getDClass() != 65280) continue;
            this.bogusReason = ((TXTRecord)set.first()).getStrings().get(0).toString();
        }
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isBogus() {
        return this.bogus;
    }

    public String getBogusReason() {
        return this.bogusReason;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(super.toString());
        s.append('\n');
        s.append(";; Secure: ");
        s.append(this.secure);
        s.append('\n');
        s.append(";; Bogus:  ");
        s.append(this.bogus);
        s.append('\n');
        if (this.bogus) {
            s.append(";;  Reason: ");
            s.append(this.bogusReason);
            s.append('\n');
        }
        return s.toString();
    }
}

