/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.rvproxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import org.jetbrains.annotations.Nullable;

public final class RvProxyPacket
implements LiveWritable {
    public static final int PACKETVERSION_DEFAULT = 1098;
    public static final int CMDTYPE_ERROR = 1;
    public static final int CMDTYPE_INIT_SEND = 2;
    public static final int CMDTYPE_INIT_RECV = 4;
    public static final int CMDTYPE_ACK = 3;
    public static final int CMDTYPE_READY = 5;
    public static final int FLAGS_DEFAULT_FROM_SERVER = 544;
    public static final int FLAGS_DEFAULT_FROM_CLIENT = 0;
    private final int packetVersion;
    private final int commandType;
    private final int flags;
    private final ByteBlock data;
    private final int totalSize;
    private final LiveWritable dataWriter;

    @Nullable
    public static RvProxyPacket readPacket(InputStream in) throws IOException {
        int count;
        int count2;
        DefensiveTools.checkNull(in, "in");
        byte[] lenBytes = new byte[2];
        for (int i = 0; i < lenBytes.length; i += count2) {
            count2 = in.read(lenBytes, i, lenBytes.length - i);
            if (count2 != -1) continue;
            return null;
        }
        ByteBlock lenBlock = ByteBlock.wrap(lenBytes);
        int restLength = BinaryTools.getUShort(lenBlock, 0);
        int packetSize = restLength + 2;
        if (restLength < 10) {
            return null;
        }
        byte[] restBytes = new byte[restLength];
        for (int i = 0; i < restBytes.length; i += count) {
            count = in.read(restBytes, i, restBytes.length - i);
            if (count != -1) continue;
            return null;
        }
        ByteBlock rest = ByteBlock.wrap(restBytes);
        int packetVersion = BinaryTools.getUShort(rest, 0);
        int cmdType = BinaryTools.getUShort(rest, 2);
        int flags = BinaryTools.getUShort(rest, 8);
        ByteBlock data = rest.subBlock(10);
        return new RvProxyPacket(packetVersion, cmdType, flags, data, packetSize);
    }

    private RvProxyPacket(int packetVersion, int cmdType, int flags, ByteBlock data, int totalSize) {
        DefensiveTools.checkRange(packetVersion, "packetVersion", 0);
        DefensiveTools.checkRange(cmdType, "cmdType", 0);
        DefensiveTools.checkRange(flags, "flags", 0);
        DefensiveTools.checkRange(totalSize, "totalSize", -1);
        this.packetVersion = packetVersion;
        this.commandType = cmdType;
        this.flags = flags;
        this.data = data;
        this.totalSize = totalSize;
        this.dataWriter = null;
    }

    public RvProxyPacket(final RvProxyCmd rvProxyCmd) {
        this.packetVersion = rvProxyCmd.getPacketVersion();
        this.commandType = rvProxyCmd.getCommandType();
        this.flags = rvProxyCmd.getFlags();
        this.data = null;
        this.dataWriter = new LiveWritable(){

            public void write(OutputStream out) throws IOException {
                rvProxyCmd.writeCommandData(out);
            }
        };
        this.totalSize = -1;
    }

    public final int getPacketVersion() {
        return this.packetVersion;
    }

    public final int getCommandType() {
        return this.commandType;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final ByteBlock getCommandData() {
        return this.data;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream out) throws IOException {
        ByteArrayOutputStream hout = new ByteArrayOutputStream(50);
        BinaryTools.writeUShort(hout, this.packetVersion);
        BinaryTools.writeUShort(hout, this.commandType);
        BinaryTools.writeUInt(hout, 0L);
        BinaryTools.writeUShort(hout, this.flags);
        if (this.dataWriter != null) {
            this.dataWriter.write(hout);
        } else if (this.data != null) {
            this.data.write(hout);
        }
        BinaryTools.writeUShort(out, hout.size());
        hout.writeTo(out);
    }

    public String toString() {
        return "RvProxyPacket: commandType=0x" + Integer.toHexString(this.commandType) + ", flags=0x" + Integer.toHexString(this.flags);
    }
}

