/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.provisioning;

import java.util.Dictionary;
import java.util.Hashtable;
import net.java.sip.communicator.plugin.provisioning.ProvisioningServiceImpl;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.provdisc.ProvisioningDiscoveryService;
import net.java.sip.communicator.service.provisioning.ProvisioningService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.StringUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ProvisioningActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(ProvisioningActivator.class);
    static BundleContext bundleContext = null;
    private static ConfigurationService configurationService = null;
    private static CredentialsStorageService credentialsService = null;
    private static NetworkAddressManagerService netaddrService = null;
    private static UIService uiService;
    private static ResourceManagementService resourceService;
    private static ProvisioningServiceImpl provisioningService;
    private static final String DISABLED_PROP = "net.java.sip.communicator.plugin.provisionconfig.DISABLED";

    public void start(BundleContext bundleContext) throws Exception {
        String method;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Provisioning discovery [STARTED]");
        }
        ProvisioningActivator.bundleContext = bundleContext;
        String url = null;
        provisioningService = new ProvisioningServiceImpl();
        if (!ProvisioningActivator.getConfigurationService().getBoolean(DISABLED_PROP, false)) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("FORM_TYPE", "ADVANCED_TYPE");
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm("net.java.sip.communicator.plugin.provisioning.ProvisioningForm", this.getClass().getClassLoader(), "plugin.provisioning.PLUGIN_ICON", "plugin.provisioning.PROVISIONING", 2000, true), properties);
        }
        if (StringUtils.isNullOrEmpty((String)(method = provisioningService.getProvisioningMethod()), (boolean)true) || method.equals("NONE")) {
            return;
        }
        ServiceReference[] serviceReferences = bundleContext.getServiceReferences(ProvisioningDiscoveryService.class.getName(), null);
        if (serviceReferences != null) {
            for (ServiceReference ref : serviceReferences) {
                ProvisioningDiscoveryService provdisc = (ProvisioningDiscoveryService)bundleContext.getService(ref);
                if (!provdisc.getMethodName().equals(method)) continue;
                url = provdisc.discoverURL();
                break;
            }
        }
        provisioningService.start(url);
        bundleContext.registerService(ProvisioningService.class.getName(), (Object)provisioningService, null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Provisioning discovery [REGISTERED]");
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        ProvisioningActivator.bundleContext = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Provisioning discovery [STOPPED]");
        }
    }

    public static UIService getUIService() {
        if (uiService == null) {
            ServiceReference uiReference = bundleContext.getServiceReference(UIService.class.getName());
            uiService = (UIService)bundleContext.getService(uiReference);
        }
        return uiService;
    }

    public static ResourceManagementService getResourceService() {
        if (resourceService == null) {
            ServiceReference resourceReference = bundleContext.getServiceReference(ResourceManagementService.class.getName());
            resourceService = (ResourceManagementService)bundleContext.getService(resourceReference);
        }
        return resourceService;
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            ServiceReference confReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configurationService = (ConfigurationService)bundleContext.getService(confReference);
        }
        return configurationService;
    }

    public static CredentialsStorageService getCredentialsStorageService() {
        if (credentialsService == null) {
            ServiceReference credentialsReference = bundleContext.getServiceReference(CredentialsStorageService.class.getName());
            credentialsService = (CredentialsStorageService)bundleContext.getService(credentialsReference);
        }
        return credentialsService;
    }

    public static NetworkAddressManagerService getNetworkAddressManagerService() {
        if (netaddrService == null) {
            ServiceReference netaddrReference = bundleContext.getServiceReference(NetworkAddressManagerService.class.getName());
            netaddrService = (NetworkAddressManagerService)bundleContext.getService(netaddrReference);
        }
        return netaddrService;
    }

    public static ProvisioningServiceImpl getProvisioningService() {
        return provisioningService;
    }

    static {
        provisioningService = null;
    }
}

