/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.util.XMLizable;
import org.apache.xmlgraphics.xmp.PropertyAccess;
import org.apache.xmlgraphics.xmp.XMPConstants;
import org.apache.xmlgraphics.xmp.XMPProperty;
import org.apache.xmlgraphics.xmp.XMPSchema;
import org.apache.xmlgraphics.xmp.XMPSchemaRegistry;
import org.apache.xmlgraphics.xmp.merge.MergeRuleSet;
import org.apache.xmlgraphics.xmp.merge.PropertyMerger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Metadata
implements XMLizable,
PropertyAccess {
    private Map properties = new HashMap();

    @Override
    public void setProperty(XMPProperty xMPProperty) {
        this.properties.put(xMPProperty.getName(), xMPProperty);
    }

    @Override
    public XMPProperty getProperty(String string, String string2) {
        return this.getProperty(new QName(string, string2));
    }

    @Override
    public XMPProperty getProperty(QName qName) {
        XMPProperty xMPProperty = (XMPProperty)this.properties.get(qName);
        return xMPProperty;
    }

    @Override
    public XMPProperty removeProperty(QName qName) {
        return (XMPProperty)this.properties.remove(qName);
    }

    @Override
    public XMPProperty getValueProperty() {
        return this.getProperty(XMPConstants.RDF_VALUE);
    }

    @Override
    public int getPropertyCount() {
        return this.properties.size();
    }

    @Override
    public Iterator iterator() {
        return this.properties.keySet().iterator();
    }

    public void mergeInto(Metadata metadata, List<Class> list) {
        XMPSchemaRegistry xMPSchemaRegistry = XMPSchemaRegistry.getInstance();
        for (XMPProperty xMPProperty : this.properties.values()) {
            XMPSchema xMPSchema = xMPSchemaRegistry.getSchema(xMPProperty.getNamespace());
            if (list.contains(xMPSchema.getClass())) continue;
            MergeRuleSet mergeRuleSet = xMPSchema.getDefaultMergeRuleSet();
            PropertyMerger propertyMerger = mergeRuleSet.getPropertyMergerFor(xMPProperty);
            propertyMerger.merge(xMPProperty, metadata);
        }
    }

    @Override
    public void toSAX(ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        contentHandler.startPrefixMapping("x", "adobe:ns:meta/");
        contentHandler.startElement("adobe:ns:meta/", "xmpmeta", "x:xmpmeta", attributesImpl);
        contentHandler.startPrefixMapping("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        contentHandler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF", "rdf:RDF", attributesImpl);
        HashSet<String> hashSet = new HashSet<String>();
        for (QName object : this.properties.keySet()) {
            hashSet.add(object.getNamespaceURI());
        }
        for (String string : hashSet) {
            XMPSchema xMPSchema = XMPSchemaRegistry.getInstance().getSchema(string);
            String string2 = xMPSchema != null ? xMPSchema.getPreferredPrefix() : null;
            boolean bl = true;
            boolean bl2 = true;
            for (XMPProperty xMPProperty : this.properties.values()) {
                if (!xMPProperty.getName().getNamespaceURI().equals(string)) continue;
                if (bl) {
                    if (string2 == null) {
                        string2 = xMPProperty.getName().getPrefix();
                    }
                    attributesImpl.clear();
                    attributesImpl.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", "rdf:about", "CDATA", "");
                    if (string2 != null) {
                        contentHandler.startPrefixMapping(string2, string);
                    }
                    contentHandler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description", "rdf:Description", attributesImpl);
                    bl2 = false;
                    bl = false;
                }
                xMPProperty.toSAX(contentHandler);
            }
            if (bl2) continue;
            contentHandler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description", "rdf:Description");
            if (string2 == null) continue;
            contentHandler.endPrefixMapping(string2);
        }
        contentHandler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF", "rdf:RDF");
        contentHandler.endPrefixMapping("rdf");
        contentHandler.endElement("adobe:ns:meta/", "xmpmeta", "x:xmpmeta");
        contentHandler.endPrefixMapping("x");
    }
}

